/*
 * Decompiled with CFR 0.152.
 */
package com.hw.openai.service;

import com.hw.openai.entity.chat.ChatCompletion;
import com.hw.openai.entity.chat.ChatCompletionResp;
import com.hw.openai.entity.completions.Completion;
import com.hw.openai.entity.completions.CompletionResp;
import com.hw.openai.entity.embeddings.Embedding;
import com.hw.openai.entity.embeddings.EmbeddingResp;
import com.hw.openai.entity.models.Model;
import com.hw.openai.entity.models.ModelResp;
import io.reactivex.Single;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Streaming;

public interface OpenAiService {
    @GET(value="models")
    public Single<ModelResp> listModels();

    @GET(value="models/{model}")
    public Single<Model> retrieveModel(@Path(value="model") String var1);

    @POST(value="completions")
    public Single<CompletionResp> createCompletion(@Body Completion var1);

    @POST(value="{deploymentId}/completions")
    public Single<CompletionResp> createCompletion(@Path(value="deploymentId") String var1, @Query(value="api-version") String var2, @Body Completion var3);

    @Streaming
    @POST(value="completions")
    public Call<ResponseBody> streamCompletion(@Body Completion var1);

    @POST(value="chat/completions")
    public Single<ChatCompletionResp> createChatCompletion(@Body ChatCompletion var1);

    @POST(value="{deploymentId}/chat/completions")
    public Single<ChatCompletionResp> createChatCompletion(@Path(value="deploymentId") String var1, @Query(value="api-version") String var2, @Body ChatCompletion var3);

    @Streaming
    @POST(value="chat/completions")
    public Call<ResponseBody> streamChatCompletion(@Body ChatCompletion var1);

    @POST(value="embeddings")
    public Single<EmbeddingResp> createEmbedding(@Body Embedding var1);

    @POST(value="{deploymentId}/embeddings")
    public Single<EmbeddingResp> createEmbedding(@Path(value="deploymentId") String var1, @Query(value="api-version") String var2, @Body Embedding var3);
}

