/*
 * Decompiled with CFR 0.152.
 */
package com.hw.openai.stream;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.hw.openai.OpenAiClient;
import com.hw.openai.common.OpenAiError;
import com.hw.openai.exception.OpenAiException;
import com.hw.openai.exception.SSEFormatException;
import com.hw.openai.stream.SSE;
import io.reactivex.FlowableEmitter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import lombok.NonNull;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.HttpException;
import retrofit2.Response;

public class ResponseBodyCallback
implements Callback<ResponseBody> {
    private final FlowableEmitter<SSE> emitter;
    private final boolean emitDone;
    private final ObjectMapper objectMapper;

    public ResponseBodyCallback(FlowableEmitter<SSE> emitter, boolean emitDone) {
        this(emitter, emitDone, OpenAiClient.defaultObjectMapper());
    }

    public ResponseBodyCallback(FlowableEmitter<SSE> emitter, boolean emitDone, ObjectMapper objectMapper) {
        this.emitter = emitter;
        this.emitDone = emitDone;
        this.objectMapper = objectMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResponse(@NonNull Call<ResponseBody> call, @NonNull Response<ResponseBody> response) {
        if (call == null) {
            throw new NullPointerException("call is marked non-null but is null");
        }
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        BufferedReader reader = null;
        try {
            if (!response.isSuccessful()) {
                HttpException e = new HttpException(response);
                ResponseBody errorBody = response.errorBody();
                try {
                    if (errorBody == null) {
                        throw e;
                    }
                    OpenAiError error = (OpenAiError)this.objectMapper.readValue(errorBody.string(), OpenAiError.class);
                    throw new OpenAiException(error, (Exception)e, e.code());
                }
                catch (Throwable error) {
                    if (errorBody != null) {
                        try {
                            errorBody.close();
                        }
                        catch (Throwable throwable) {
                            error.addSuppressed(throwable);
                        }
                    }
                    throw error;
                }
            }
            SSE sse = null;
            try (ResponseBody responseBody = (ResponseBody)response.body();){
                if (responseBody != null) {
                    String line;
                    InputStream in = responseBody.byteStream();
                    reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
                    while (!this.emitter.isCancelled() && (line = reader.readLine()) != null) {
                        if (line.startsWith("data:")) {
                            String data = line.substring(5).trim();
                            sse = new SSE(data);
                            continue;
                        }
                        if (line.isEmpty() && sse != null) {
                            if (sse.isDone()) {
                                if (!this.emitDone) break;
                                this.emitter.onNext((Object)sse);
                                break;
                            }
                            this.emitter.onNext((Object)sse);
                            sse = null;
                            continue;
                        }
                        throw new SSEFormatException("Invalid sse format! " + line);
                    }
                }
            }
            this.emitter.onComplete();
        }
        catch (Throwable t) {
            this.onFailure(call, t);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException line) {}
            }
        }
    }

    public void onFailure(@NonNull Call<ResponseBody> call, @NonNull Throwable t) {
        if (call == null) {
            throw new NullPointerException("call is marked non-null but is null");
        }
        if (t == null) {
            throw new NullPointerException("t is marked non-null but is null");
        }
        this.emitter.onError(t);
    }
}

