/*
 * Decompiled with CFR 0.152.
 */
package com.hw.openai.utils;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hw.openai.entity.chat.ChatFunction;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class ChatParameterUtils {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static ChatFunction.ChatParameter generate(Class<?> clazz) {
        Field[] fields;
        ChatFunction.ChatParameter chatParameter = new ChatFunction.ChatParameter();
        chatParameter.setType("object");
        ObjectNode properties = OBJECT_MAPPER.createObjectNode();
        ArrayList<String> required = new ArrayList<String>();
        for (Field field : fields = clazz.getDeclaredFields()) {
            JsonProperty jsonProperty = field.getAnnotation(JsonProperty.class);
            JsonPropertyDescription descriptionAnnotation = field.getAnnotation(JsonPropertyDescription.class);
            String fieldName = jsonProperty != null && !jsonProperty.value().isEmpty() ? jsonProperty.value() : field.getName();
            ObjectNode fieldNode = OBJECT_MAPPER.createObjectNode();
            fieldNode.put("type", ChatParameterUtils.mapJavaTypeToJsonType(field.getType()));
            if (descriptionAnnotation != null) {
                fieldNode.put("description", descriptionAnnotation.value());
            }
            if (field.getType().isEnum()) {
                ArrayNode enumNode = fieldNode.putArray("enum");
                for (Object enumConstant : field.getType().getEnumConstants()) {
                    enumNode.add(enumConstant.toString().toLowerCase());
                }
            }
            properties.set(fieldName, (JsonNode)fieldNode);
            if (jsonProperty == null || !jsonProperty.required()) continue;
            required.add(fieldName);
        }
        chatParameter.setProperties(properties);
        chatParameter.setRequired(required);
        return chatParameter;
    }

    private static String mapJavaTypeToJsonType(Class<?> type) {
        if (type.isEnum() || CharSequence.class.isAssignableFrom(type)) {
            return "string";
        }
        if (Number.class.isAssignableFrom(type) || type == Integer.TYPE || type == Long.TYPE || type == Double.TYPE || type == Float.TYPE) {
            return "number";
        }
        if (type == Boolean.TYPE || Boolean.class.isAssignableFrom(type)) {
            return "boolean";
        }
        if (type.isArray() || List.class.isAssignableFrom(type)) {
            return "array";
        }
        return "object";
    }
}

