/*
 * Decompiled with CFR 0.152.
 */
package com.hw.openai.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;

public class JsonUtils {
    private static final ObjectMapper OBJECT_MAPPER = JsonUtils.createObjectMapper();

    private JsonUtils() {
        throw new IllegalStateException("Utility class");
    }

    private static ObjectMapper createObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        objectMapper.registerModule((Module)new ParameterNamesModule());
        return objectMapper;
    }

    public static String toJsonStringWithIndent(Object object, int indent) {
        try {
            ObjectWriter writer = OBJECT_MAPPER.writer((PrettyPrinter)JsonUtils.getPrettyPrinter(indent));
            return writer.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to format attribute info.", e);
        }
    }

    public static String toJsonStringWithIndent(Object object) {
        return JsonUtils.toJsonStringWithIndent(object, 4);
    }

    public static <T> T convertFromJsonStr(String jsonStr, Class<T> clazz) {
        try {
            return (T)OBJECT_MAPPER.readValue(jsonStr, clazz);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to deserialize json str", e);
        }
    }

    private static DefaultPrettyPrinter getPrettyPrinter(int indent) {
        DefaultPrettyPrinter printer = new DefaultPrettyPrinter();
        printer.indentArraysWith((DefaultPrettyPrinter.Indenter)DefaultPrettyPrinter.FixedSpaceIndenter.instance);
        printer.indentObjectsWith((DefaultPrettyPrinter.Indenter)DefaultIndenter.SYSTEM_LINEFEED_INSTANCE.withIndent(" ".repeat(indent)));
        printer.indentArraysWith((DefaultPrettyPrinter.Indenter)DefaultIndenter.SYSTEM_LINEFEED_INSTANCE.withIndent(" ".repeat(indent)));
        return printer;
    }
}

