/*
 * Decompiled with CFR 0.152.
 */
package com.hw.openai.utils;

import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;

public final class ProxyUtils {
    public static Proxy http(String address, final String username, final String password) {
        URI uri;
        Objects.requireNonNull(address, "Proxy address cannot be null");
        try {
            uri = new URI(address);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid proxy address: " + address, e);
        }
        String hostname = uri.getHost();
        int port = uri.getPort();
        if (username != null && password != null) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(username, password.toCharArray());
                }
            });
        }
        return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(hostname, port));
    }

    private ProxyUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

