/*
 * Decompiled with CFR 0.152.
 */
package com.hw.pinecone.entity.index;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hw.pinecone.entity.index.Metric;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.io.Serializable;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CreateIndexRequest
implements Serializable {
    @NotBlank
    @Size(max=45)
    private @NotBlank @Size(max=45) String name;
    @NotNull
    private Integer dimension;
    @NotNull
    private Metric metric;
    private Integer pods;
    private Integer replicas;
    @JsonProperty(value="pod_type")
    private String podType;
    @JsonProperty(value="metadata_config")
    private Map<String, Object> metadataConfig;
    @JsonProperty(value="source_collection")
    private String sourceCollection;

    private static Metric $default$metric() {
        return Metric.COSINE;
    }

    CreateIndexRequest(String name, Integer dimension, Metric metric, Integer pods, Integer replicas, String podType, Map<String, Object> metadataConfig, String sourceCollection) {
        this.name = name;
        this.dimension = dimension;
        this.metric = metric;
        this.pods = pods;
        this.replicas = replicas;
        this.podType = podType;
        this.metadataConfig = metadataConfig;
        this.sourceCollection = sourceCollection;
    }

    public static CreateIndexRequestBuilder builder() {
        return new CreateIndexRequestBuilder();
    }

    public String getName() {
        return this.name;
    }

    public Integer getDimension() {
        return this.dimension;
    }

    public Metric getMetric() {
        return this.metric;
    }

    public Integer getPods() {
        return this.pods;
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public String getPodType() {
        return this.podType;
    }

    public Map<String, Object> getMetadataConfig() {
        return this.metadataConfig;
    }

    public String getSourceCollection() {
        return this.sourceCollection;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDimension(Integer dimension) {
        this.dimension = dimension;
    }

    public void setMetric(Metric metric) {
        this.metric = metric;
    }

    public void setPods(Integer pods) {
        this.pods = pods;
    }

    public void setReplicas(Integer replicas) {
        this.replicas = replicas;
    }

    @JsonProperty(value="pod_type")
    public void setPodType(String podType) {
        this.podType = podType;
    }

    @JsonProperty(value="metadata_config")
    public void setMetadataConfig(Map<String, Object> metadataConfig) {
        this.metadataConfig = metadataConfig;
    }

    @JsonProperty(value="source_collection")
    public void setSourceCollection(String sourceCollection) {
        this.sourceCollection = sourceCollection;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateIndexRequest)) {
            return false;
        }
        CreateIndexRequest other = (CreateIndexRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$dimension = this.getDimension();
        Integer other$dimension = other.getDimension();
        if (this$dimension == null ? other$dimension != null : !((Object)this$dimension).equals(other$dimension)) {
            return false;
        }
        Integer this$pods = this.getPods();
        Integer other$pods = other.getPods();
        if (this$pods == null ? other$pods != null : !((Object)this$pods).equals(other$pods)) {
            return false;
        }
        Integer this$replicas = this.getReplicas();
        Integer other$replicas = other.getReplicas();
        if (this$replicas == null ? other$replicas != null : !((Object)this$replicas).equals(other$replicas)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Metric this$metric = this.getMetric();
        Metric other$metric = other.getMetric();
        if (this$metric == null ? other$metric != null : !((Object)((Object)this$metric)).equals((Object)other$metric)) {
            return false;
        }
        String this$podType = this.getPodType();
        String other$podType = other.getPodType();
        if (this$podType == null ? other$podType != null : !this$podType.equals(other$podType)) {
            return false;
        }
        Map<String, Object> this$metadataConfig = this.getMetadataConfig();
        Map<String, Object> other$metadataConfig = other.getMetadataConfig();
        if (this$metadataConfig == null ? other$metadataConfig != null : !((Object)this$metadataConfig).equals(other$metadataConfig)) {
            return false;
        }
        String this$sourceCollection = this.getSourceCollection();
        String other$sourceCollection = other.getSourceCollection();
        return !(this$sourceCollection == null ? other$sourceCollection != null : !this$sourceCollection.equals(other$sourceCollection));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CreateIndexRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $dimension = this.getDimension();
        result = result * 59 + ($dimension == null ? 43 : ((Object)$dimension).hashCode());
        Integer $pods = this.getPods();
        result = result * 59 + ($pods == null ? 43 : ((Object)$pods).hashCode());
        Integer $replicas = this.getReplicas();
        result = result * 59 + ($replicas == null ? 43 : ((Object)$replicas).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Metric $metric = this.getMetric();
        result = result * 59 + ($metric == null ? 43 : ((Object)((Object)$metric)).hashCode());
        String $podType = this.getPodType();
        result = result * 59 + ($podType == null ? 43 : $podType.hashCode());
        Map<String, Object> $metadataConfig = this.getMetadataConfig();
        result = result * 59 + ($metadataConfig == null ? 43 : ((Object)$metadataConfig).hashCode());
        String $sourceCollection = this.getSourceCollection();
        result = result * 59 + ($sourceCollection == null ? 43 : $sourceCollection.hashCode());
        return result;
    }

    public String toString() {
        return "CreateIndexRequest(name=" + this.getName() + ", dimension=" + this.getDimension() + ", metric=" + this.getMetric() + ", pods=" + this.getPods() + ", replicas=" + this.getReplicas() + ", podType=" + this.getPodType() + ", metadataConfig=" + this.getMetadataConfig() + ", sourceCollection=" + this.getSourceCollection() + ")";
    }

    public static class CreateIndexRequestBuilder {
        private String name;
        private Integer dimension;
        private boolean metric$set;
        private Metric metric$value;
        private Integer pods;
        private Integer replicas;
        private String podType;
        private Map<String, Object> metadataConfig;
        private String sourceCollection;

        CreateIndexRequestBuilder() {
        }

        public CreateIndexRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        public CreateIndexRequestBuilder dimension(Integer dimension) {
            this.dimension = dimension;
            return this;
        }

        public CreateIndexRequestBuilder metric(Metric metric) {
            this.metric$value = metric;
            this.metric$set = true;
            return this;
        }

        public CreateIndexRequestBuilder pods(Integer pods) {
            this.pods = pods;
            return this;
        }

        public CreateIndexRequestBuilder replicas(Integer replicas) {
            this.replicas = replicas;
            return this;
        }

        @JsonProperty(value="pod_type")
        public CreateIndexRequestBuilder podType(String podType) {
            this.podType = podType;
            return this;
        }

        @JsonProperty(value="metadata_config")
        public CreateIndexRequestBuilder metadataConfig(Map<String, Object> metadataConfig) {
            this.metadataConfig = metadataConfig;
            return this;
        }

        @JsonProperty(value="source_collection")
        public CreateIndexRequestBuilder sourceCollection(String sourceCollection) {
            this.sourceCollection = sourceCollection;
            return this;
        }

        public CreateIndexRequest build() {
            Metric metric$value = this.metric$value;
            if (!this.metric$set) {
                metric$value = CreateIndexRequest.$default$metric();
            }
            return new CreateIndexRequest(this.name, this.dimension, metric$value, this.pods, this.replicas, this.podType, this.metadataConfig, this.sourceCollection);
        }

        public String toString() {
            return "CreateIndexRequest.CreateIndexRequestBuilder(name=" + this.name + ", dimension=" + this.dimension + ", metric$value=" + this.metric$value + ", pods=" + this.pods + ", replicas=" + this.replicas + ", podType=" + this.podType + ", metadataConfig=" + this.metadataConfig + ", sourceCollection=" + this.sourceCollection + ")";
        }
    }
}

