/*
 * Decompiled with CFR 0.152.
 */
package com.hw.pinecone;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.hw.pinecone.IndexClient;
import com.hw.pinecone.entity.index.CreateIndexRequest;
import com.hw.pinecone.entity.index.IndexDescription;
import com.hw.pinecone.service.IndexService;
import com.hw.pinecone.service.VectorService;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.logging.HttpLoggingInterceptor;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class PineconeClient {
    private static final Logger LOG = LoggerFactory.getLogger(PineconeClient.class);
    private String pineconeApiKey;
    private String host;
    private String pineconeEnv;
    private String projectName;
    protected long requestTimeout;
    private OkHttpClient httpClient;
    private IndexService indexService;

    public PineconeClient init() {
        this.pineconeEnv = this.getOrFromEnv(this.pineconeEnv, "PINECONE_ENV");
        Retrofit retrofit = this.createRetrofit(String.format(this.host, this.pineconeEnv));
        this.indexService = (IndexService)retrofit.create(IndexService.class);
        return this;
    }

    public IndexClient indexClient(String name) {
        String baseUrl = "https://" + this.describeIndex(name).getStatus().getHost();
        Retrofit retrofit = this.createRetrofit(baseUrl);
        return new IndexClient((VectorService)retrofit.create(VectorService.class));
    }

    public Retrofit createRetrofit(String baseUrl) {
        OkHttpClient.Builder httpClientBuilder = new OkHttpClient.Builder().connectTimeout(this.requestTimeout, TimeUnit.SECONDS).readTimeout(this.requestTimeout, TimeUnit.SECONDS).writeTimeout(this.requestTimeout, TimeUnit.SECONDS).callTimeout(this.requestTimeout, TimeUnit.SECONDS);
        httpClientBuilder.addInterceptor(chain -> {
            this.pineconeApiKey = this.getOrFromEnv(this.pineconeApiKey, "PINECONE_API_KEY");
            Request request = chain.request().newBuilder().header("Content-Type", "application/json").header("Api-Key", this.pineconeApiKey).build();
            return chain.proceed(request);
        });
        HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor(arg_0 -> ((Logger)LOG).debug(arg_0));
        loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
        httpClientBuilder.addInterceptor((Interceptor)loggingInterceptor);
        this.httpClient = httpClientBuilder.build();
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.findAndRegisterModules();
        return new Retrofit.Builder().baseUrl(baseUrl).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)objectMapper)).client(this.httpClient).build();
    }

    public void close() {
        this.httpClient.dispatcher().cancelAll();
        this.httpClient.connectionPool().evictAll();
        this.httpClient.dispatcher().executorService().shutdown();
    }

    private String getOrFromEnv(String originalValue, String envKey) {
        if (StringUtils.isNotEmpty((CharSequence)originalValue)) {
            return originalValue;
        }
        return System.getenv(envKey);
    }

    public List<String> listIndexes() {
        return (List)this.indexService.listIndexes().blockingGet();
    }

    public void createIndex(CreateIndexRequest request) {
        this.indexService.createIndex(request).blockingGet();
    }

    public IndexDescription describeIndex(String name) {
        return (IndexDescription)this.indexService.describeIndex(name).blockingGet();
    }

    public void deleteIndex(String name) {
        this.indexService.deleteIndex(name).blockingGet();
    }

    private static String $default$host() {
        return "https://controller.%s.pinecone.io";
    }

    private static long $default$requestTimeout() {
        return 16L;
    }

    PineconeClient(String pineconeApiKey, String host, String pineconeEnv, String projectName, long requestTimeout, OkHttpClient httpClient, IndexService indexService) {
        this.pineconeApiKey = pineconeApiKey;
        this.host = host;
        this.pineconeEnv = pineconeEnv;
        this.projectName = projectName;
        this.requestTimeout = requestTimeout;
        this.httpClient = httpClient;
        this.indexService = indexService;
    }

    public static PineconeClientBuilder builder() {
        return new PineconeClientBuilder();
    }

    public String getPineconeApiKey() {
        return this.pineconeApiKey;
    }

    public String getHost() {
        return this.host;
    }

    public String getPineconeEnv() {
        return this.pineconeEnv;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public long getRequestTimeout() {
        return this.requestTimeout;
    }

    public OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    public IndexService getIndexService() {
        return this.indexService;
    }

    public void setPineconeApiKey(String pineconeApiKey) {
        this.pineconeApiKey = pineconeApiKey;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPineconeEnv(String pineconeEnv) {
        this.pineconeEnv = pineconeEnv;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setRequestTimeout(long requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public void setHttpClient(OkHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public void setIndexService(IndexService indexService) {
        this.indexService = indexService;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PineconeClient)) {
            return false;
        }
        PineconeClient other = (PineconeClient)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getRequestTimeout() != other.getRequestTimeout()) {
            return false;
        }
        String this$pineconeApiKey = this.getPineconeApiKey();
        String other$pineconeApiKey = other.getPineconeApiKey();
        if (this$pineconeApiKey == null ? other$pineconeApiKey != null : !this$pineconeApiKey.equals(other$pineconeApiKey)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$pineconeEnv = this.getPineconeEnv();
        String other$pineconeEnv = other.getPineconeEnv();
        if (this$pineconeEnv == null ? other$pineconeEnv != null : !this$pineconeEnv.equals(other$pineconeEnv)) {
            return false;
        }
        String this$projectName = this.getProjectName();
        String other$projectName = other.getProjectName();
        if (this$projectName == null ? other$projectName != null : !this$projectName.equals(other$projectName)) {
            return false;
        }
        OkHttpClient this$httpClient = this.getHttpClient();
        OkHttpClient other$httpClient = other.getHttpClient();
        if (this$httpClient == null ? other$httpClient != null : !this$httpClient.equals(other$httpClient)) {
            return false;
        }
        IndexService this$indexService = this.getIndexService();
        IndexService other$indexService = other.getIndexService();
        return !(this$indexService == null ? other$indexService != null : !this$indexService.equals(other$indexService));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PineconeClient;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $requestTimeout = this.getRequestTimeout();
        result = result * 59 + (int)($requestTimeout >>> 32 ^ $requestTimeout);
        String $pineconeApiKey = this.getPineconeApiKey();
        result = result * 59 + ($pineconeApiKey == null ? 43 : $pineconeApiKey.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $pineconeEnv = this.getPineconeEnv();
        result = result * 59 + ($pineconeEnv == null ? 43 : $pineconeEnv.hashCode());
        String $projectName = this.getProjectName();
        result = result * 59 + ($projectName == null ? 43 : $projectName.hashCode());
        OkHttpClient $httpClient = this.getHttpClient();
        result = result * 59 + ($httpClient == null ? 43 : $httpClient.hashCode());
        IndexService $indexService = this.getIndexService();
        result = result * 59 + ($indexService == null ? 43 : $indexService.hashCode());
        return result;
    }

    public String toString() {
        return "PineconeClient(pineconeApiKey=" + this.getPineconeApiKey() + ", host=" + this.getHost() + ", pineconeEnv=" + this.getPineconeEnv() + ", projectName=" + this.getProjectName() + ", requestTimeout=" + this.getRequestTimeout() + ", httpClient=" + this.getHttpClient() + ", indexService=" + this.getIndexService() + ")";
    }

    public static class PineconeClientBuilder {
        private String pineconeApiKey;
        private boolean host$set;
        private String host$value;
        private String pineconeEnv;
        private String projectName;
        private boolean requestTimeout$set;
        private long requestTimeout$value;
        private OkHttpClient httpClient;
        private IndexService indexService;

        PineconeClientBuilder() {
        }

        public PineconeClientBuilder pineconeApiKey(String pineconeApiKey) {
            this.pineconeApiKey = pineconeApiKey;
            return this;
        }

        public PineconeClientBuilder host(String host) {
            this.host$value = host;
            this.host$set = true;
            return this;
        }

        public PineconeClientBuilder pineconeEnv(String pineconeEnv) {
            this.pineconeEnv = pineconeEnv;
            return this;
        }

        public PineconeClientBuilder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public PineconeClientBuilder requestTimeout(long requestTimeout) {
            this.requestTimeout$value = requestTimeout;
            this.requestTimeout$set = true;
            return this;
        }

        public PineconeClientBuilder httpClient(OkHttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public PineconeClientBuilder indexService(IndexService indexService) {
            this.indexService = indexService;
            return this;
        }

        public PineconeClient build() {
            String host$value = this.host$value;
            if (!this.host$set) {
                host$value = PineconeClient.$default$host();
            }
            long requestTimeout$value = this.requestTimeout$value;
            if (!this.requestTimeout$set) {
                requestTimeout$value = PineconeClient.$default$requestTimeout();
            }
            return new PineconeClient(this.pineconeApiKey, host$value, this.pineconeEnv, this.projectName, requestTimeout$value, this.httpClient, this.indexService);
        }

        public String toString() {
            return "PineconeClient.PineconeClientBuilder(pineconeApiKey=" + this.pineconeApiKey + ", host$value=" + this.host$value + ", pineconeEnv=" + this.pineconeEnv + ", projectName=" + this.projectName + ", requestTimeout$value=" + this.requestTimeout$value + ", httpClient=" + this.httpClient + ", indexService=" + this.indexService + ")";
        }
    }
}

