/*
 * Decompiled with CFR 0.152.
 */
package com.hw.serpapi;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hw.serpapi.SerpApiHttpClient;
import com.hw.serpapi.SerpApiSearchException;
import java.util.HashMap;
import java.util.Map;

public class SerpApiSearch {
    public static final String API_KEY_NAME = "api_key";
    protected String serpapiApiKey;
    protected String engine;
    public Map<String, String> parameter;
    private static Gson gson = new Gson();
    public SerpApiHttpClient search;

    public SerpApiSearch(Map<String, String> parameter, String serpapiApiKey, String engine) {
        this.parameter = parameter;
        this.serpapiApiKey = serpapiApiKey;
        this.engine = engine;
    }

    public SerpApiSearch(Map<String, String> parameter, String engine) {
        this.parameter = parameter;
        this.engine = engine;
    }

    public SerpApiSearch(String engine) {
        this.parameter = new HashMap<String, String>();
        this.engine = engine;
    }

    public SerpApiSearch(String serpapiApiKey, String engine) {
        this.serpapiApiKey = serpapiApiKey;
        this.engine = engine;
    }

    public Map<String, String> buildQuery(String path, String output) throws SerpApiSearchException {
        if (this.search == null) {
            this.search = new SerpApiHttpClient(path);
            this.search.setHttpConnectionTimeout(6000);
        } else {
            this.search.path = path;
        }
        this.parameter.put("source", "java");
        if (this.parameter.get(API_KEY_NAME) == null) {
            if (this.serpapiApiKey != null) {
                this.parameter.put(API_KEY_NAME, this.serpapiApiKey);
            } else if (SerpApiSearch.getApiKeyFromEnv() != null) {
                this.parameter.put(API_KEY_NAME, SerpApiSearch.getApiKeyFromEnv());
            } else {
                throw new SerpApiSearchException("api_key is not defined");
            }
        }
        this.parameter.put("engine", this.engine);
        this.parameter.put("output", output);
        return this.parameter;
    }

    public static String getApiKeyFromEnv() {
        return System.getenv("SERPAPI_API_KEY");
    }

    public String getHtml() throws SerpApiSearchException {
        Map<String, String> query = this.buildQuery("/search", "html");
        return this.search.getResults(query);
    }

    public JsonObject getJson() throws SerpApiSearchException {
        Map<String, String> query = this.buildQuery("/search", "json");
        return this.asJson(this.search.getResults(query));
    }

    public JsonObject asJson(String content) {
        JsonElement element = (JsonElement)gson.fromJson(content, JsonElement.class);
        return element.getAsJsonObject();
    }

    public SerpApiHttpClient getClient() {
        return this.search;
    }

    public JsonArray getLocation(String q, Integer limit) throws SerpApiSearchException {
        Map<String, String> query = this.buildQuery("/locations.json", "json");
        query.remove("output");
        query.remove(API_KEY_NAME);
        query.put("q", q);
        query.put("limit", limit.toString());
        String s = this.search.getResults(query);
        return (JsonArray)gson.fromJson(s, JsonArray.class);
    }

    public JsonObject getSearchArchive(String searchID) throws SerpApiSearchException {
        Map<String, String> query = this.buildQuery("/searches/" + searchID + ".json", "json");
        query.remove("output");
        query.remove("q");
        return this.asJson(this.search.getResults(query));
    }

    public JsonObject getAccount() throws SerpApiSearchException {
        Map<String, String> query = this.buildQuery("/account", "json");
        query.remove("output");
        query.remove("q");
        return this.asJson(this.search.getResults(query));
    }

    public void setParameter(Map<String, String> parameter) {
        this.parameter = parameter;
    }
}

