/*
 * Decompiled with CFR 0.152.
 */
package com.zhangyue.lancet.internal.asm.visitor;

import com.zhangyue.lancet.internal.util.PrimitiveUtil;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class AutoUnboxMethodVisitor
extends MethodVisitor {
    private boolean flag = false;
    private String lastOwner;

    public AutoUnboxMethodVisitor(MethodVisitor methodVisitor) {
        super(327680, methodVisitor);
    }

    public void markBoxed() {
        this.flag = true;
    }

    public void visitInsn(int opcode) {
        this.clearFlag();
        super.visitInsn(opcode);
    }

    private void clearFlag() {
        this.flag = false;
    }

    public void visitIntInsn(int opcode, int operand) {
        this.clearFlag();
        super.visitIntInsn(opcode, operand);
    }

    public void visitVarInsn(int opcode, int var) {
        this.clearFlag();
        super.visitVarInsn(opcode, var);
    }

    public void visitTypeInsn(int opcode, String type) {
        if (this.flag && opcode == 192 && !type.equals(this.lastOwner) && PrimitiveUtil.boxedNumberTypes().contains(type)) {
            if (this.lastOwner == null || !PrimitiveUtil.boxedNumberTypes().contains(this.lastOwner)) {
                throw new IllegalStateException("can't cast bool or char to number");
            }
            String method = PrimitiveUtil.unboxMethod(type);
            String primitive = PrimitiveUtil.unbox(type);
            super.visitMethodInsn(182, "java/lang/Number", method, "()" + primitive, false);
            super.visitMethodInsn(184, type, "valueOf", "(" + primitive + ")L" + type + ";", false);
        }
        this.clearFlag();
        super.visitTypeInsn(opcode, type);
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        this.clearFlag();
        super.visitFieldInsn(opcode, owner, name, desc);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        this.clearFlag();
        super.visitMethodInsn(opcode, owner, name, desc);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        this.lastOwner = owner;
        this.clearFlag();
        super.visitMethodInsn(opcode, owner, name, desc, itf);
    }

    public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
        this.clearFlag();
        super.visitInvokeDynamicInsn(name, desc, bsm, bsmArgs);
    }

    public void visitJumpInsn(int opcode, Label label) {
        this.clearFlag();
        super.visitJumpInsn(opcode, label);
    }

    public void visitLdcInsn(Object cst) {
        this.clearFlag();
        super.visitLdcInsn(cst);
    }

    public void visitIincInsn(int var, int increment) {
        this.clearFlag();
        super.visitIincInsn(var, increment);
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        this.clearFlag();
        super.visitTableSwitchInsn(min, max, dflt, labels);
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.clearFlag();
        super.visitLookupSwitchInsn(dflt, keys, labels);
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.clearFlag();
        super.visitMultiANewArrayInsn(desc, dims);
    }

    public void visitEnd() {
        this.clearFlag();
        super.visitEnd();
    }
}

