/*
 * Decompiled with CFR 0.152.
 */
package com.zhangyue.lancet.internal.asm.visitor;

import com.zhangyue.lancet.internal.asm.visitor.BaseWeaveClassVisitor;
import com.zhangyue.lancet.internal.entity.TransformInfo;
import com.zhangyue.lancet.internal.util.TypeUtils;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class HookClassVisitor
extends BaseWeaveClassVisitor {
    private final TransformInfo transformInfo;
    private boolean isWeaveClass;
    private ClassVisitor originalClassVisitor;
    private boolean skipped = false;

    public HookClassVisitor(TransformInfo transformInfo, ClassVisitor originalClassVisitor) {
        this.transformInfo = transformInfo;
        this.originalClassVisitor = originalClassVisitor;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.transformer.getMethodChain().init(name, this.originalClassVisitor);
        this.transformer.className = name;
        this.transformer.superName = superName;
        if (this.transformInfo.isWeaverClass(name)) {
            this.isWeaveClass = true;
            this.skipWeaveVisitor();
        }
        super.visit(version, access, name, signature, superName, interfaces);
    }

    private void skipWeaveVisitor() {
        if (this.skipped) {
            return;
        }
        this.cv = this.transformer.tailVisitor.nextClassVisitor;
        this.skipped = true;
    }

    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        return super.visitAnnotation(descriptor, visible);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (this.isWeaveClass) {
            return super.visitMethod(TypeUtils.resetAccessScope(access, 1), name, desc, signature, exceptions);
        }
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    public void visitEnd() {
        super.visitEnd();
        this.transformer.generateInnerClasses();
    }
}

