/*
 * Decompiled with CFR 0.152.
 */
package com.zhangyue.lancet.internal.asm.visitor;

import com.zhangyue.lancet.internal.asm.visitor.BaseWeaveClassVisitor;
import com.zhangyue.lancet.internal.asm.visitor.TraceMethodVisitor;
import com.zhangyue.lancet.plugin.LancetContext;
import com.zhangyue.lancet.plugin.LancetExtension;
import org.objectweb.asm.MethodVisitor;

public class MethodTraceClassVisitor
extends BaseWeaveClassVisitor {
    String mClassName;

    public void visitSource(String source, String debug) {
        super.visitSource(source, debug);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        if (name != null) {
            this.mClassName = name;
        }
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        String myTrace = ((LancetExtension)LancetContext.instance().extension).getMyTrace();
        if (this.shouldTrace(this.mClassName, name) && !myTrace.isEmpty()) {
            MethodVisitor methodVisitor = super.visitMethod(access, name, desc, signature, exceptions);
            return new TraceMethodVisitor(methodVisitor, access, name, desc, this.mClassName, myTrace);
        }
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    private boolean shouldTrace(String className, String name) {
        boolean isNotConstruct = true;
        if (className.contains("MyTrace")) {
            return false;
        }
        if (!((LancetExtension)LancetContext.instance().extension).shouldTrace(this.mClassName, name)) {
            return false;
        }
        if (name != null && (name.contains("<clinit>") || name.contains("<init>"))) {
            isNotConstruct = false;
        }
        return isNotConstruct;
    }
}

