/*
 * Decompiled with CFR 0.152.
 */
package com.zhangyue.lancet.internal.asm.visitor;

import com.zhangyue.lancet.internal.asm.visitor.BaseWeaveClassVisitor;
import com.zhangyue.lancet.internal.asm.visitor.MethodChain;
import com.zhangyue.lancet.internal.asm.visitor.ProxyMethodVisitor;
import com.zhangyue.lancet.internal.entity.ProxyInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.objectweb.asm.MethodVisitor;

public class ProxyClassVisitor
extends BaseWeaveClassVisitor {
    private List<ProxyInfo> infos;
    private Map<String, List<ProxyInfo>> matches;
    private Map<String, MethodChain.Invoker> maps = new HashMap<String, MethodChain.Invoker>();

    public ProxyClassVisitor(List<ProxyInfo> infos) {
        this.infos = infos;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.matches = this.infos.stream().filter(t -> t.match(name)).collect(Collectors.groupingBy(t -> t.targetClass + " " + t.targetMethod + " " + t.targetDesc));
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        super.visitInnerClass(name, outerName, innerName, access);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (this.matches.size() > 0) {
            mv = new ProxyMethodVisitor(this.transformer.methodChain, mv, this.maps, this.matches, this.transformer.className, name, this.transformer);
        }
        return mv;
    }
}

