/*
 * Decompiled with CFR 0.152.
 */
package com.zhangyue.lancet.internal.asm.visitor;

import com.zhangyue.lancet.internal.asm.visitor.BaseWeaveClassVisitor;
import com.zhangyue.lancet.internal.entity.ReplaceInvokeInfo;
import com.zhangyue.lancet.internal.entity.TransformInfo;
import com.zhangyue.lancet.plugin.LancetContext;
import com.zhangyue.lancet.plugin.LancetExtension;
import com.zhangyue.lancet.plugin.WeaveGroup;
import java.util.List;
import org.objectweb.asm.MethodVisitor;

public class ReplaceNewThreadVisitor
extends BaseWeaveClassVisitor {
    private final List<ReplaceInvokeInfo> replaceInvokes;
    private String thread_factory = "java/util/concurrent/ThreadFactory";
    String className;
    boolean isThreadFactory;

    public ReplaceNewThreadVisitor(TransformInfo transformInfo) {
        this.replaceInvokes = transformInfo.replaceInvokes;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        if (interfaces != null) {
            for (String anInterface : interfaces) {
                if (!anInterface.contains(this.thread_factory)) continue;
                this.isThreadFactory = true;
                break;
            }
        }
        this.className = name;
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        if (this.className == null || this.className.isEmpty()) {
            return super.visitMethod(access, name, descriptor, signature, exceptions);
        }
        if (this.isThreadFactory) {
            return super.visitMethod(access, name, descriptor, signature, exceptions);
        }
        if (this.className.contains("com/weaver")) {
            return super.visitMethod(access, name, descriptor, signature, exceptions);
        }
        MethodVisitor methodVisitor = super.visitMethod(access, name, descriptor, signature, exceptions);
        return new ReplaceNewInstructionVisitor(methodVisitor);
    }

    private boolean shouldReplace(String className, ReplaceInvokeInfo invokeInfo) {
        List<String> whiteNames;
        if (invokeInfo == null) {
            return false;
        }
        if (!invokeInfo.getTargetClassType().contains("java/lang/Thread")) {
            return false;
        }
        System.out.println("shouldReplace=className=" + className + ",invokeInfo= " + invokeInfo.classNode.name);
        String replaceInvokeClass = invokeInfo.classNode.name;
        String weaverGroupName = LancetContext.instance().getWeaverGroupName(replaceInvokeClass);
        WeaveGroup group = ((LancetExtension)LancetContext.instance().extension).findWeaveGroup(weaverGroupName);
        if (group == null) {
            return true;
        }
        List<String> blackNames = group.getBlackNames();
        if (blackNames != null && blackNames.size() > 0) {
            for (String blackName : blackNames) {
                if (!className.contains(blackName)) continue;
                return false;
            }
            System.out.println("shouldReplace=blackNames=" + blackNames.get(0));
        }
        if ((whiteNames = group.getWhiteNames()) != null && whiteNames.size() > 0) {
            for (String whiteName : whiteNames) {
                if (!className.contains(whiteName)) continue;
                return true;
            }
            System.out.println("shouldReplace=whiteNames=" + whiteNames.get(0));
        }
        return whiteNames == null || whiteNames.size() == 0;
    }

    class ReplaceNewInstructionVisitor
    extends MethodVisitor {
        private ReplaceInvokeInfo replaceInvokeInfo;

        public ReplaceNewInstructionVisitor(MethodVisitor methodVisitor) {
            super(458752, methodVisitor);
            this.replaceInvokeInfo = null;
        }

        public void visitTypeInsn(int opcode, String type) {
            if (opcode == 187) {
                for (ReplaceInvokeInfo invokeInfo : ReplaceNewThreadVisitor.this.replaceInvokes) {
                    if (!invokeInfo.getTargetClassType().equals(type) || !ReplaceNewThreadVisitor.this.shouldReplace(ReplaceNewThreadVisitor.this.className, invokeInfo)) continue;
                    String newType = invokeInfo.getNewClassType();
                    this.replaceInvokeInfo = invokeInfo;
                    System.out.println("ReplaceInvokeInfo=type=" + type + ",newType= " + newType + ",className=" + ReplaceNewThreadVisitor.this.className);
                    type = newType;
                    break;
                }
            }
            super.visitTypeInsn(opcode, type);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
            if (this.replaceInvokeInfo != null && "<init>".equals(name) && owner.equals(this.replaceInvokeInfo.getTargetClassType()) && ReplaceNewThreadVisitor.this.shouldReplace(ReplaceNewThreadVisitor.this.className, this.replaceInvokeInfo)) {
                System.out.println("ReplaceInvokeInfo2222=owner=" + owner + ",getTargetClassType= " + this.replaceInvokeInfo.getTargetClassType() + ",descriptor=" + descriptor);
                owner = this.replaceInvokeInfo.getNewClassType();
                if (descriptor.equals("()V")) {
                    descriptor = "(Ljava/lang/String;)V";
                    this.mv.visitLdcInsn((Object)ReplaceNewThreadVisitor.this.className);
                } else if (descriptor.equals("(Ljava/lang/Runnable;)V")) {
                    descriptor = "(Ljava/lang/Runnable;Ljava/lang/String;)V";
                    this.mv.visitLdcInsn((Object)ReplaceNewThreadVisitor.this.className);
                }
            }
            super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
        }
    }
}

