/*
 * Decompiled with CFR 0.152.
 */
package com.zhangyue.lancet.internal.asm.visitor;

import com.zhangyue.lancet.internal.entity.ReplaceInfo;
import com.zhangyue.lancet.plugin.LancetContext;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.AdviceAdapter;

public class ReplaceWeaveMethodVisitor
extends AdviceAdapter {
    private final List<ReplaceInfo> matchMap;
    private final String className;
    private final String methodName;

    public ReplaceWeaveMethodVisitor(MethodVisitor mv, int access, String methodName, String desc, List<ReplaceInfo> matchMap, String className) {
        super(327680, mv, access, methodName, desc);
        this.className = className;
        this.methodDesc = desc;
        this.matchMap = matchMap;
        this.methodName = methodName;
    }

    public void visitInsn(int opcode) {
        super.visitInsn(opcode);
    }

    public void visitMethodInsn(int opcode, final String owner, final String name, final String desc, boolean itf) {
        List replaceInfoList = this.matchMap.stream().filter(new Predicate<ReplaceInfo>(){

            @Override
            public boolean test(ReplaceInfo replaceInfo) {
                return replaceInfo.targetClassName.equals(owner) && replaceInfo.targetMethodName.equals(name) && replaceInfo.targetMethodDesc.equals(desc);
            }
        }).collect(Collectors.toList());
        if (replaceInfoList.size() > 0) {
            if (replaceInfoList.size() > 1) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < replaceInfoList.size(); ++i) {
                    ReplaceInfo replaceInfo = (ReplaceInfo)replaceInfoList.get(i);
                    sb.append(" find in").append(i).append(" sourceClass -> ").append(replaceInfo.sourceClass).append(" \n");
                }
                throw new IllegalStateException("replace for " + owner + "." + name + "" + desc + " find multiple ; \n detail info is: \n" + sb.toString());
            }
            ReplaceInfo replaceInfo = (ReplaceInfo)replaceInfoList.get(0);
            if (opcode == 183 && name.equals(this.methodName) && desc.equals(this.methodDesc)) {
                super.visitMethodInsn(opcode, owner, name, desc, itf);
                return;
            }
            if (opcode == 182) {
                LancetContext.instance().getLogger().i("replace in class: " + this.className + " method body " + this.methodName + this.methodDesc + " \n    replace " + owner + "." + name + desc + "     to =>" + replaceInfo.replaceClassName + "." + replaceInfo.replaceMethodName + replaceInfo.replaceMethodDesc);
                this.mv.visitMethodInsn(184, replaceInfo.replaceClassName, replaceInfo.replaceMethodName, replaceInfo.replaceMethodDesc);
            } else if (opcode == 184 && replaceInfo.targetIsStatic) {
                this.mv.visitMethodInsn(184, replaceInfo.replaceClassName, replaceInfo.replaceMethodName, replaceInfo.replaceMethodDesc);
            } else {
                super.visitMethodInsn(opcode, owner, name, desc, itf);
            }
        } else {
            super.visitMethodInsn(opcode, owner, name, desc, itf);
        }
    }
}

