/*
 * Decompiled with CFR 0.152.
 */
package com.zhangyue.lancet.internal.asm.visitor;

import com.zhangyue.lancet.plugin.LancetContext;
import com.zhangyue.lancet.plugin.LancetExtension;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.AdviceAdapter;

public class TraceMethodVisitor
extends AdviceAdapter {
    private final String className;
    private final String methodName;
    private final String myTrace;

    protected TraceMethodVisitor(MethodVisitor mv, int access, String methodName, String desc, String className, String myTrace) {
        super(327680, mv, access, methodName, desc);
        this.className = className;
        this.methodDesc = desc;
        this.methodName = methodName;
        this.myTrace = myTrace;
    }

    public void visitInsn(int opcode) {
        super.visitInsn(opcode);
    }

    protected void onMethodEnter() {
        super.onMethodEnter();
        if (this.methodName != null) {
            String shortClassName = this.transFormClassName(this.className);
            this.mv.visitLdcInsn((Object)(shortClassName + "&" + this.methodName));
            this.mv.visitMethodInsn(184, this.myTrace, "beginSection", "(Ljava/lang/String;)V", false);
        }
    }

    private String transFormClassName(String originClassName) {
        String pluginInfo = ((LancetExtension)LancetContext.instance().extension).getPluginInfo();
        if (pluginInfo == null || pluginInfo.isEmpty()) {
            return originClassName;
        }
        String[] strs = originClassName.split("/");
        String cutClassName = "";
        if (strs.length >= 1) {
            cutClassName = strs[strs.length - 1];
            return pluginInfo + "/" + cutClassName;
        }
        return originClassName;
    }

    protected void onMethodExit(int opcode) {
        super.onMethodExit(opcode);
        if (!((LancetExtension)LancetContext.instance().extension).isNeedExitTrace) {
            return;
        }
        String shortClassName = this.transFormClassName(this.className);
        this.mv.visitLdcInsn((Object)(shortClassName + "&" + this.methodName));
        this.mv.visitMethodInsn(184, this.myTrace, "endSection", "(Ljava/lang/String;)V", false);
    }
}

