/*
 * Decompiled with CFR 0.152.
 */
package com.zhangyue.lancet.internal.asm.visitor;

import com.android.build.api.transform.Format;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.google.common.collect.ImmutableSet;
import com.ss.android.ugc.bytex.common.graph.Graph;
import com.ss.android.ugc.bytex.common.visitor.BaseClassVisitor;
import com.ss.android.ugc.bytex.common.visitor.ClassVisitorChain;
import com.ss.android.ugc.bytex.transformer.TransformContext;
import com.zhangyue.lancet.internal.asm.visitor.BaseWeaveClassVisitor;
import com.zhangyue.lancet.internal.asm.visitor.ChangeClassExtendVisitor;
import com.zhangyue.lancet.internal.asm.visitor.HookClassVisitor;
import com.zhangyue.lancet.internal.asm.visitor.InsertClassVisitor;
import com.zhangyue.lancet.internal.asm.visitor.MethodChain;
import com.zhangyue.lancet.internal.asm.visitor.MethodTraceClassVisitor;
import com.zhangyue.lancet.internal.asm.visitor.ProxyClassVisitor;
import com.zhangyue.lancet.internal.asm.visitor.ReplaceClassVisitor;
import com.zhangyue.lancet.internal.asm.visitor.ReplaceNewClassVisitor;
import com.zhangyue.lancet.internal.asm.visitor.ReplaceNewThreadVisitor;
import com.zhangyue.lancet.internal.asm.visitor.ThreadFactoryVisitor;
import com.zhangyue.lancet.internal.entity.TransformInfo;
import com.zhangyue.lancet.plugin.LancetContext;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;

public class WeaveTransformer {
    public static final String AID_INNER_CLASS_NAME = "_boostWeave";
    Map<String, ClassWriter> mInnerClassWriter = new HashMap<String, ClassWriter>();
    public String className;
    public String superName;
    public BaseWeaveClassVisitor headVisitor;
    public BaseWeaveClassVisitor tailVisitor;
    public ClassVisitor originalClassVisitor;
    private ClassVisitorChain chain;
    private final Graph graph;
    public final MethodChain methodChain;

    public WeaveTransformer(Graph graph) {
        this.graph = graph;
        this.methodChain = new MethodChain(LancetContext.instance().getClassGraph());
    }

    public void initVisitorChain(ClassVisitorChain visitorChain) {
        this.chain = visitorChain;
        BaseWeaveClassVisitor classVisitor = new BaseWeaveClassVisitor();
        TransformInfo transformInfo = LancetContext.instance().getTransformInfo();
        this.connect(new HookClassVisitor(transformInfo, (ClassVisitor)classVisitor));
        this.connect(new ChangeClassExtendVisitor(transformInfo));
        this.connect(new MethodTraceClassVisitor());
        this.connect(new InsertClassVisitor(transformInfo.insertInfo));
        this.connect(new ProxyClassVisitor(transformInfo.proxyInfo));
        this.connect(classVisitor);
        this.connect(new ReplaceClassVisitor(transformInfo));
        this.connect(new ReplaceNewClassVisitor(transformInfo));
        this.connect(new ReplaceNewThreadVisitor(transformInfo));
        this.connect(new ThreadFactoryVisitor(transformInfo));
        this.originalClassVisitor = this.originalClassVisitor;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public MethodChain getMethodChain() {
        return this.methodChain;
    }

    private void connect(BaseWeaveClassVisitor visitor) {
        this.chain.connect((BaseClassVisitor)visitor);
        visitor.transformer = this;
        if (this.headVisitor == null) {
            this.headVisitor = visitor;
            this.tailVisitor = visitor;
        } else {
            this.tailVisitor = visitor;
        }
    }

    public ClassVisitor getInnerClassVisitor(String classSimpleName) {
        ClassWriter writer = this.mInnerClassWriter.get(classSimpleName);
        if (writer == null) {
            writer = new ClassWriter(1);
            this.initForWriter((ClassVisitor)writer, classSimpleName);
            this.mInnerClassWriter.put(classSimpleName, writer);
        }
        return writer;
    }

    public String getCanonicalName(String simpleName) {
        return this.className + "$" + simpleName;
    }

    private void initForWriter(ClassVisitor visitor, String classSimpleName) {
        visitor.visit(51, 32, this.getCanonicalName(classSimpleName), null, "java/lang/Object", null);
        MethodVisitor mv = visitor.visitMethod(2, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    public void generateInnerClasses() {
        for (String className : this.mInnerClassWriter.keySet()) {
            this.tailVisitor.visitInnerClass(this.getCanonicalName(className), this.className, className, 10);
        }
        this.mInnerClassWriter.forEach(new BiConsumer<String, ClassWriter>(){

            @Override
            public void accept(String s, ClassWriter classWriter) {
                byte[] bytes = classWriter.toByteArray();
                TransformContext transformContext = LancetContext.instance().getTransformContext();
                try {
                    File dest = transformContext.getInvocation().getOutputProvider().getContentLocation("weaveInner", TransformManager.CONTENT_CLASS, (Set)ImmutableSet.of((Object)QualifiedContent.Scope.PROJECT), Format.DIRECTORY);
                    File classFile = new File(dest, WeaveTransformer.this.className + "$" + s + ".class");
                    classFile.getParentFile().mkdirs();
                    new FileOutputStream(new File(dest, WeaveTransformer.this.className + "$" + s + ".class")).write(bytes);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

