/*
 * Decompiled with CFR 0.152.
 */
package com.zhangyue.lancet.internal.entity;

import com.google.common.base.Strings;
import com.zhangyue.lancet.internal.util.AsmUtil;
import java.util.regex.Pattern;
import org.objectweb.asm.tree.MethodNode;

public class ProxyInfo {
    public String regex;
    public String targetClass;
    public String targetMethod;
    public String targetDesc;
    public String sourceClass;
    public MethodNode sourceMethod;
    public Pattern pattern;
    private ThreadLocal<MethodNode> local = new ThreadLocal<MethodNode>(){

        @Override
        protected synchronized MethodNode initialValue() {
            return AsmUtil.clone(ProxyInfo.this.sourceMethod);
        }
    };

    public ProxyInfo(String regex, String targetClass, String targetMethod, String targetDesc, String sourceClass, MethodNode sourceMethod) {
        this.regex = regex;
        this.targetClass = targetClass;
        this.targetMethod = targetMethod;
        this.targetDesc = targetDesc;
        this.sourceClass = sourceClass;
        this.sourceMethod = sourceMethod;
        if (!Strings.isNullOrEmpty((String)regex)) {
            this.pattern = Pattern.compile(regex);
        }
    }

    public MethodNode threadLocalNode() {
        return this.local.get();
    }

    public boolean match(String className) {
        return this.pattern == null || this.pattern.matcher(className).matches();
    }

    public String toString() {
        return "ProxyInfo{  regex=" + this.regex + ", targetClass='" + this.targetClass + '\'' + ", targetMethod='" + this.targetMethod + '\'' + ", targetDesc='" + this.targetDesc + '\'' + ", sourceMethod.name=" + this.sourceMethod.name + ", sourceMethod.desc=" + this.sourceMethod.desc + ", sourceMethod.signature=" + this.sourceMethod.signature + ", sourceMethod.access=" + this.sourceMethod.access + ", sourceMethod.codeSize=" + this.sourceMethod.instructions.size() + '}';
    }
}

