/*
 * Decompiled with CFR 0.152.
 */
package com.zhangyue.lancet.internal.entity;

import com.google.common.base.Strings;
import com.zhangyue.lancet.internal.util.AsmUtil;
import com.zhangyue.lancet.internal.util.TypeUtils;
import java.util.regex.Pattern;
import org.objectweb.asm.tree.MethodNode;

public class ReplaceInfo {
    public String regex;
    public String targetClassName;
    public String targetMethodName;
    public String targetMethodDesc;
    public String replaceClassName;
    public String replaceMethodName;
    public String replaceMethodDesc;
    public String sourceClass;
    public MethodNode sourceMethod;
    public Pattern pattern;
    public boolean matchResultReverse;
    public boolean targetIsStatic;
    private ThreadLocal<MethodNode> local = new ThreadLocal<MethodNode>(){

        @Override
        protected synchronized MethodNode initialValue() {
            return AsmUtil.clone(ReplaceInfo.this.sourceMethod);
        }
    };

    public ReplaceInfo(String regex, String targetClassName, String targetMethodName, String targetMethodDesc, String sourceClass, MethodNode sourceMethod) {
        this.regex = regex;
        this.targetClassName = targetClassName;
        this.targetMethodName = targetMethodName;
        this.targetMethodDesc = targetMethodDesc;
        this.sourceClass = sourceClass;
        this.sourceMethod = sourceMethod;
        if (!Strings.isNullOrEmpty((String)regex)) {
            this.pattern = Pattern.compile(regex);
        }
    }

    public void check() {
        if (this.targetMethodName == null) {
            this.targetMethodName = this.sourceMethod.name;
        }
        if (this.targetMethodDesc == null) {
            this.targetMethodDesc = this.sourceMethod.name;
        }
        if (!this.targetIsStatic) {
            this.targetMethodDesc = TypeUtils.removeFirstParam(this.sourceMethod.desc);
        }
        if (this.replaceClassName == null || this.replaceClassName.length() == 0) {
            this.replaceClassName = this.sourceClass;
        }
        if (this.replaceMethodName == null || this.replaceMethodName.length() == 0) {
            this.replaceMethodName = this.sourceMethod.name;
        }
        this.replaceMethodDesc = this.sourceMethod.desc;
    }

    public MethodNode threadLocalNode() {
        return this.local.get();
    }

    public boolean match(String className) {
        if (this.pattern == null) {
            return true;
        }
        boolean matches = this.pattern.matcher(className).matches();
        if (!this.matchResultReverse) {
            return matches;
        }
        return !matches;
    }

    public String toString() {
        return "ReplaceInfo{regex='" + this.regex + '\'' + ", targetClassName='" + this.targetClassName + '\'' + ", targetMethodName='" + this.targetMethodName + '\'' + ", targetMethodDesc='" + this.targetMethodDesc + '\'' + ", replaceClassName='" + this.replaceClassName + '\'' + ", replaceMethodName='" + this.replaceMethodName + '\'' + ", replaceMethodDesc='" + this.replaceMethodDesc + '\'' + ", sourceClass='" + this.sourceClass + '\'' + ", pattern=" + this.pattern + '}';
    }
}

