/*
 * Decompiled with CFR 0.152.
 */
package com.zhangyue.lancet.internal.entity;

import com.zhangyue.lancet.internal.entity.ChangeExtendMeta;
import com.zhangyue.lancet.internal.entity.InsertInfo;
import com.zhangyue.lancet.internal.entity.ProxyInfo;
import com.zhangyue.lancet.internal.entity.ReplaceInfo;
import com.zhangyue.lancet.internal.entity.ReplaceInvokeInfo;
import com.zhangyue.lancet.internal.entity.TryCatchInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class TransformInfo {
    public List<String> weaverClasses = new ArrayList<String>();
    public Map<String, List<InsertInfo>> insertInfo = new HashMap<String, List<InsertInfo>>();
    public List<ProxyInfo> proxyInfo = new ArrayList<ProxyInfo>();
    public List<TryCatchInfo> tryCatchInfo = new ArrayList<TryCatchInfo>();
    public List<ReplaceInfo> replaceInfo = new ArrayList<ReplaceInfo>();
    public List<ReplaceInvokeInfo> replaceInvokes = new ArrayList<ReplaceInvokeInfo>();
    public List<ChangeExtendMeta> changeExtendMetas = new ArrayList<ChangeExtendMeta>();

    public List<TryCatchInfo> getTryCatchInfo() {
        return this.tryCatchInfo;
    }

    public synchronized void addInsertInfo(InsertInfo item) {
        this.insertInfo.computeIfAbsent(item.targetClass, k -> new LinkedList()).add(item);
    }

    public synchronized void addProxyInfo(ProxyInfo item) {
        this.proxyInfo.add(item);
    }

    public synchronized void addReplaceInfo(ReplaceInfo item) {
        this.replaceInfo.add(item);
    }

    public synchronized void addReplaceInvokes(ReplaceInvokeInfo item) {
        this.replaceInvokes.add(item);
    }

    public synchronized void addChangeExtend(ChangeExtendMeta changeExtendMeta) {
        this.changeExtendMetas.add(changeExtendMeta);
    }

    public synchronized void addTryCatch(TryCatchInfo t) {
        this.tryCatchInfo.add(t);
    }

    public void addWeaverClasses(List<String> weaverClasses) {
        this.weaverClasses.addAll(weaverClasses);
    }

    public void addWeaverClass(String weaverClass) {
        this.weaverClasses.add(weaverClass);
    }

    public boolean isWeaverClass(String weaverClass) {
        return this.weaverClasses.contains(weaverClass);
    }

    public String toString() {
        StringBuilder content = new StringBuilder();
        if (this.insertInfo != null) {
            content.append("\nInsert:\n");
            for (Map.Entry entry : this.insertInfo.entrySet()) {
                content.append(' ').append((String)entry.getKey()).append(":\n");
                ((List)entry.getValue()).forEach(e -> content.append("  ").append(e).append("\n"));
            }
        }
        if (this.proxyInfo != null) {
            content.append("Proxy:\n");
            for (ProxyInfo proxyInfo : this.proxyInfo) {
                content.append(' ').append(proxyInfo).append("\n");
            }
        }
        if (this.tryCatchInfo != null) {
            content.append("TryCatch:\n");
            for (TryCatchInfo tryCatchInfo : this.tryCatchInfo) {
                content.append(' ').append(tryCatchInfo).append("\n");
            }
        }
        if (this.replaceInfo != null) {
            content.append("ReplaceInfo:\n");
            for (ReplaceInfo replaceInfo : this.replaceInfo) {
                content.append(' ').append(replaceInfo).append("\n");
            }
        }
        return content.toString();
    }
}

