/*
 * Decompiled with CFR 0.152.
 */
package com.zhangyue.lancet.internal.parser;

import com.knightboost.lancet.api.annotations.Group;
import com.ss.android.ugc.bytex.common.graph.Graph;
import com.zhangyue.lancet.internal.core.WeaverMethodParser;
import com.zhangyue.lancet.internal.log.WeaverLog;
import com.zhangyue.lancet.internal.util.AsmUtil;
import com.zhangyue.lancet.plugin.LancetContext;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class WeaverClassesParser {
    private final List<ClassNode> weaverClasses = new ArrayList<ClassNode>();
    private static final String GROUP = Type.getDescriptor(Group.class);
    public Graph graph;

    public void addWeaverClass(ClassNode classNode) {
        this.weaverClasses.add(classNode);
    }

    public void parse() {
        for (ClassNode classNode : this.weaverClasses) {
            this.parseWeaver(classNode);
        }
    }

    private void checkNode(ClassNode cn) {
        if (cn.fields.size() > 0) {
            String s = cn.fields.stream().map(fieldNode -> fieldNode.name).collect(Collectors.joining(","));
            WeaverLog.w("shouldn't declare fields '" + s + "' in weaver class " + cn.name);
        }
    }

    public void parseWeaver(ClassNode cn) {
        this.checkNode(cn);
        LancetContext weaveContext = LancetContext.instance();
        String className = cn.name;
        weaveContext.getTransformInfo().addWeaverClass(className);
        for (AnnotationNode classAnnotations : cn.visibleAnnotations) {
            String value;
            if (!classAnnotations.desc.equals(GROUP) || (value = AsmUtil.findAnnotationStringValue(classAnnotations, "value")) == null || value.length() <= 0) continue;
            weaveContext.registerGroupWeaverClass(className, value);
        }
        boolean isEnable = weaveContext.isWeaveEnable(className);
        if (!isEnable) {
            return;
        }
        for (MethodNode method : cn.methods) {
            if (!WeaverMethodParser.isWeaverMethodNode(method)) continue;
            WeaverMethodParser weaverInfoParser = new WeaverMethodParser(this.graph, cn, method);
            weaverInfoParser.parse();
        }
    }
}

