/*
 * Decompiled with CFR 0.152.
 */
package com.zhangyue.lancet.internal.parser.anno;

import com.google.common.base.Strings;
import com.knightboost.lancet.api.Scope;
import com.zhangyue.lancet.internal.exception.IllegalAnnotationException;
import com.zhangyue.lancet.internal.meta.ImplementedInterfaceMeta;
import com.zhangyue.lancet.internal.parser.AnnoParser;
import com.zhangyue.lancet.internal.parser.AnnotationMeta;
import com.zhangyue.lancet.internal.util.RefHolder;
import java.util.Arrays;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;

public class ImplementedInterfaceAnnoParser
implements AnnoParser {
    private static final String ENUM_DESC = Type.getDescriptor(Scope.class);

    @Override
    public AnnotationMeta parseAnnotation(AnnotationNode annotationNode) {
        RefHolder<Object> interfaces = new RefHolder<Object>(null);
        RefHolder<Scope> scope = new RefHolder<Scope>(Scope.SELF);
        List values = annotationNode.values;
        if (values != null) {
            block8: for (int i = 0; i < values.size(); i += 2) {
                switch ((String)values.get(i)) {
                    case "value": {
                        interfaces.set(ImplementedInterfaceAnnoParser.contentNonNull(((List)values.get(i + 1)).toArray(new String[0])));
                        continue block8;
                    }
                    case "scope": {
                        String[] vs = (String[])values.get(i + 1);
                        if (!ENUM_DESC.equals(vs[0])) {
                            throw new IllegalAnnotationException();
                        }
                        scope.set(Scope.valueOf((String)vs[1]));
                        continue block8;
                    }
                    default: {
                        throw new IllegalAnnotationException();
                    }
                }
            }
            return new ImplementedInterfaceMeta(Arrays.asList(interfaces.get()), scope.get());
        }
        throw new IllegalAnnotationException("@ImplementedInterface is illegal, must specify value field");
    }

    private static String[] contentNonNull(String[] interfaces) {
        if (interfaces != null) {
            for (int i = 0; i < interfaces.length; ++i) {
                if (Strings.isNullOrEmpty((String)interfaces[i])) {
                    throw new IllegalAnnotationException("@ImplementedInterface's value can't be null");
                }
                interfaces[i] = interfaces[i].replace('.', '/');
            }
        }
        return interfaces;
    }
}

