/*
 * Decompiled with CFR 0.152.
 */
package com.zhangyue.lancet.internal.parser.anno;

import com.google.common.base.Strings;
import com.knightboost.lancet.api.Scope;
import com.zhangyue.lancet.internal.exception.IllegalAnnotationException;
import com.zhangyue.lancet.internal.meta.TargetClassMeta;
import com.zhangyue.lancet.internal.parser.AnnotationMeta;
import com.zhangyue.lancet.internal.parser.BaseAnnoParser;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;

public class TargetClassAnnoParser
extends BaseAnnoParser {
    private static final String ENUM_DESC = Type.getDescriptor(Scope.class);

    @Override
    public AnnotationMeta parseAnnotation(AnnotationNode annotationNode) {
        String temp = this.findAnnotationStringValue(annotationNode, "value");
        if (Strings.isNullOrEmpty((String)temp)) {
            throw new IllegalAnnotationException("@TargetClass value can't be empty or null");
        }
        String[] vs = (String[])this.findAnnotationValue(annotationNode, "scope");
        if (!ENUM_DESC.equals(vs[0])) {
            throw new IllegalAnnotationException();
        }
        String className = temp.replace('.', '/');
        Scope scope = Scope.valueOf((String)vs[1]);
        return new TargetClassMeta(className, scope);
    }
}

