/*
 * Decompiled with CFR 0.152.
 */
package com.zhangyue.lancet.plugin;

import com.ss.android.ugc.bytex.common.BaseExtension;
import com.zhangyue.lancet.internal.log.WeaverLog;
import com.zhangyue.lancet.plugin.BlackGroup;
import com.zhangyue.lancet.plugin.LancetContext;
import com.zhangyue.lancet.plugin.MethodGroup;
import com.zhangyue.lancet.plugin.WeaveGroup;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;

public class LancetExtension
extends BaseExtension {
    protected static LancetExtension sLancetExtension;
    private NamedDomainObjectContainer<WeaveGroup> weaveGroup;
    private NamedDomainObjectContainer<MethodGroup> methodGroups;
    private NamedDomainObjectContainer<BlackGroup> blackGroup;
    private String myTrace;
    private String pluginInfo;
    private boolean isFullTrace = false;
    public boolean isNeedExitTrace = false;
    private List<String> systemMethod = new ArrayList<String>();

    public static final LancetExtension instance() {
        return sLancetExtension;
    }

    public LancetExtension(Project project) {
        this.enable(false);
        this.enableInDebug(false);
        this.bindProject(project);
        this.systemMethod.add("androidx/");
        this.systemMethod.add("kotlin/");
        this.systemMethod.add("okhttp3/");
        this.systemMethod.add("okio/");
        this.systemMethod.add("android/support");
        this.systemMethod.add("com/google/");
    }

    public void bindProject(Project project) {
        this.weaveGroup = project.getObjects().domainObjectContainer(WeaveGroup.class);
        this.methodGroups = project.getObjects().domainObjectContainer(MethodGroup.class);
        this.blackGroup = project.getObjects().domainObjectContainer(BlackGroup.class);
    }

    public void weaveGroup(Action<? super NamedDomainObjectContainer<WeaveGroup>> action) {
        action.execute(this.weaveGroup);
    }

    public void methodGroup(Action<? super NamedDomainObjectContainer<MethodGroup>> action) {
        action.execute(this.methodGroups);
    }

    public void blackGroup(Action<? super NamedDomainObjectContainer<BlackGroup>> action) {
        action.execute(this.blackGroup);
    }

    public void myTrace(String myTrace) {
        this.myTrace = myTrace;
    }

    public void pluginInfo(String pluginInfo) {
        this.pluginInfo = pluginInfo;
    }

    public void isFullTrace(boolean isFullTrace) {
        this.isFullTrace = isFullTrace;
    }

    public void isNeedExitTrace(boolean isNeedExitTrace) {
        this.isNeedExitTrace = isNeedExitTrace;
    }

    public boolean isFullTrace() {
        return this.isFullTrace;
    }

    public String getMyTrace() {
        return this.myTrace;
    }

    public String getPluginInfo() {
        return this.pluginInfo;
    }

    public WeaveGroup findWeaveGroup(String group) {
        return (WeaveGroup)this.weaveGroup.findByName(group);
    }

    public MethodGroup findMethodGroup(String group) {
        return (MethodGroup)this.methodGroups.findByName(group);
    }

    public boolean shouldTrace(String className, String methodName) {
        for (int i = 0; i < this.systemMethod.size(); ++i) {
            if (!className.contains(this.systemMethod.get(i))) continue;
            return false;
        }
        for (BlackGroup black : this.blackGroup) {
            List<String> methodlist = black.getBlackMethodList();
            if (!className.contains(black.getName())) continue;
            if (methodlist == null || methodlist.size() == 0) {
                return false;
            }
            for (int i = 0; i < methodlist.size(); ++i) {
                if (!methodName.contains(methodlist.get(i))) continue;
                return false;
            }
        }
        if (((LancetExtension)LancetContext.instance().extension).isFullTrace()) {
            return true;
        }
        for (MethodGroup methodGroup : this.methodGroups) {
            if (!className.contains(methodGroup.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean isWeaveGroupEnable(String group) {
        if (group == null) {
            return this.isEnable();
        }
        WeaveGroup weaveGroup = this.findWeaveGroup(group);
        if (weaveGroup == null) {
            WeaverLog.i("\u672a\u53d1\u73b0 weaver group " + group + " \u7684gradle \u914d\u7f6e ,\u56e0\u6b64\u529f\u80fd\u9ed8\u8ba4\u5173\u95ed");
            return false;
        }
        return weaveGroup.isEnable();
    }

    public String getName() {
        return "LancetX";
    }
}

