/*
 * Decompiled with CFR 0.152.
 */
package com.zhangyue.lancet.plugin;

import com.android.build.api.transform.Transform;
import com.android.build.gradle.AppExtension;
import com.knightboost.lancet.api.annotations.Weaver;
import com.ss.android.ugc.bytex.common.CommonPlugin;
import com.ss.android.ugc.bytex.common.TransformConfiguration;
import com.ss.android.ugc.bytex.common.flow.TransformFlow;
import com.ss.android.ugc.bytex.common.flow.main.MainTransformFlow;
import com.ss.android.ugc.bytex.common.flow.main.Process;
import com.ss.android.ugc.bytex.common.log.ILogger;
import com.ss.android.ugc.bytex.common.visitor.ClassVisitorChain;
import com.ss.android.ugc.bytex.transformer.TransformContext;
import com.ss.android.ugc.bytex.transformer.TransformEngine;
import com.zhangyue.lancet.internal.asm.visitor.WeaveTransformer;
import com.zhangyue.lancet.internal.parser.WeaverClassesParser;
import com.zhangyue.lancet.plugin.LancetContext;
import com.zhangyue.lancet.plugin.LancetExtension;
import java.util.List;
import javax.annotation.Nonnull;
import org.gradle.api.Project;
import org.gradle.internal.reflect.Instantiator;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;

public class LancetPlugin
extends CommonPlugin<LancetExtension, LancetContext> {
    private ILogger logger;
    private WeaverClassesParser weaverClassesParser;

    protected LancetContext getContext(Project project, AppExtension android, LancetExtension extension) {
        LancetContext lancetContext = new LancetContext(project, android, extension);
        return lancetContext;
    }

    protected void onApply(@Nonnull @NotNull Project project) {
        super.onApply(project);
    }

    public void init() {
        super.init();
        this.logger = ((LancetContext)this.context).getLogger();
        LancetContext.setInstance((LancetContext)this.context);
        this.weaverClassesParser = new WeaverClassesParser();
    }

    public void traverse(@Nonnull String relativePath, @Nonnull ClassNode node) {
        List annotations = node.visibleAnnotations;
        if (annotations != null) {
            for (AnnotationNode annotationNode : annotations) {
                if (!annotationNode.desc.equals(Type.getDescriptor(Weaver.class))) continue;
                this.weaverClassesParser.addWeaverClass(node);
            }
        }
        super.traverse(relativePath, node);
    }

    public void beforeTransform(@Nonnull @NotNull TransformEngine engine) {
        super.beforeTransform(engine);
        this.weaverClassesParser.graph = ((LancetContext)this.context).getClassGraph();
        this.weaverClassesParser.parse();
        LancetContext.instance().getLogger().i("heyan transform info \n" + LancetContext.instance().getTransformInfo());
    }

    public boolean transform(@Nonnull String relativePath, @Nonnull ClassVisitorChain chain) {
        WeaveTransformer weaveTransformer = new WeaveTransformer(((LancetContext)this.context).getClassGraph());
        weaveTransformer.initVisitorChain(chain);
        return true;
    }

    protected TransformFlow provideTransformFlow(@Nonnull MainTransformFlow mainFlow, @Nonnull TransformContext transformContext) {
        return super.provideTransformFlow(mainFlow, transformContext);
    }

    protected Transform getTransform() {
        return super.getTransform();
    }

    @Nonnull
    public TransformConfiguration transformConfiguration() {
        return new TransformConfiguration(){

            public boolean isIncremental() {
                return false;
            }
        };
    }

    protected LancetExtension createExtension(Instantiator instantiator, Class<LancetExtension> clazz) {
        LancetExtension extension = (LancetExtension)((Object)instantiator.newInstance(clazz, new Object[]{this.project}));
        return extension;
    }

    public int flagForClassReader(Process process) {
        switch (process) {
            case TRAVERSE: 
            case TRAVERSE_ANDROID: 
            case TRANSFORM: {
                return 14;
            }
        }
        return 0;
    }
}

