/*
 * Decompiled with CFR 0.152.
 */
package com.highstakes.autointerface;

import com.highstakes.autointerface.AutoInterface;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"com.highstakes.autointerface.AutoInterface"})
public class AutoInterfaceProcessor
extends AbstractProcessor {
    private Elements elementUtils;
    private Types typeUtils;
    private Filer filer;
    private Set<String> objectMethods;
    private Messager messager;

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public synchronized void init(ProcessingEnvironment env) {
        super.init(env);
        this.elementUtils = env.getElementUtils();
        this.typeUtils = env.getTypeUtils();
        this.filer = env.getFiler();
        this.messager = env.getMessager();
        this.objectMethods = this.getObjectMethodSignatures();
    }

    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        if (!roundEnvironment.processingOver()) {
            roundEnvironment.getElementsAnnotatedWith(AutoInterface.class).stream().filter(it -> it.getKind().equals((Object)ElementKind.CLASS)).map(TypeElement.class::cast).forEach(this::generateInterface);
            return true;
        }
        return false;
    }

    private void generateInterface(TypeElement rootTypeElemenet) {
        AutoInterface autoInterface = rootTypeElemenet.getAnnotation(AutoInterface.class);
        TypeSpec.Builder typeSpecbuilder = this.getTypeSpec(rootTypeElemenet).addMethods((Iterable)this.filterInterfaceMethods(autoInterface.includeInherted() ? this.elementUtils.getAllMembers(rootTypeElemenet) : rootTypeElemenet.getEnclosedElements()).stream().map(it -> this.getMethodSpec(rootTypeElemenet, (ExecutableElement)it)).collect(Collectors.toList()));
        String packageName = this.elementUtils.getPackageOf(rootTypeElemenet).getQualifiedName().toString();
        JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)typeSpecbuilder.build()).indent("    ").build();
        try {
            javaFile.writeTo(this.filer);
        }
        catch (IOException e) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "AutoInterface: Error generating interface: " + e.getMessage());
        }
    }

    private List<ExecutableElement> filterInterfaceMethods(List<? extends Element> elementList) {
        return elementList.stream().filter(it -> it.getKind().equals((Object)ElementKind.METHOD)).filter(it -> ElementKind.CLASS.equals((Object)it.getEnclosingElement().getKind())).filter(it -> !this.objectMethods.contains(it.toString())).map(ExecutableElement.class::cast).filter(it -> !it.getModifiers().contains((Object)Modifier.STATIC)).filter(it -> it.getModifiers().contains((Object)Modifier.PUBLIC)).collect(Collectors.toList());
    }

    private TypeSpec.Builder getTypeSpec(TypeElement type) {
        return TypeSpec.interfaceBuilder((ClassName)this.getInterfaceName(type)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addTypeVariables(this.getTypeVariables(type)).addOriginatingElement((Element)type);
    }

    private MethodSpec getMethodSpec(TypeElement rootType, ExecutableElement method) {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)method.getSimpleName().toString());
        ExecutableType methodType = (ExecutableType)this.typeUtils.asMemberOf((DeclaredType)rootType.asType(), method);
        List<? extends TypeMirror> paramTypes = methodType.getParameterTypes();
        List<? extends VariableElement> params = method.getParameters();
        for (int i = 0; i < paramTypes.size(); ++i) {
            methodBuilder.addParameter(ParameterSpec.builder((TypeName)TypeName.get((TypeMirror)paramTypes.get(i)), (String)params.get(i).getSimpleName().toString(), (Modifier[])new Modifier[0]).build());
        }
        return methodBuilder.returns(ClassName.get((TypeMirror)methodType.getReturnType())).addExceptions((Iterable)methodType.getThrownTypes().stream().map(TypeName::get).collect(Collectors.toList())).addTypeVariables((Iterable)method.getTypeParameters().stream().map(TypeVariableName::get).collect(Collectors.toList())).addModifiers(new Modifier[]{Modifier.ABSTRACT, Modifier.PUBLIC}).build();
    }

    private ClassName getInterfaceName(TypeElement type) {
        String interfaceName = this.getClassName(type) + "Interface";
        String packageName = this.elementUtils.getPackageOf(type).getQualifiedName().toString();
        return ClassName.get((String)packageName, (String)interfaceName, (String[])new String[0]);
    }

    private Iterable<TypeVariableName> getTypeVariables(TypeElement type) {
        return type.getTypeParameters().stream().map(TypeVariableName::get).collect(Collectors.toList());
    }

    private String getClassName(TypeElement type) {
        Stack<TypeElement> typeChain = new Stack<TypeElement>();
        while (true) {
            typeChain.add(type);
            Element enclosingElement = type.getEnclosingElement();
            if (enclosingElement.getKind().equals((Object)ElementKind.PACKAGE)) {
                return typeChain.stream().map(element -> element.getSimpleName().toString()).map(str -> str.substring(0, 1).toUpperCase() + str.substring(1)).collect(Collectors.joining());
            }
            type = (TypeElement)enclosingElement;
        }
    }

    private Set<String> getObjectMethodSignatures() {
        return this.elementUtils.getTypeElement("java.lang.Object").getEnclosedElements().stream().filter(e -> e.getKind().equals((Object)ElementKind.METHOD)).map(ExecutableElement.class::cast).filter(e -> !e.getModifiers().contains((Object)Modifier.STATIC)).map(Object::toString).collect(Collectors.toSet());
    }
}

