/*
 * Decompiled with CFR 0.152.
 */
package com.hjcenry.fec;

import com.hjcenry.fec.IFecDecode;
import com.hjcenry.fec.IFecEncode;
import com.hjcenry.fec.ReedSolomon;
import com.hjcenry.fec.fec.FecDecode;
import com.hjcenry.fec.fecNative.FecEncode;
import com.hjcenry.fec.fecNative.ReedSolomonNative;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;

public class FecAdapt {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(FecAdapt.class);
    private ReedSolomonNative reedSolomonNative;
    private ReedSolomon reedSolomon;

    public FecAdapt(int dataShards, int parityShards) {
        if (ReedSolomonNative.isNativeSupport()) {
            this.reedSolomonNative = new ReedSolomonNative(dataShards, parityShards);
            log.info("fec use C native reedSolomon dataShards {} parityShards {}", (Object)dataShards, (Object)parityShards);
        } else {
            this.reedSolomon = ReedSolomon.create(dataShards, parityShards);
            log.info("fec use jvm reedSolomon dataShards {} parityShards {}", (Object)dataShards, (Object)parityShards);
        }
    }

    public IFecEncode fecEncode(int headerOffset, int mtu) {
        IFecEncode iFecEncode = this.reedSolomonNative != null ? new FecEncode(headerOffset, this.reedSolomonNative, mtu) : new com.hjcenry.fec.fec.FecEncode(headerOffset, this.reedSolomon, mtu);
        return iFecEncode;
    }

    public IFecDecode fecDecode(int mtu) {
        IFecDecode iFecDecode = this.reedSolomonNative != null ? new com.hjcenry.fec.fecNative.FecDecode(3 * this.reedSolomonNative.getTotalShardCount(), this.reedSolomonNative, mtu) : new FecDecode(3 * this.reedSolomon.getTotalShardCount(), this.reedSolomon, mtu);
        return iFecDecode;
    }
}

