/*
 * Decompiled with CFR 0.152.
 */
package org.azd.connection;

import org.azd.exceptions.AzDException;
import org.azd.oauth.OAuthApi;
import org.azd.oauth.types.AuthorizedToken;

public class Connection {
    private String organization;
    private String project;
    private String personalAccessToken;
    private String appSecret;
    private String appCallBackURL;
    private AuthorizedToken oauthToken = null;
    private TokenRefreshedHandler tokenRefreshedHandler = defaultTokenRefreshedHandler;
    private static TokenRefreshedHandler defaultTokenRefreshedHandler = new TokenRefreshedHandler(){

        @Override
        public void tokenRefreshed(AuthorizedToken newToken) {
        }
    };

    public Connection() {
    }

    private Connection(String organization, String project, String personalAccessToken, AuthorizedToken oauthToken, String appSecret, String appCallBackURL, TokenRefreshedHandler tokenRefreshedHandler) {
        this.organization = organization;
        this.project = project;
        this.personalAccessToken = personalAccessToken;
        this.oauthToken = oauthToken;
        this.appSecret = appSecret;
        this.appCallBackURL = appCallBackURL;
        this.tokenRefreshedHandler = tokenRefreshedHandler != null ? tokenRefreshedHandler : defaultTokenRefreshedHandler;
    }

    public Connection(String organization, String personalAccessToken) {
        this(organization, null, personalAccessToken, null, null, null, null);
    }

    public Connection(String organization, String project, String personalAccessToken) {
        this(organization, project, personalAccessToken, null, null, null, null);
    }

    public Connection(String organization, AuthorizedToken oauthToken, String appSecret, String appCallBackURL) {
        this(organization, null, null, oauthToken, appSecret, appCallBackURL, null);
    }

    public Connection(String organization, String project, AuthorizedToken oauthToken, String appSecret, String appCallBackURL, TokenRefreshedHandler tokenRefreshedHandler) {
        this(organization, project, null, oauthToken, appSecret, appCallBackURL, tokenRefreshedHandler);
    }

    public Connection(String organization, AuthorizedToken oauthToken, String appSecret, String appCallBackURL, TokenRefreshedHandler tokenRefreshedHandler) {
        this(organization, null, null, oauthToken, appSecret, appCallBackURL, tokenRefreshedHandler);
    }

    public Connection(String organization, String project, AuthorizedToken oauthToken, String appSecret, String appCallBackURL) {
        this(organization, project, null, oauthToken, appSecret, appCallBackURL, null);
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getPersonalAccessToken() throws AzDException {
        if (this.oauthToken != null) {
            if (OAuthApi.hasTokenExpired(this.oauthToken)) {
                this.setOauthToken(OAuthApi.getRefreshToken(this.appSecret, this.oauthToken.getRefreshToken(), this.appCallBackURL));
            }
            return this.oauthToken.getAccessToken();
        }
        return this.personalAccessToken;
    }

    public void setPersonalAccessToken(String personalAccessToken) {
        this.oauthToken = null;
        this.personalAccessToken = personalAccessToken;
    }

    public void setOauthToken(AuthorizedToken oauthToken) {
        this.oauthToken = oauthToken;
        this.tokenRefreshedHandler.tokenRefreshed(oauthToken);
    }

    public static interface TokenRefreshedHandler {
        public void tokenRefreshed(AuthorizedToken var1);
    }
}

