/*
 * Decompiled with CFR 0.152.
 */
package org.azd.core;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.azd.connection.Connection;
import org.azd.core.types.OperationReference;
import org.azd.core.types.Processes;
import org.azd.core.types.Project;
import org.azd.core.types.ProjectFeature;
import org.azd.core.types.ProjectProperties;
import org.azd.core.types.Projects;
import org.azd.core.types.Team;
import org.azd.core.types.Teams;
import org.azd.core.types.WebApiTeam;
import org.azd.enums.CustomHeader;
import org.azd.enums.FeatureManagement;
import org.azd.enums.RequestMethod;
import org.azd.exceptions.AzDException;
import org.azd.helpers.JsonMapper;
import org.azd.interfaces.CoreDetails;
import org.azd.utils.AzDAsyncApi;
import org.azd.utils.RestClient;

public class CoreApi
extends AzDAsyncApi<CoreApi>
implements CoreDetails {
    private final Connection CONNECTION;
    private final JsonMapper MAPPER = new JsonMapper();
    private final String CORE = "79134c72-4a58-4b42-976c-04e7115f32bf";
    private final String AREA = "projects";

    public CoreApi(Connection connection) {
        this.CONNECTION = connection;
    }

    @Override
    public Processes getProcesses() throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "79134c72-4a58-4b42-976c-04e7115f32bf", null, "process/processes", null, null, "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, Processes.class);
    }

    @Override
    public OperationReference createProject(final String projectName, final String description) throws AzDException {
        LinkedHashMap<String, Object> h = new LinkedHashMap<String, Object>(){
            {
                this.put("name", projectName);
                this.put("description", description);
                this.put("capabilities", new LinkedHashMap<String, Object>(){
                    {
                        this.put("versioncontrol", new LinkedHashMap<String, Object>(){
                            {
                                this.put("sourceControlType", "Git");
                            }
                        });
                        this.put("processTemplate", new LinkedHashMap<String, Object>(){
                            {
                                this.put("templateTypeId", "6b724908-ef14-45cf-84f8-768b5384da45");
                            }
                        });
                    }
                });
            }
        };
        String r = RestClient.send(RequestMethod.POST, this.CONNECTION, "79134c72-4a58-4b42-976c-04e7115f32bf", null, "projects", null, null, "7.1-preview.4", null, h, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, OperationReference.class);
    }

    @Override
    public OperationReference createProject(final String projectName, final String description, final String sourceControlType, final String templateTypeId) throws AzDException {
        LinkedHashMap<String, Object> h = new LinkedHashMap<String, Object>(){
            {
                this.put("name", projectName);
                this.put("description", description);
                this.put("capabilities", new LinkedHashMap<String, Object>(){
                    {
                        this.put("versioncontrol", new LinkedHashMap<String, Object>(){
                            {
                                this.put("sourceControlType", sourceControlType);
                            }
                        });
                        this.put("processTemplate", new LinkedHashMap<String, Object>(){
                            {
                                this.put("templateTypeId", templateTypeId);
                            }
                        });
                    }
                });
            }
        };
        String r = RestClient.send(RequestMethod.POST, this.CONNECTION, "79134c72-4a58-4b42-976c-04e7115f32bf", null, "projects", null, null, "7.1-preview.4", null, h, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, OperationReference.class);
    }

    @Override
    public OperationReference deleteProject(String projectId) throws AzDException {
        String r = RestClient.send(RequestMethod.DELETE, this.CONNECTION, "79134c72-4a58-4b42-976c-04e7115f32bf", null, "projects", projectId, null, "7.1-preview.4", null, null, null);
        return this.MAPPER.mapJsonResponse(r, OperationReference.class);
    }

    @Override
    public Project getProject(String projectName) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "79134c72-4a58-4b42-976c-04e7115f32bf", null, "projects", projectName, null, "7.1-preview.4", null, null, null);
        return this.MAPPER.mapJsonResponse(r, Project.class);
    }

    @Override
    public Project getProject(String projectName, final boolean includeCapabilities, final boolean includeHistory) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("includeCapabilities", includeCapabilities);
                this.put("includeHistory", includeHistory);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "79134c72-4a58-4b42-976c-04e7115f32bf", null, "projects", projectName, null, "7.1-preview.4", q, null, null);
        return this.MAPPER.mapJsonResponse(r, Project.class);
    }

    @Override
    public ProjectProperties getProjectProperties(String projectId) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "79134c72-4a58-4b42-976c-04e7115f32bf", null, "projects", projectId, "properties", "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, ProjectProperties.class);
    }

    @Override
    public Projects getProjects() throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "79134c72-4a58-4b42-976c-04e7115f32bf", null, "projects", null, null, "7.1-preview.4", null, null, null);
        return this.MAPPER.mapJsonResponse(r, Projects.class);
    }

    @Override
    public Projects getProjects(final int skip, final int top, final String continuationToken, final boolean getDefaultTeamImageUrl, final String stateFilter) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("$skip", skip);
                this.put("$top", top);
                this.put("continuationToken", continuationToken);
                this.put("getDefaultTeamImageUrl", getDefaultTeamImageUrl);
                this.put("stateFilter", stateFilter);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "79134c72-4a58-4b42-976c-04e7115f32bf", null, "projects", null, null, "7.1-preview.4", q, null, null);
        return this.MAPPER.mapJsonResponse(r, Projects.class);
    }

    @Override
    public OperationReference updateProject(String projectId, Project projectParameters) throws AzDException {
        String r = RestClient.send(RequestMethod.PATCH, this.CONNECTION, "79134c72-4a58-4b42-976c-04e7115f32bf", null, "projects", projectId, null, "7.1-preview.4", null, projectParameters, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, OperationReference.class);
    }

    @Override
    public WebApiTeam createTeam(String projectName, final String teamName) throws AzDException {
        HashMap<String, Object> h = new HashMap<String, Object>(){
            {
                this.put("name", teamName);
            }
        };
        String r = RestClient.send(RequestMethod.POST, this.CONNECTION, "79134c72-4a58-4b42-976c-04e7115f32bf", null, "projects", projectName, "teams", "7.1-preview.3", null, h, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, WebApiTeam.class);
    }

    @Override
    public Void deleteTeam(String projectName, String teamName) throws AzDException {
        String r = RestClient.send(RequestMethod.DELETE, this.CONNECTION, "79134c72-4a58-4b42-976c-04e7115f32bf", null, "projects", projectName, "teams/" + teamName, "7.1-preview.3", null, null, null);
        if (!r.isEmpty()) {
            this.MAPPER.mapJsonResponse(r, Map.class);
        }
        return null;
    }

    @Override
    public Team getTeam(String projectName, String teamName) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "79134c72-4a58-4b42-976c-04e7115f32bf", null, "projects", projectName, "teams/" + teamName, "7.1-preview.3", null, null, null);
        return this.MAPPER.mapJsonResponse(r, Team.class);
    }

    @Override
    public Team getTeam(String projectName, String teamName, final boolean expandIdentity) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("$expandIdentity", expandIdentity);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "79134c72-4a58-4b42-976c-04e7115f32bf", null, "projects", projectName, "teams/" + teamName, "7.1-preview.3", q, null, null);
        return this.MAPPER.mapJsonResponse(r, Team.class);
    }

    @Override
    public Teams getTeams() throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "79134c72-4a58-4b42-976c-04e7115f32bf", null, "teams", null, null, "7.1-preview.3", null, null, null);
        return this.MAPPER.mapJsonResponse(r, Teams.class);
    }

    @Override
    public Teams getTeams(final boolean expandIdentity, final String mine, final int skip, final int top) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("$expandIdentity", expandIdentity);
                this.put("$mine", mine);
                this.put("$skip", skip);
                this.put("$top", top);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "79134c72-4a58-4b42-976c-04e7115f32bf", null, "teams", null, null, "7.1-preview.3", q, null, null);
        return this.MAPPER.mapJsonResponse(r, Teams.class);
    }

    @Override
    public Team updateTeams(String projectName, final String teamName, final String description) throws AzDException {
        HashMap<String, Object> h = new HashMap<String, Object>(){
            {
                this.put("name", teamName);
                this.put("description", description);
            }
        };
        String r = RestClient.send(RequestMethod.PATCH, this.CONNECTION, "79134c72-4a58-4b42-976c-04e7115f32bf", null, "projects", projectName, "teams/" + teamName, "7.1-preview.3", null, h, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, Team.class);
    }

    @Override
    public Optional<Boolean> getFeatureState(String projectId, FeatureManagement feature) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, null, null, "FeatureManagement/FeatureStates/host/project", projectId, feature.getFeatureId(), "4.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, ProjectFeature.class).getStateAsBoolean();
    }

    @Override
    public ProjectFeature featureToggle(String projectId, final FeatureManagement feature, final boolean state) throws AzDException {
        LinkedHashMap<String, Object> b = new LinkedHashMap<String, Object>(){
            {
                this.put("featureId", feature.getFeatureId());
                this.put("scope", new LinkedHashMap<Object, Object>(){
                    {
                        this.put("settingScope", "project");
                        this.put("userScoped", false);
                    }
                });
                this.put("state", state ? 1 : 0);
            }
        };
        String r = RestClient.send(RequestMethod.PATCH, this.CONNECTION, null, null, "FeatureManagement/FeatureStates/host/project", projectId, feature.getFeatureId(), "4.1-preview.1", null, b, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, ProjectFeature.class);
    }
}

