/*
 * Decompiled with CFR 0.152.
 */
package org.azd.distributedtask;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.azd.connection.Connection;
import org.azd.core.CoreApi;
import org.azd.core.types.Project;
import org.azd.distributedtask.types.DeploymentGroup;
import org.azd.distributedtask.types.DeploymentGroups;
import org.azd.distributedtask.types.EnvironmentInstance;
import org.azd.distributedtask.types.EnvironmentInstances;
import org.azd.distributedtask.types.TaskAgent;
import org.azd.distributedtask.types.TaskAgents;
import org.azd.distributedtask.types.VariableGroup;
import org.azd.distributedtask.types.VariableGroupDefinition;
import org.azd.distributedtask.types.VariableGroupMap;
import org.azd.distributedtask.types.VariableGroupProjectReference;
import org.azd.distributedtask.types.VariableGroups;
import org.azd.enums.CustomHeader;
import org.azd.enums.DeploymentGroupActionFilter;
import org.azd.enums.DeploymentGroupExpands;
import org.azd.enums.EnvironmentExpands;
import org.azd.enums.RequestMethod;
import org.azd.enums.VariableGroupActionFilter;
import org.azd.enums.VariableGroupQueryOrder;
import org.azd.enums.VariableGroupType;
import org.azd.exceptions.AzDException;
import org.azd.helpers.JsonMapper;
import org.azd.interfaces.DistributedTaskDetails;
import org.azd.release.types.ProjectReference;
import org.azd.utils.AzDAsyncApi;
import org.azd.utils.RestClient;

public class DistributedTaskApi
extends AzDAsyncApi<DistributedTaskApi>
implements DistributedTaskDetails {
    private final Connection CONNECTION;
    private final JsonMapper MAPPER = new JsonMapper();
    private final String AREA = "distributedtask";
    private final String DISTRIBUTEDTASK = "a85b8835-c1a1-4aac-ae97-1c3d0ba72dbd";

    public DistributedTaskApi(Connection connection) {
        this.CONNECTION = connection;
    }

    @Override
    public Void deleteAgent(int poolId, int agentId) throws AzDException {
        String r = RestClient.send(RequestMethod.DELETE, this.CONNECTION, "a85b8835-c1a1-4aac-ae97-1c3d0ba72dbd", null, "distributedtask/pools", poolId + "/agents/" + agentId, null, "7.1-preview.1", null, null, null);
        if (!r.isEmpty()) {
            this.MAPPER.mapJsonResponse(r, Map.class);
        }
        return null;
    }

    @Override
    public TaskAgent getAgent(int poolId, int agentId) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "a85b8835-c1a1-4aac-ae97-1c3d0ba72dbd", null, "distributedtask/pools", poolId + "/agents/" + agentId, null, "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, TaskAgent.class);
    }

    @Override
    public TaskAgent getAgent(int poolId, int agentId, final boolean includeAssignedRequest, final boolean includeCapabilities, final boolean includeLastCompletedRequest, final String[] propertyFilters) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("includeAssignedRequest", includeAssignedRequest);
                this.put("includeCapabilities", includeCapabilities);
                this.put("includeLastCompletedRequest", includeLastCompletedRequest);
                this.put("propertyFilters", String.join((CharSequence)",", propertyFilters));
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "a85b8835-c1a1-4aac-ae97-1c3d0ba72dbd", null, "distributedtask/pools", poolId + "/agents/" + agentId, null, "7.1-preview.1", q, null, null);
        return this.MAPPER.mapJsonResponse(r, TaskAgent.class);
    }

    @Override
    public TaskAgents getAgents(int poolId) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "a85b8835-c1a1-4aac-ae97-1c3d0ba72dbd", null, "distributedtask/pools", poolId + "/agents", null, "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, TaskAgents.class);
    }

    @Override
    public TaskAgents getAgents(int poolId, final String agentName, final String[] demands, final boolean includeAssignedRequest, final boolean includeCapabilities, final boolean includeLastCompletedRequest, final String[] propertyFilters) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("agentName", agentName);
                this.put("demands", String.join((CharSequence)",", demands));
                this.put("includeAssignedRequest", includeAssignedRequest);
                this.put("includeCapabilities", includeCapabilities);
                this.put("includeLastCompletedRequest", includeLastCompletedRequest);
                this.put("propertyFilters", String.join((CharSequence)",", propertyFilters));
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "a85b8835-c1a1-4aac-ae97-1c3d0ba72dbd", null, "distributedtask/pools", poolId + "/agents", null, "7.1-preview.1", q, null, null);
        return this.MAPPER.mapJsonResponse(r, TaskAgents.class);
    }

    @Override
    public TaskAgent updateAgent(int poolId, int agentId, TaskAgent requestBody) throws AzDException {
        String r = RestClient.send(RequestMethod.PATCH, this.CONNECTION, "a85b8835-c1a1-4aac-ae97-1c3d0ba72dbd", null, "distributedtask/pools", poolId + "/agents/" + agentId, null, "7.1-preview.1", null, requestBody, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, TaskAgent.class);
    }

    @Override
    public DeploymentGroup addDeploymentGroup(final String name, final String description) throws AzDException {
        HashMap<String, Object> requestBody = new HashMap<String, Object>(){
            {
                this.put("name", name);
                this.put("description", description);
            }
        };
        String r = RestClient.send(RequestMethod.POST, this.CONNECTION, "a85b8835-c1a1-4aac-ae97-1c3d0ba72dbd", this.CONNECTION.getProject(), "distributedtask/deploymentgroups", null, null, "7.1-preview.1", null, requestBody, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, DeploymentGroup.class);
    }

    @Override
    public DeploymentGroup addDeploymentGroup(final String name, final String description, final int poolId) throws AzDException {
        HashMap<String, Object> requestBody = new HashMap<String, Object>(){
            {
                this.put("name", name);
                this.put("description", description);
                this.put("poolId", poolId);
            }
        };
        String r = RestClient.send(RequestMethod.POST, this.CONNECTION, "a85b8835-c1a1-4aac-ae97-1c3d0ba72dbd", this.CONNECTION.getProject(), "distributedtask/deploymentgroups", null, null, "7.1-preview.1", null, requestBody, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, DeploymentGroup.class);
    }

    @Override
    public Void deleteDeploymentGroup(int deploymentGroupId) throws AzDException {
        String r = RestClient.send(RequestMethod.DELETE, this.CONNECTION, "a85b8835-c1a1-4aac-ae97-1c3d0ba72dbd", this.CONNECTION.getProject(), "distributedtask/deploymentgroups", Integer.toString(deploymentGroupId), null, "7.1-preview.1", null, null, null);
        if (!r.isEmpty()) {
            this.MAPPER.mapJsonResponse(r, Map.class);
        }
        return null;
    }

    @Override
    public DeploymentGroup getDeploymentGroup(int deploymentGroupId) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "a85b8835-c1a1-4aac-ae97-1c3d0ba72dbd", this.CONNECTION.getProject(), "distributedtask/deploymentgroups", Integer.toString(deploymentGroupId), null, "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, DeploymentGroup.class);
    }

    @Override
    public DeploymentGroup getDeploymentGroup(int deploymentGroupId, final DeploymentGroupExpands expand, final DeploymentGroupActionFilter actionFilter) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("$expand", expand.toString().toLowerCase());
                this.put("actionFilter", actionFilter.toString().toLowerCase());
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "a85b8835-c1a1-4aac-ae97-1c3d0ba72dbd", this.CONNECTION.getProject(), "distributedtask/deploymentgroups", Integer.toString(deploymentGroupId), null, "7.1-preview.1", q, null, null);
        return this.MAPPER.mapJsonResponse(r, DeploymentGroup.class);
    }

    @Override
    public DeploymentGroups getDeploymentGroups() throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "a85b8835-c1a1-4aac-ae97-1c3d0ba72dbd", this.CONNECTION.getProject(), "distributedtask/deploymentgroups", null, null, "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, DeploymentGroups.class);
    }

    @Override
    public DeploymentGroups getDeploymentGroups(final int top) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("$top", top);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "a85b8835-c1a1-4aac-ae97-1c3d0ba72dbd", this.CONNECTION.getProject(), "distributedtask/deploymentgroups", null, null, "7.1-preview.1", q, null, null);
        return this.MAPPER.mapJsonResponse(r, DeploymentGroups.class);
    }

    @Override
    public DeploymentGroups getDeploymentGroups(final int[] ids) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("ids", DistributedTaskApi.this.intArrayToString(ids));
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "a85b8835-c1a1-4aac-ae97-1c3d0ba72dbd", this.CONNECTION.getProject(), "distributedtask/deploymentgroups", null, null, "7.1-preview.1", q, null, null);
        return this.MAPPER.mapJsonResponse(r, DeploymentGroups.class);
    }

    @Override
    public DeploymentGroups getDeploymentGroups(final String name) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("name", name);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "a85b8835-c1a1-4aac-ae97-1c3d0ba72dbd", this.CONNECTION.getProject(), "distributedtask/deploymentgroups", null, null, "7.1-preview.1", q, null, null);
        return this.MAPPER.mapJsonResponse(r, DeploymentGroups.class);
    }

    @Override
    public DeploymentGroups getDeploymentGroups(final DeploymentGroupExpands expand) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("$expand", expand.toString().toLowerCase());
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "a85b8835-c1a1-4aac-ae97-1c3d0ba72dbd", this.CONNECTION.getProject(), "distributedtask/deploymentgroups", null, null, "7.1-preview.1", q, null, null);
        return this.MAPPER.mapJsonResponse(r, DeploymentGroups.class);
    }

    @Override
    public DeploymentGroups getDeploymentGroups(final DeploymentGroupExpands expand, final int top, final DeploymentGroupActionFilter actionFilter, final String continuationToken, final int[] ids, final String name) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("$expand", expand.toString().toLowerCase());
                this.put("$top", top);
                this.put("actionFilter", actionFilter.toString().toLowerCase());
                this.put("continuationToken", continuationToken);
                this.put("ids", DistributedTaskApi.this.intArrayToString(ids));
                this.put("name", name);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "a85b8835-c1a1-4aac-ae97-1c3d0ba72dbd", this.CONNECTION.getProject(), "distributedtask/deploymentgroups", null, null, "7.1-preview.1", q, null, null);
        return this.MAPPER.mapJsonResponse(r, DeploymentGroups.class);
    }

    @Override
    public DeploymentGroup updateDeploymentGroup(int deploymentGroupId, final String name, final String description) throws AzDException {
        HashMap<String, Object> requestBody = new HashMap<String, Object>(){
            {
                this.put("name", name);
                this.put("description", description);
            }
        };
        String r = RestClient.send(RequestMethod.PATCH, this.CONNECTION, "a85b8835-c1a1-4aac-ae97-1c3d0ba72dbd", this.CONNECTION.getProject(), "distributedtask/deploymentgroups", Integer.toString(deploymentGroupId), null, "7.1-preview.1", null, requestBody, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, DeploymentGroup.class);
    }

    @Override
    public EnvironmentInstance addEnvironment(final String name, final String description) throws AzDException {
        HashMap<String, Object> requestBody = new HashMap<String, Object>(){
            {
                this.put("name", name);
                this.put("description", description);
            }
        };
        String r = RestClient.send(RequestMethod.POST, this.CONNECTION, "a85b8835-c1a1-4aac-ae97-1c3d0ba72dbd", this.CONNECTION.getProject(), "distributedtask/environments", null, null, "7.1-preview.1", null, requestBody, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, EnvironmentInstance.class);
    }

    @Override
    public Void deleteEnvironment(int environmentId) throws AzDException {
        String r = RestClient.send(RequestMethod.DELETE, this.CONNECTION, "a85b8835-c1a1-4aac-ae97-1c3d0ba72dbd", this.CONNECTION.getProject(), "distributedtask/environments", Integer.toString(environmentId), null, "7.1-preview.1", null, null, null);
        if (!r.isEmpty()) {
            this.MAPPER.mapJsonResponse(r, Map.class);
        }
        return null;
    }

    @Override
    public EnvironmentInstance getEnvironment(int environmentId) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "a85b8835-c1a1-4aac-ae97-1c3d0ba72dbd", this.CONNECTION.getProject(), "distributedtask/environments", Integer.toString(environmentId), null, "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, EnvironmentInstance.class);
    }

    @Override
    public EnvironmentInstance getEnvironment(int environmentId, final EnvironmentExpands expands) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("expands", expands.toString().toLowerCase());
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "a85b8835-c1a1-4aac-ae97-1c3d0ba72dbd", this.CONNECTION.getProject(), "distributedtask/environments", Integer.toString(environmentId), null, "7.1-preview.1", q, null, null);
        return this.MAPPER.mapJsonResponse(r, EnvironmentInstance.class);
    }

    @Override
    public EnvironmentInstances getEnvironments() throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "a85b8835-c1a1-4aac-ae97-1c3d0ba72dbd", this.CONNECTION.getProject(), "distributedtask/environments", null, null, "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, EnvironmentInstances.class);
    }

    @Override
    public EnvironmentInstances getEnvironments(final int top) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("$top", top);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "a85b8835-c1a1-4aac-ae97-1c3d0ba72dbd", this.CONNECTION.getProject(), "distributedtask/environments", null, null, "7.1-preview.1", q, null, null);
        return this.MAPPER.mapJsonResponse(r, EnvironmentInstances.class);
    }

    @Override
    public EnvironmentInstances getEnvironments(final String name) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("name", name);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "a85b8835-c1a1-4aac-ae97-1c3d0ba72dbd", this.CONNECTION.getProject(), "distributedtask/environments", null, null, "7.1-preview.1", q, null, null);
        return this.MAPPER.mapJsonResponse(r, EnvironmentInstances.class);
    }

    @Override
    public EnvironmentInstances getEnvironments(final int top, final String continuationToken, final String name) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("$top", top);
                this.put("continuationToken", continuationToken);
                this.put("name", name);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "a85b8835-c1a1-4aac-ae97-1c3d0ba72dbd", this.CONNECTION.getProject(), "distributedtask/environments", null, null, "7.1-preview.1", q, null, null);
        return this.MAPPER.mapJsonResponse(r, EnvironmentInstances.class);
    }

    @Override
    public EnvironmentInstance updateEnvironment(int environmentId, final String name, final String description) throws AzDException {
        HashMap<String, Object> requestBody = new HashMap<String, Object>(){
            {
                this.put("name", name);
                this.put("description", description);
            }
        };
        String r = RestClient.send(RequestMethod.PATCH, this.CONNECTION, "a85b8835-c1a1-4aac-ae97-1c3d0ba72dbd", this.CONNECTION.getProject(), "distributedtask/environments", Integer.toString(environmentId), null, "7.1-preview.1", null, requestBody, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, EnvironmentInstance.class);
    }

    @Override
    public VariableGroup addVariableGroup(final VariableGroupDefinition variableGroupDefinition) throws AzDException {
        VariableGroupProjectReference ref = new VariableGroupProjectReference();
        ref.setName(variableGroupDefinition.getName());
        ref.setDescription(variableGroupDefinition.getDescription());
        ref.setProjectReference(variableGroupDefinition.getProjectReference());
        final ArrayList<VariableGroupProjectReference> o = new ArrayList<VariableGroupProjectReference>();
        o.add(ref);
        HashMap<String, Object> requestBody = new HashMap<String, Object>(){
            {
                this.put("variableGroupProjectReferences", o);
                this.put("name", variableGroupDefinition.getName());
                this.put("description", variableGroupDefinition.getDescription());
                this.put("type", variableGroupDefinition.getType());
                this.put("variables", variableGroupDefinition.getVariables());
                this.put("providerData", variableGroupDefinition.getProviderData());
            }
        };
        String r = RestClient.send(RequestMethod.POST, this.CONNECTION, "a85b8835-c1a1-4aac-ae97-1c3d0ba72dbd", null, "distributedtask/variablegroups", null, null, "7.1-preview.2", null, requestBody, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, VariableGroup.class);
    }

    @Override
    public VariableGroup addVariableGroup(String name, String description, VariableGroupMap variables) throws AzDException {
        VariableGroupDefinition definition = new VariableGroupDefinition();
        ProjectReference projectReference = new ProjectReference();
        CoreApi core = new CoreApi(this.CONNECTION);
        Project project = core.getProject(this.CONNECTION.getProject());
        projectReference.setName(project.getName());
        projectReference.setId(project.getId());
        definition.setName(name);
        definition.setDescription(description);
        definition.setVariables(variables.get());
        definition.setProjectReference(projectReference);
        definition.setType(VariableGroupType.Vsts);
        return this.addVariableGroup(definition);
    }

    @Override
    public Void deleteVariableGroup(int variableGroupId, final String[] projectIds) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("projectIds", String.join((CharSequence)",", projectIds));
            }
        };
        String r = RestClient.send(RequestMethod.DELETE, this.CONNECTION, "a85b8835-c1a1-4aac-ae97-1c3d0ba72dbd", null, "distributedtask/variablegroups", Integer.toString(variableGroupId), null, "7.1-preview.2", q, null, null);
        if (!r.isEmpty()) {
            this.MAPPER.mapJsonResponse(r, Map.class);
        }
        return null;
    }

    @Override
    public VariableGroup getVariableGroup(int variableGroupId) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "a85b8835-c1a1-4aac-ae97-1c3d0ba72dbd", this.CONNECTION.getProject(), "distributedtask/variablegroups", Integer.toString(variableGroupId), null, "7.1-preview.2", null, null, null);
        return this.MAPPER.mapJsonResponse(r, VariableGroup.class);
    }

    @Override
    public VariableGroups getVariableGroups() throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "a85b8835-c1a1-4aac-ae97-1c3d0ba72dbd", this.CONNECTION.getProject(), "distributedtask/variablegroups", null, null, "7.1-preview.2", null, null, null);
        return this.MAPPER.mapJsonResponse(r, VariableGroups.class);
    }

    @Override
    public VariableGroups getVariableGroups(final int top) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("$top", top);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "a85b8835-c1a1-4aac-ae97-1c3d0ba72dbd", this.CONNECTION.getProject(), "distributedtask/variablegroups", null, null, "7.1-preview.2", q, null, null);
        return this.MAPPER.mapJsonResponse(r, VariableGroups.class);
    }

    @Override
    public VariableGroups getVariableGroups(final String groupName) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("groupName", groupName);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "a85b8835-c1a1-4aac-ae97-1c3d0ba72dbd", this.CONNECTION.getProject(), "distributedtask/variablegroups", null, null, "7.1-preview.2", q, null, null);
        return this.MAPPER.mapJsonResponse(r, VariableGroups.class);
    }

    @Override
    public VariableGroups getVariableGroups(final int top, final VariableGroupActionFilter actionFilter, final int continuationToken, final String groupName, final VariableGroupQueryOrder queryOrder) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("$top", top);
                this.put("actionFilter", actionFilter.toString().toLowerCase());
                this.put("continuationToken", continuationToken);
                this.put("groupName", groupName);
                this.put("queryOrder", queryOrder.toString().toLowerCase());
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "a85b8835-c1a1-4aac-ae97-1c3d0ba72dbd", this.CONNECTION.getProject(), "distributedtask/variablegroups", null, null, "7.1-preview.2", q, null, null);
        return this.MAPPER.mapJsonResponse(r, VariableGroups.class);
    }

    @Override
    public VariableGroup updateVariableGroup(int groupId, String name, String description, VariableGroupMap variables) throws AzDException {
        VariableGroupDefinition definition = new VariableGroupDefinition();
        ProjectReference projectReference = new ProjectReference();
        CoreApi core = new CoreApi(this.CONNECTION);
        Project project = core.getProject(this.CONNECTION.getProject());
        projectReference.setName(project.getName());
        projectReference.setId(project.getId());
        definition.setName(name);
        definition.setDescription(description);
        definition.setVariables(variables.get());
        definition.setProjectReference(projectReference);
        definition.setType(VariableGroupType.Vsts);
        return this.updateVariableGroup(groupId, definition);
    }

    @Override
    public VariableGroup updateVariableGroup(int groupId, final VariableGroupDefinition variableGroupDefinition) throws AzDException {
        VariableGroupProjectReference ref = new VariableGroupProjectReference();
        ref.setName(variableGroupDefinition.getName());
        ref.setDescription(variableGroupDefinition.getDescription());
        ref.setProjectReference(variableGroupDefinition.getProjectReference());
        final ArrayList<VariableGroupProjectReference> o = new ArrayList<VariableGroupProjectReference>();
        o.add(ref);
        HashMap<String, Object> requestBody = new HashMap<String, Object>(){
            {
                this.put("variableGroupProjectReferences", o);
                this.put("name", variableGroupDefinition.getName());
                this.put("description", variableGroupDefinition.getDescription());
                this.put("type", variableGroupDefinition.getType());
                this.put("variables", variableGroupDefinition.getVariables());
                this.put("providerData", variableGroupDefinition.getProviderData());
            }
        };
        String r = RestClient.send(RequestMethod.PUT, this.CONNECTION, "a85b8835-c1a1-4aac-ae97-1c3d0ba72dbd", null, "distributedtask/variablegroups", Integer.toString(groupId), null, "7.1-preview.2", null, requestBody, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, VariableGroup.class);
    }

    private String intArrayToString(int[] i) {
        CharSequence[] r = (String[])Arrays.stream(i).mapToObj(String::valueOf).toArray(String[]::new);
        return String.join((CharSequence)",", r);
    }
}

