/*
 * Decompiled with CFR 0.152.
 */
package org.azd.extensionmanagement;

import java.util.HashMap;
import java.util.Map;
import org.azd.connection.Connection;
import org.azd.enums.CustomHeader;
import org.azd.enums.ExtensionStateFlags;
import org.azd.enums.RequestMethod;
import org.azd.exceptions.AzDException;
import org.azd.extensionmanagement.types.InstalledExtension;
import org.azd.extensionmanagement.types.InstalledExtensions;
import org.azd.helpers.JsonMapper;
import org.azd.interfaces.ExtensionManagementDetails;
import org.azd.utils.AzDAsyncApi;
import org.azd.utils.RestClient;

public class ExtensionManagementApi
extends AzDAsyncApi<ExtensionManagementApi>
implements ExtensionManagementDetails {
    private final Connection CONNECTION;
    private final JsonMapper MAPPER = new JsonMapper();
    private final String AREA = "extensionmanagement";
    private final String EXTENSIONMANAGEMENT = "6c2b0933-3600-42ae-bf8b-93d4f7e83594";

    public ExtensionManagementApi(Connection connection) {
        this.CONNECTION = connection;
    }

    @Override
    public InstalledExtension getExtension(String extensionId, String publisherId) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "6c2b0933-3600-42ae-bf8b-93d4f7e83594", null, "extensionmanagement/installedextensions", extensionId + "/" + publisherId, null, "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, InstalledExtension.class);
    }

    @Override
    public InstalledExtension getExtension(String extensionId, String publisherId, final String[] assetTypes) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("assetTypes", String.join((CharSequence)",", assetTypes));
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "6c2b0933-3600-42ae-bf8b-93d4f7e83594", null, "extensionmanagement/installedextensions", extensionId + "/" + publisherId, null, "7.1-preview.1", q, null, null);
        return this.MAPPER.mapJsonResponse(r, InstalledExtension.class);
    }

    @Override
    public InstalledExtensions getExtensions() throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "6c2b0933-3600-42ae-bf8b-93d4f7e83594", null, "extensionmanagement/installedextensions", null, null, "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, InstalledExtensions.class);
    }

    @Override
    public InstalledExtension installExtension(String publisherId, String extensionId, String version) throws AzDException {
        String id = publisherId + "/" + extensionId;
        if (version != null) {
            id = id + "/" + version;
        }
        String r = RestClient.send(RequestMethod.POST, this.CONNECTION, "6c2b0933-3600-42ae-bf8b-93d4f7e83594", null, "extensionmanagement/installedextensionsbyname", id, null, "7.1-preview.1", null, null, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, InstalledExtension.class);
    }

    @Override
    public Void uninstallExtension(String publisherId, String extensionId) throws AzDException {
        String id = publisherId + "/" + extensionId;
        String r = RestClient.send(RequestMethod.DELETE, this.CONNECTION, "6c2b0933-3600-42ae-bf8b-93d4f7e83594", null, "extensionmanagement/installedextensionsbyname", id, null, "7.1-preview.1", null, null, null);
        if (!r.isEmpty()) {
            this.MAPPER.mapJsonResponse(r, Map.class);
        }
        return null;
    }

    @Override
    public Void uninstallExtension(String publisherId, String extensionId, final String reason, final String reasonCode) throws AzDException {
        String id = publisherId + "/" + extensionId;
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("reason", reason);
                this.put("reasonCode", reasonCode);
            }
        };
        String r = RestClient.send(RequestMethod.DELETE, this.CONNECTION, "6c2b0933-3600-42ae-bf8b-93d4f7e83594", null, "extensionmanagement/installedextensionsbyname", id, null, "7.1-preview.1", q, null, null);
        if (!r.isEmpty()) {
            this.MAPPER.mapJsonResponse(r, Map.class);
        }
        return null;
    }

    @Override
    public InstalledExtension updateExtension(final String publisherId, final String extensionId, final ExtensionStateFlags extensionState) throws AzDException {
        HashMap<String, Object> body = new HashMap<String, Object>(){
            {
                this.put("publisherId", publisherId);
                this.put("extensionId", extensionId);
                this.put("installState", new HashMap<String, Object>(){
                    {
                        this.put("flags", extensionState.toString().toLowerCase());
                    }
                });
            }
        };
        String r = RestClient.send(RequestMethod.PATCH, this.CONNECTION, "6c2b0933-3600-42ae-bf8b-93d4f7e83594", null, "extensionmanagement/installedextensions", null, null, "7.1-preview.1", null, body, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, InstalledExtension.class);
    }
}

