/*
 * Decompiled with CFR 0.152.
 */
package org.azd.feedmanagement;

import java.util.HashMap;
import java.util.Map;
import org.azd.connection.Connection;
import org.azd.enums.CustomHeader;
import org.azd.enums.FeedViewType;
import org.azd.enums.FeedVisibility;
import org.azd.enums.RequestMethod;
import org.azd.exceptions.AzDException;
import org.azd.feedmanagement.types.Feed;
import org.azd.feedmanagement.types.FeedPermissions;
import org.azd.feedmanagement.types.FeedView;
import org.azd.feedmanagement.types.FeedViews;
import org.azd.feedmanagement.types.Feeds;
import org.azd.helpers.JsonMapper;
import org.azd.interfaces.FeedManagementDetails;
import org.azd.utils.AzDAsyncApi;
import org.azd.utils.RestClient;

public class FeedManagementApi
extends AzDAsyncApi<FeedManagementApi>
implements FeedManagementDetails {
    private final Connection CONNECTION;
    private final JsonMapper MAPPER = new JsonMapper();
    private final String AREA = "packaging";
    private final String PACKAGING = "7ab4e64e-c4d8-4f50-ae73-5ef2e21642a5";

    public FeedManagementApi(Connection connection) {
        this.CONNECTION = connection;
    }

    @Override
    public Feed createFeed(final String name, final String description, final boolean badgesEnabled, final boolean hideDeletedPackageVersions) throws AzDException {
        HashMap<String, Object> requestBody = new HashMap<String, Object>(){
            {
                this.put("name", name);
                this.put("description", description);
                this.put("badgesEnabled", badgesEnabled);
                this.put("hideDeletedPackageVersions", hideDeletedPackageVersions);
            }
        };
        String r = RestClient.send(RequestMethod.POST, this.CONNECTION, "7ab4e64e-c4d8-4f50-ae73-5ef2e21642a5", this.CONNECTION.getProject() != null ? this.CONNECTION.getProject() : null, "packaging", null, "feeds", "7.1-preview.1", null, requestBody, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, Feed.class);
    }

    @Override
    public FeedView createFeedView(String feedName, final String name, final FeedViewType feedViewType, final FeedVisibility visibility) throws AzDException {
        HashMap<String, Object> requestBody = new HashMap<String, Object>(){
            {
                this.put("name", name);
                this.put("type", feedViewType.toString().toLowerCase());
                this.put("visibility", visibility.toString().toLowerCase());
            }
        };
        String r = RestClient.send(RequestMethod.POST, this.CONNECTION, "7ab4e64e-c4d8-4f50-ae73-5ef2e21642a5", this.CONNECTION.getProject() != null ? this.CONNECTION.getProject() : null, "packaging/feeds", feedName, "views", "7.1-preview.1", null, requestBody, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, FeedView.class);
    }

    @Override
    public Void deleteFeed(String feedId) throws AzDException {
        String r = RestClient.send(RequestMethod.DELETE, this.CONNECTION, "7ab4e64e-c4d8-4f50-ae73-5ef2e21642a5", this.CONNECTION.getProject() != null ? this.CONNECTION.getProject() : null, "packaging/feeds", feedId, null, "7.1-preview.1", null, null, null);
        if (!r.isEmpty()) {
            this.MAPPER.mapJsonResponse(r, Map.class);
        }
        return null;
    }

    @Override
    public Void deleteFeedView(String feedId, String feedViewId) throws AzDException {
        String r = RestClient.send(RequestMethod.DELETE, this.CONNECTION, "7ab4e64e-c4d8-4f50-ae73-5ef2e21642a5", this.CONNECTION.getProject() != null ? this.CONNECTION.getProject() : null, "packaging/feeds", feedId, "views/" + feedViewId, "7.1-preview.1", null, null, null);
        if (!r.isEmpty()) {
            this.MAPPER.mapJsonResponse(r, Map.class);
        }
        return null;
    }

    @Override
    public Feed getFeed(String feedName) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "7ab4e64e-c4d8-4f50-ae73-5ef2e21642a5", this.CONNECTION.getProject() != null ? this.CONNECTION.getProject() : null, "packaging/Feeds", feedName, null, "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, Feed.class);
    }

    @Override
    public Feed getFeed(String feedName, final boolean includeDeletedUpstreams) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("includeDeletedUpstreams", includeDeletedUpstreams);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "7ab4e64e-c4d8-4f50-ae73-5ef2e21642a5", this.CONNECTION.getProject() != null ? this.CONNECTION.getProject() : null, "packaging/Feeds", feedName, null, "7.1-preview.1", q, null, null);
        return this.MAPPER.mapJsonResponse(r, Feed.class);
    }

    @Override
    public FeedPermissions getFeedPermissions(String feedName) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "7ab4e64e-c4d8-4f50-ae73-5ef2e21642a5", this.CONNECTION.getProject() != null ? this.CONNECTION.getProject() : null, "packaging/Feeds", feedName, "permissions", "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, FeedPermissions.class);
    }

    @Override
    public FeedPermissions getFeedPermissions(String feedName, final boolean excludeInheritedPermissions, final String identityDescriptor, final boolean includeDeletedFeeds, final boolean includeIds) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("excludeInheritedPermissions", excludeInheritedPermissions);
                this.put("identityDescriptor", identityDescriptor);
                this.put("includeDeletedFeeds", includeDeletedFeeds);
                this.put("includeIds", includeIds);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "7ab4e64e-c4d8-4f50-ae73-5ef2e21642a5", this.CONNECTION.getProject() != null ? this.CONNECTION.getProject() : null, "packaging/Feeds", feedName, "permissions", "7.1-preview.1", q, null, null);
        return this.MAPPER.mapJsonResponse(r, FeedPermissions.class);
    }

    @Override
    public FeedView getFeedView(String feedName, String feedViewId) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "7ab4e64e-c4d8-4f50-ae73-5ef2e21642a5", this.CONNECTION.getProject() != null ? this.CONNECTION.getProject() : null, "packaging/Feeds", feedName, "views/" + feedViewId, "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, FeedView.class);
    }

    @Override
    public FeedViews getFeedViews(String feedName) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "7ab4e64e-c4d8-4f50-ae73-5ef2e21642a5", this.CONNECTION.getProject() != null ? this.CONNECTION.getProject() : null, "packaging/Feeds", feedName, "views", "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, FeedViews.class);
    }

    @Override
    public Feeds getFeeds() throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "7ab4e64e-c4d8-4f50-ae73-5ef2e21642a5", this.CONNECTION.getProject() != null ? this.CONNECTION.getProject() : null, "packaging", null, "Feeds", "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, Feeds.class);
    }

    @Override
    public Feeds getFeeds(final String feedRole, final boolean includeDeletedUpstreams, final boolean includeUrls) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("feedRole", feedRole);
                this.put("includeDeletedUpstreams", includeDeletedUpstreams);
                this.put("includeUrls", includeUrls);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "7ab4e64e-c4d8-4f50-ae73-5ef2e21642a5", this.CONNECTION.getProject() != null ? this.CONNECTION.getProject() : null, "packaging", null, "Feeds", "7.1-preview.1", q, null, null);
        return this.MAPPER.mapJsonResponse(r, Feeds.class);
    }

    @Override
    public FeedPermissions setFeedPermissions(String feedId, FeedPermissions feedPermissions) throws AzDException {
        String r = RestClient.send(RequestMethod.PATCH, this.CONNECTION, "7ab4e64e-c4d8-4f50-ae73-5ef2e21642a5", this.CONNECTION.getProject() != null ? this.CONNECTION.getProject() : null, "packaging/Feeds", feedId, "permissions", "7.1-preview.1", null, feedPermissions.getFeedPermission(), CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, FeedPermissions.class);
    }

    @Override
    public Feed updateFeed(String feedId, Feed feed) throws AzDException {
        String r = RestClient.send(RequestMethod.PATCH, this.CONNECTION, "7ab4e64e-c4d8-4f50-ae73-5ef2e21642a5", this.CONNECTION.getProject() != null ? this.CONNECTION.getProject() : null, "packaging/Feeds", feedId, null, "7.1-preview.1", null, feed, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, Feed.class);
    }

    @Override
    public FeedView updateFeedView(String feedName, String feedViewName, FeedView feedView) throws AzDException {
        String r = RestClient.send(RequestMethod.PATCH, this.CONNECTION, "7ab4e64e-c4d8-4f50-ae73-5ef2e21642a5", this.CONNECTION.getProject() != null ? this.CONNECTION.getProject() : null, "packaging/Feeds", feedName, "views/" + feedViewName, "7.1-preview.1", null, feedView, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, FeedView.class);
    }
}

