/*
 * Decompiled with CFR 0.152.
 */
package org.azd.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.azd.connection.Connection;
import org.azd.enums.CustomHeader;
import org.azd.enums.RequestMethod;
import org.azd.exceptions.AzDException;
import org.azd.graph.types.GraphDescriptor;
import org.azd.graph.types.GraphGroup;
import org.azd.graph.types.GraphGroups;
import org.azd.graph.types.GraphMembership;
import org.azd.graph.types.GraphMemberships;
import org.azd.graph.types.GraphUser;
import org.azd.graph.types.GraphUsers;
import org.azd.graph.types.SubjectLookupResponse;
import org.azd.helpers.JsonMapper;
import org.azd.interfaces.GraphDetails;
import org.azd.utils.AzDAsyncApi;
import org.azd.utils.RestClient;

public class GraphApi
extends AzDAsyncApi<GraphApi>
implements GraphDetails {
    private final Connection CONNECTION;
    private final JsonMapper MAPPER = new JsonMapper();
    private final String AREA = "graph";
    private final String GRAPH = "bb1e7ec9-e901-4b68-999a-de7012b920f8";

    public GraphApi(Connection connection) {
        this.CONNECTION = connection;
    }

    @Override
    public GraphUser createUser(final String emailId, String userDescriptor) throws AzDException {
        HashMap<String, Object> b = new HashMap<String, Object>(){
            {
                this.put("principalName", emailId);
            }
        };
        String r = RestClient.send(RequestMethod.POST, this.CONNECTION, "bb1e7ec9-e901-4b68-999a-de7012b920f8", null, "graph", null, "users/" + userDescriptor, "7.1-preview.1", null, b, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, GraphUser.class);
    }

    @Override
    public GraphUser addUserToGroup(final String emailId, final String groupDescriptor) throws AzDException {
        HashMap<String, Object> b = new HashMap<String, Object>(){
            {
                this.put("principalName", emailId);
            }
        };
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("groupDescriptors", groupDescriptor);
            }
        };
        String r = RestClient.send(RequestMethod.POST, this.CONNECTION, "bb1e7ec9-e901-4b68-999a-de7012b920f8", null, "graph", null, "users", "7.1-preview.1", q, b, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, GraphUser.class);
    }

    @Override
    public Void deleteUser(String userDescriptor) throws AzDException {
        String r = RestClient.send(RequestMethod.DELETE, this.CONNECTION, "bb1e7ec9-e901-4b68-999a-de7012b920f8", null, "graph", null, "users/" + userDescriptor, "7.1-preview.1", null, null, null);
        if (!r.isEmpty()) {
            this.MAPPER.mapJsonResponse(r, Map.class);
        }
        return null;
    }

    @Override
    public GraphUser getUser(String userDescriptor) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "bb1e7ec9-e901-4b68-999a-de7012b920f8", null, "graph", null, "users/" + userDescriptor, "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, GraphUser.class);
    }

    @Override
    public GraphUsers getUsers() throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "bb1e7ec9-e901-4b68-999a-de7012b920f8", null, "graph", null, "users", "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, GraphUsers.class);
    }

    @Override
    public GraphUsers getUsers(final String continuationToken, final String scopeDescriptor, final String subjectTypes) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("subjectTypes", String.join((CharSequence)",", subjectTypes));
                this.put("continuationToken", continuationToken);
                this.put("scopeDescriptor", scopeDescriptor);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "bb1e7ec9-e901-4b68-999a-de7012b920f8", null, "graph", null, "users", "7.1-preview.1", q, null, null);
        return this.MAPPER.mapJsonResponse(r, GraphUsers.class);
    }

    @Override
    public GraphGroup getGroup(String groupDescriptor) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "bb1e7ec9-e901-4b68-999a-de7012b920f8", null, "graph", null, "groups/" + groupDescriptor, "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, GraphGroup.class);
    }

    @Override
    public GraphGroups getGroups() throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "bb1e7ec9-e901-4b68-999a-de7012b920f8", null, "graph", null, "groups", "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, GraphGroups.class);
    }

    @Override
    public GraphMemberships getGroupMembersOf(String groupDescriptor) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("direction", "down");
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "bb1e7ec9-e901-4b68-999a-de7012b920f8", null, "graph", null, "memberships/" + groupDescriptor, "7.1-preview.1", q, null, null);
        return this.MAPPER.mapJsonResponse(r, GraphMemberships.class);
    }

    @Override
    public GraphMemberships getMemberOfGroups(String subjectDescriptor) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("direction", "up");
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "bb1e7ec9-e901-4b68-999a-de7012b920f8", null, "graph", null, "memberships/" + subjectDescriptor, "7.1-preview.1", q, null, null);
        return this.MAPPER.mapJsonResponse(r, GraphMemberships.class);
    }

    @Override
    public GraphMembership addMembership(String subjectDescriptor, String groupDescriptor) throws AzDException {
        String r = RestClient.send(RequestMethod.PUT, this.CONNECTION, "bb1e7ec9-e901-4b68-999a-de7012b920f8", null, "graph", null, "memberships/" + subjectDescriptor + "/" + groupDescriptor, "7.1-preview.1", null, null, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, GraphMembership.class);
    }

    @Override
    public Void removeMembership(String subjectDescriptor, String groupDescriptor) throws AzDException {
        String r = RestClient.send(RequestMethod.DELETE, this.CONNECTION, "bb1e7ec9-e901-4b68-999a-de7012b920f8", null, "graph", null, "memberships/" + subjectDescriptor + "/" + groupDescriptor, "7.1-preview.1", null, null, null);
        if (!r.isEmpty()) {
            this.MAPPER.mapJsonResponse(r, Map.class);
        }
        return null;
    }

    @Override
    public GraphMembership createGroup(String displayName, String description) throws AzDException {
        return this.createGroup(displayName, description, null);
    }

    @Override
    public GraphMembership createGroup(final String displayName, final String description, final String projectDescriptor) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                if (projectDescriptor != null) {
                    this.put("scopeDescriptor", projectDescriptor);
                }
            }
        };
        HashMap<String, Object> b = new HashMap<String, Object>(){
            {
                this.put("displayName", displayName);
                this.put("description", description);
            }
        };
        String r = RestClient.send(RequestMethod.POST, this.CONNECTION, "bb1e7ec9-e901-4b68-999a-de7012b920f8", null, "graph", null, "groups", "7.1-preview.1", q, b, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, GraphMembership.class);
    }

    @Override
    public Void deleteGroup(String groupDescriptor) throws AzDException {
        String r = RestClient.send(RequestMethod.DELETE, this.CONNECTION, "bb1e7ec9-e901-4b68-999a-de7012b920f8", null, "graph", null, "groups/" + groupDescriptor, "7.1-preview.1", null, null, null);
        if (!r.isEmpty()) {
            this.MAPPER.mapJsonResponse(r, Map.class);
        }
        return null;
    }

    @Override
    public GraphDescriptor getDescriptor(String storageKey) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "bb1e7ec9-e901-4b68-999a-de7012b920f8", null, "graph", null, "descriptors/" + storageKey, "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, GraphDescriptor.class);
    }

    @Override
    public SubjectLookupResponse subjectLookup(final String ... descriptors) throws AzDException {
        HashMap<String, Object> b = new HashMap<String, Object>(){
            {
                this.put("lookupKeys", new ArrayList<Object>(){
                    {
                        for (final String descriptor : descriptors) {
                            this.add(new HashMap<String, String>(){
                                {
                                    this.put("descriptor", descriptor);
                                }
                            });
                        }
                    }
                });
            }
        };
        String r = RestClient.send(RequestMethod.POST, this.CONNECTION, "bb1e7ec9-e901-4b68-999a-de7012b920f8", null, "graph", null, "subjectlookup", "7.1-preview.1", null, b, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, SubjectLookupResponse.class);
    }
}

