/*
 * Decompiled with CFR 0.152.
 */
package org.azd.helpers;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.InputStream;
import org.azd.enums.ApiExceptionTypes;
import org.azd.exceptions.AzDException;
import org.azd.helpers.ApiException;
import org.azd.helpers.StreamHelper;

public class JsonMapper
extends ObjectMapper {
    public JsonMapper() {
        this.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public String convertToString(Object value) throws AzDException {
        try {
            return this.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new AzDException(ApiExceptionTypes.StringValueParsingException.toString(), e.getMessage());
        }
    }

    public <T> T mapJsonResponse(String content, Class<T> valueType) throws AzDException {
        try {
            if (content.contains("innerException")) {
                throw new AzDException(this.readValue(content, ApiException.class).getTypeKey(), this.readValue(content, ApiException.class).getMessage());
            }
            if (content.contains("The request is invalid.")) {
                throw new AzDException();
            }
            if (content.contains("Object moved")) {
                throw new AzDException(ApiExceptionTypes.InvalidPersonalAccessTokenException.toString(), "Personal access token passed is invalid; Pass the valid token and try again.");
            }
            return this.readValue(content, valueType);
        }
        catch (JsonProcessingException e) {
            throw new AzDException(ApiExceptionTypes.ApiResponseParsingException.toString(), e.getMessage());
        }
    }

    public <T> T mapJsonResponse(String content, TypeReference<T> valueType) throws AzDException {
        try {
            if (content.contains("innerException")) {
                throw new AzDException(this.readValue(content, ApiException.class).getTypeKey(), this.readValue(content, ApiException.class).getMessage());
            }
            if (content.contains("The request is invalid.")) {
                throw new AzDException();
            }
            if (content.contains("Object moved")) {
                throw new AzDException(ApiExceptionTypes.InvalidPersonalAccessTokenException.toString(), "Personal access token passed is invalid; Pass the valid token and try again.");
            }
            return this.readValue(content, valueType);
        }
        catch (JsonProcessingException e) {
            throw new AzDException(ApiExceptionTypes.ApiResponseParsingException.toString(), e.getMessage());
        }
    }

    public <T> T mapJsonResponse(InputStream content, Class<T> valueType) throws AzDException {
        try {
            return this.mapJsonResponse(StreamHelper.convertToString(content), valueType);
        }
        catch (AzDException e) {
            throw new AzDException(ApiExceptionTypes.ApiResponseParsingException.toString(), e.getMessage());
        }
    }

    public <T> T mapJsonFromFile(File src, Class<T> valueType) throws AzDException {
        try {
            return this.readValue(src, valueType);
        }
        catch (Exception e) {
            throw new AzDException(ApiExceptionTypes.FileContentParsingException.toString(), e.getMessage());
        }
    }

    public JsonNode convertToJson(String jsonString) throws AzDException {
        try {
            return this.readTree(jsonString);
        }
        catch (JsonProcessingException e) {
            throw new AzDException(ApiExceptionTypes.StringValueParsingException.name(), e.getMessage());
        }
    }
}

