/*
 * Decompiled with CFR 0.152.
 */
package org.azd.helpers;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.concurrent.CompletableFuture;
import org.azd.enums.ApiExceptionTypes;
import org.azd.enums.CustomHeader;
import org.azd.enums.RequestMethod;
import org.azd.exceptions.AzDException;
import org.azd.utils.RestClient;

public class StreamHelper {
    private static int DEFAULT_BYTE_ARRAY_SIZE = 8192;

    public static int getDefaultByteArraySize() {
        return DEFAULT_BYTE_ARRAY_SIZE;
    }

    public static void setDefaultByteArraySize(int defaultByteArraySize) {
        DEFAULT_BYTE_ARRAY_SIZE = defaultByteArraySize;
    }

    public static void download(String fileName, InputStream responseStream) throws AzDException {
        try (FileOutputStream outputStream = new FileOutputStream(fileName, false);){
            int read;
            byte[] bytes = new byte[DEFAULT_BYTE_ARRAY_SIZE];
            while ((read = responseStream.read(bytes)) != -1) {
                outputStream.write(bytes, 0, read);
            }
        }
        catch (Exception e) {
            throw new AzDException(ApiExceptionTypes.InvalidArgumentException.name(), e.getMessage());
        }
    }

    public static void downloadFromUrl(String url, String fileName) throws AzDException {
        if (url.isEmpty()) {
            throw new AzDException(ApiExceptionTypes.InvalidArgumentException.name(), "Url cannot be null or empty.");
        }
        InputStream res = (InputStream)((CompletableFuture)RestClient.send(url, RequestMethod.GET, null, null, null, null, null, null, null, null, null, CustomHeader.STREAM_ACCEPT, false).thenApplyAsync(HttpResponse::body)).join();
        StreamHelper.download(fileName, res);
    }

    public static String convertToString(InputStream responseStream) throws AzDException {
        try {
            return new String(responseStream.readAllBytes(), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new AzDException(ApiExceptionTypes.InvalidArgumentException.name(), e.getMessage());
        }
    }

    public static InputStream convertToStream(File file) throws AzDException {
        try {
            return new DataInputStream(new FileInputStream(file));
        }
        catch (Exception e) {
            throw new AzDException(ApiExceptionTypes.InvalidArgumentException.name(), e.getMessage());
        }
    }

    public static InputStream convertToStream(String content) throws AzDException {
        try {
            if (content.isEmpty()) {
                throw new AzDException("Content cannot be empty.");
            }
            return new ByteArrayInputStream(content.getBytes());
        }
        catch (Exception e) {
            throw new AzDException(ApiExceptionTypes.InvalidArgumentException.name(), e.getMessage());
        }
    }

    public static String convertStreamToBase64(InputStream content) throws AzDException {
        try {
            return Base64.getEncoder().encodeToString(content.readAllBytes());
        }
        catch (Exception e) {
            throw new AzDException(ApiExceptionTypes.InvalidArgumentException.name(), e.getMessage());
        }
    }
}

