/*
 * Decompiled with CFR 0.152.
 */
package org.azd.maven;

import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.azd.connection.Connection;
import org.azd.enums.CustomHeader;
import org.azd.enums.Instance;
import org.azd.enums.PackageOperation;
import org.azd.enums.PackagePromote;
import org.azd.enums.PackagesBatchOperation;
import org.azd.enums.RequestMethod;
import org.azd.exceptions.AzDException;
import org.azd.helpers.JsonMapper;
import org.azd.helpers.StreamHelper;
import org.azd.interfaces.MavenDetails;
import org.azd.maven.types.MavenPackageVersionDeletionState;
import org.azd.maven.types.Package;
import org.azd.maven.types.UpstreamingBehavior;
import org.azd.utils.AzDAsyncApi;
import org.azd.utils.RestClient;

public class MavenApi
extends AzDAsyncApi<MavenApi>
implements MavenDetails {
    private final Connection CONNECTION;
    private final JsonMapper MAPPER = new JsonMapper();
    private final String AREA = "packaging";
    private final String MAVEN = "6f7f8c07-ff36-473c-bcf3-bd6cc9b6c066";
    private final String PACKAGES_RELATIVE_PATH = "_packaging";

    public MavenApi(Connection connection) {
        this.CONNECTION = connection;
    }

    @Override
    public Package getPackageVersion(String feedId, String groupId, String artifactId, String version) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "6f7f8c07-ff36-473c-bcf3-bd6cc9b6c066", this.CONNECTION.getProject(), "packaging/feeds", feedId, "maven/groups/" + groupId + "/artifacts/" + artifactId + "/versions/" + version, "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, Package.class);
    }

    @Override
    public Package getPackageVersion(String feedId, String groupId, String artifactId, String version, final boolean showDeleted) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("showDeleted", showDeleted);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "6f7f8c07-ff36-473c-bcf3-bd6cc9b6c066", this.CONNECTION.getProject(), "packaging/feeds", feedId, "maven/groups/" + groupId + "/artifacts/" + artifactId + "/versions/" + version, "7.1-preview.1", q, null, null);
        return this.MAPPER.mapJsonResponse(r, Package.class);
    }

    @Override
    public MavenPackageVersionDeletionState getPackageVersionFromRecycleBin(String feedId, String groupId, String artifactId, String version) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "6f7f8c07-ff36-473c-bcf3-bd6cc9b6c066", this.CONNECTION.getProject(), "packaging/feeds", feedId, "maven/RecycleBin/groups/" + groupId + "/artifacts/" + artifactId + "/versions/" + version, "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, MavenPackageVersionDeletionState.class);
    }

    @Override
    public UpstreamingBehavior getUpstreamingBehavior(String feedId, String groupId, String artifactId) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "6f7f8c07-ff36-473c-bcf3-bd6cc9b6c066", this.CONNECTION.getProject(), "packaging/feeds", feedId, "maven/groups/" + groupId + "/artifacts/" + artifactId + "/upstreaming", "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, UpstreamingBehavior.class);
    }

    @Override
    public InputStream downloadPackage(String feedId, String groupId, String artifactId, String version, String fileName) throws AzDException {
        String callbackUri = (String)((CompletableFuture)((CompletableFuture)RestClient.send(null, RequestMethod.GET, this.CONNECTION, "6f7f8c07-ff36-473c-bcf3-bd6cc9b6c066", this.CONNECTION.getProject(), "packaging/feeds", feedId, "maven/" + groupId + "/" + artifactId + "/" + version + "/" + fileName + "/content", "7.1-preview.1", null, null, null, true).thenApplyAsync(HttpResponse::uri)).thenApplyAsync(URI::toString)).join();
        int statusCode = (Integer)((CompletableFuture)RestClient.send(callbackUri, RequestMethod.GET, null, null, null, null, null, null, null, null, null, null, true).thenApplyAsync(HttpResponse::statusCode)).join();
        InputStream res = (InputStream)((CompletableFuture)RestClient.send(callbackUri, RequestMethod.GET, null, null, null, null, null, null, null, null, null, null, true).thenApplyAsync(HttpResponse::body)).join();
        if (statusCode != 200) {
            this.MAPPER.mapJsonResponse(StreamHelper.convertToString(res), Map.class);
        }
        return res;
    }

    @Override
    public void deletePackageVersion(String feedId, String groupId, String artifactId, String version) throws AzDException {
        String r = RestClient.send(RequestMethod.DELETE, this.CONNECTION, "6f7f8c07-ff36-473c-bcf3-bd6cc9b6c066", this.CONNECTION.getProject(), "packaging/feeds", feedId, "maven/groups/" + groupId + "/artifacts/" + artifactId + "/versions/" + version, "7.1-preview.1", null, null, null);
        if (!r.isEmpty()) {
            this.MAPPER.mapJsonResponse(r, Map.class);
        }
    }

    @Override
    public void deletePackageVersionFromRecycleBin(String feedId, String groupId, String artifactId, String version) throws AzDException {
        String r = RestClient.send(RequestMethod.DELETE, this.CONNECTION, "6f7f8c07-ff36-473c-bcf3-bd6cc9b6c066", this.CONNECTION.getProject(), "packaging/feeds", feedId, "maven/RecycleBin/groups/" + groupId + "/artifacts/" + artifactId + "/versions/" + version, "7.1-preview.1", null, null, null);
        if (!r.isEmpty()) {
            this.MAPPER.mapJsonResponse(r, Map.class);
        }
    }

    @Override
    public void updatePackageVersion(String feedId, String groupId, String artifactId, String version, PackagePromote promote) throws AzDException {
        this.updatePackageVersion(feedId, groupId, artifactId, version, promote.toString().toLowerCase());
    }

    @Override
    public void updatePackageVersion(String feedId, String groupId, String artifactId, String version, final String promote) throws AzDException {
        HashMap<String, Object> req = new HashMap<String, Object>(){
            {
                this.put("op", PackageOperation.ADD.toString());
                this.put("path", "/views/-");
                this.put("value", promote);
            }
        };
        HashMap<String, Object> body = new HashMap<String, Object>(req){
            final /* synthetic */ 2 val$req;
            {
                this.val$req = var2_2;
                this.put("views", this.val$req);
            }
        };
        String r = RestClient.send(RequestMethod.PATCH, this.CONNECTION, "6f7f8c07-ff36-473c-bcf3-bd6cc9b6c066", this.CONNECTION.getProject(), "packaging/feeds", feedId, "maven/groups/" + groupId + "/artifacts/" + artifactId + "/versions/" + version, "7.1-preview.1", null, body, CustomHeader.JSON_CONTENT_TYPE);
        if (!r.isEmpty()) {
            this.MAPPER.mapJsonResponse(r, Map.class);
        }
    }

    @Override
    public void updatePackageVersions(String feedId, String viewId, PackagesBatchOperation operation, List<Map<String, Object>> packages) throws AzDException {
        HashMap<String, Object> req = new HashMap<String, Object>();
        if (operation == PackagesBatchOperation.PROMOTE) {
            req.put("data", Map.of("viewId", viewId));
        }
        req.put("operation", operation.toString().toLowerCase());
        ArrayList<Map<String, Object>> l = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> pkg : packages) {
            l.add(Map.of("group", pkg.get("group"), "artifact", pkg.get("artifact"), "version", pkg.get("version")));
        }
        req.put("packages", l);
        String r = RestClient.send(RequestMethod.POST, this.CONNECTION, "6f7f8c07-ff36-473c-bcf3-bd6cc9b6c066", this.CONNECTION.getProject(), "packaging/feeds", feedId, "maven/packagesbatch", "7.1-preview.1", null, req, CustomHeader.JSON_CONTENT_TYPE);
        if (!r.isEmpty()) {
            this.MAPPER.mapJsonResponse(r, Map.class);
        }
    }

    @Override
    public void restorePackageVersionFromRecycleBin(String feedId, String groupId, String artifactId, String version) throws AzDException {
        String r = RestClient.send(RequestMethod.PATCH, this.CONNECTION, "6f7f8c07-ff36-473c-bcf3-bd6cc9b6c066", this.CONNECTION.getProject(), "packaging/feeds", feedId, "maven/RecycleBin/groups/" + groupId + "/artifacts/" + artifactId + "/versions/" + version, "7.1-preview.1", null, Map.of("deleted", "false"), CustomHeader.JSON_CONTENT_TYPE);
        if (!r.isEmpty()) {
            this.MAPPER.mapJsonResponse(r, Map.class);
        }
    }

    @Override
    public void setUpstreamingBehavior(String feedId, String groupId, String artifactId) throws AzDException {
        this.setUpstreamingBehavior(feedId, groupId, artifactId, "allowExternalVersions");
    }

    @Override
    public void setUpstreamingBehavior(String feedId, String groupId, String artifactId, String upstreamingBehavior) throws AzDException {
        HashMap<String, String> req = new HashMap<String, String>();
        req.put("versionsFromExternalUpstreams", upstreamingBehavior);
        String r = RestClient.send(RequestMethod.PATCH, this.CONNECTION, "6f7f8c07-ff36-473c-bcf3-bd6cc9b6c066", this.CONNECTION.getProject(), "packaging/feeds", feedId, "maven/groups/" + groupId + "/artifacts/" + artifactId + "/upstreaming", "7.1-preview.1", null, req, CustomHeader.JSON_CONTENT_TYPE);
        if (!r.isEmpty()) {
            this.MAPPER.mapJsonResponse(r, Map.class);
        }
    }

    @Override
    public void clearUpstreamingBehavior(String feedId, String groupId, String artifactId) throws AzDException {
        HashMap<String, String> req = new HashMap<String, String>();
        req.put("versionsFromExternalUpstreams", "auto");
        String r = RestClient.send(RequestMethod.PATCH, this.CONNECTION, "6f7f8c07-ff36-473c-bcf3-bd6cc9b6c066", this.CONNECTION.getProject(), "packaging/feeds", feedId, "maven/groups/" + groupId + "/artifacts/" + artifactId + "/upstreaming", "7.1-preview.1", null, req, CustomHeader.JSON_CONTENT_TYPE);
        if (!r.isEmpty()) {
            this.MAPPER.mapJsonResponse(r, Map.class);
        }
    }

    @Override
    public void updateRecycleBinPackages(String feedId, PackagesBatchOperation operation, List<Map<String, Object>> packages) throws AzDException {
        HashMap<String, Object> req = new HashMap<String, Object>();
        req.put("data", null);
        req.put("operation", operation.toString().toLowerCase());
        ArrayList<Map<String, Object>> l = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> pkg : packages) {
            l.add(Map.of("group", pkg.get("group"), "artifact", pkg.get("artifact"), "version", pkg.get("version")));
        }
        req.put("packages", l);
        String r = RestClient.send(RequestMethod.POST, this.CONNECTION, "6f7f8c07-ff36-473c-bcf3-bd6cc9b6c066", this.CONNECTION.getProject(), "packaging/feeds", feedId, "maven/RecycleBin/packagesbatch", "7.1-preview.1", null, req, CustomHeader.JSON_CONTENT_TYPE);
        if (!r.isEmpty()) {
            this.MAPPER.mapJsonResponse(r, Map.class);
        }
    }

    @Override
    public void uploadPackage(String feedId, String groupId, String artifactId, String version, String fileName, InputStream content) throws AzDException {
        String requestUrl;
        CompletableFuture<HttpResponse<String>> t;
        String r;
        String pathSeparator = "/";
        String baseInstance = Instance.BASE_INSTANCE.setSubdomain("pkgs");
        StringBuilder stringBuilder = new StringBuilder(baseInstance);
        stringBuilder.append(this.CONNECTION.getOrganization());
        if (this.CONNECTION.getProject() != null) {
            stringBuilder.append(pathSeparator).append(this.CONNECTION.getProject());
        }
        stringBuilder.append(pathSeparator + "_packaging");
        if (feedId != null) {
            stringBuilder.append(pathSeparator).append(feedId);
        }
        String area = "maven" + pathSeparator + "v1";
        stringBuilder.append(pathSeparator).append(area);
        String resource = groupId + pathSeparator + artifactId + pathSeparator + version + pathSeparator + fileName;
        if (resource != null) {
            stringBuilder.append(pathSeparator).append(resource);
        }
        if (!(r = (String)((CompletableFuture)(t = RestClient.send(requestUrl = stringBuilder.toString(), RequestMethod.PUT, this.CONNECTION, null, null, null, null, null, "7.1-preview.1", null, HttpRequest.BodyPublishers.ofInputStream(() -> content), HttpResponse.BodyHandlers.ofString(), null, false)).thenApplyAsync(HttpResponse::body)).join()).isEmpty()) {
            this.MAPPER.mapJsonResponse(r, Map.class);
        }
    }
}

