/*
 * Decompiled with CFR 0.152.
 */
package org.azd.memberentitlementmanagement;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.azd.connection.Connection;
import org.azd.enums.AccountLicenseType;
import org.azd.enums.CustomHeader;
import org.azd.enums.GroupType;
import org.azd.enums.LicensingSource;
import org.azd.enums.RequestMethod;
import org.azd.exceptions.AzDException;
import org.azd.helpers.JsonMapper;
import org.azd.interfaces.MemberEntitlementManagementDetails;
import org.azd.memberentitlementmanagement.types.GroupEntitlement;
import org.azd.memberentitlementmanagement.types.GroupEntitlements;
import org.azd.memberentitlementmanagement.types.PagedGraphMemberList;
import org.azd.memberentitlementmanagement.types.UserEntitlement;
import org.azd.memberentitlementmanagement.types.UserEntitlementsResponse;
import org.azd.memberentitlementmanagement.types.UsersSummary;
import org.azd.utils.AzDAsyncApi;
import org.azd.utils.RestClient;

public class MemberEntitlementManagementApi
extends AzDAsyncApi<MemberEntitlementManagementApi>
implements MemberEntitlementManagementDetails {
    private final Connection CONNECTION;
    private final JsonMapper MAPPER = new JsonMapper();
    private final String GROUP_AREA = "groupentitlements";
    private final String USER_AREA = "userentitlements";
    private final String MEMBERENTITLEMENTMANAGEMENT = "68ddce18-2501-45f1-a17b-7931a9922690";

    public MemberEntitlementManagementApi(Connection connection) {
        this.CONNECTION = connection;
    }

    @Override
    public GroupEntitlements getGroupEntitlements() throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "68ddce18-2501-45f1-a17b-7931a9922690", null, "groupentitlements", null, null, "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, GroupEntitlements.class);
    }

    @Override
    public GroupEntitlement getGroupEntitlement(String groupId) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "68ddce18-2501-45f1-a17b-7931a9922690", null, "groupentitlements", groupId, null, "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, GroupEntitlement.class);
    }

    @Override
    public UsersSummary getUserEntitlementSummary() throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "68ddce18-2501-45f1-a17b-7931a9922690", null, "userentitlementsummary", null, null, "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, UsersSummary.class);
    }

    @Override
    public PagedGraphMemberList getMembers(String groupId) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "68ddce18-2501-45f1-a17b-7931a9922690", null, "groupentitlements", groupId, "members", "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, PagedGraphMemberList.class);
    }

    @Override
    public PagedGraphMemberList getMembers(String groupId, final int maxResults, final String pagingToken) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("maxResults", maxResults);
                this.put("pagingToken", pagingToken);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "68ddce18-2501-45f1-a17b-7931a9922690", null, "groupentitlements", groupId, "members", "7.1-preview.1", q, null, null);
        return this.MAPPER.mapJsonResponse(r, PagedGraphMemberList.class);
    }

    @Override
    public Void removeMemberFromGroup(String groupId, String memberId) throws AzDException {
        String r = RestClient.send(RequestMethod.DELETE, this.CONNECTION, "68ddce18-2501-45f1-a17b-7931a9922690", null, "groupentitlements", groupId, "members/" + memberId, "7.1-preview.1", null, null, null);
        if (!r.isEmpty()) {
            this.MAPPER.mapJsonResponse(r, Map.class);
        }
        return null;
    }

    @Override
    public UserEntitlementsResponse addUserEntitlement(final AccountLicenseType accountLicenseType, final String emailId, final GroupType groupType, final String projectId) throws AzDException {
        LinkedHashMap<String, Object> projectEntitlement = new LinkedHashMap<String, Object>(){
            {
                this.put("group", new LinkedHashMap<String, Object>(){
                    {
                        this.put("groupType", groupType.toString().toLowerCase());
                    }
                });
                this.put("projectRef", new LinkedHashMap<String, Object>(){
                    {
                        this.put("id", projectId);
                    }
                });
            }
        };
        LinkedHashMap<String, Object> body = new LinkedHashMap<String, Object>(projectEntitlement){
            final /* synthetic */ 2 val$projectEntitlement;
            {
                this.val$projectEntitlement = var4_4;
                this.put("accessLevel", new LinkedHashMap<String, Object>(){
                    {
                        this.put("accountLicenseType", accountLicenseType.toString().toLowerCase());
                    }
                });
                this.put("user", new LinkedHashMap<String, Object>(){
                    {
                        this.put("principalName", emailId);
                        this.put("subjectKind", "user");
                    }
                });
                this.put("projectEntitlements", List.of(this.val$projectEntitlement));
            }
        };
        String r = RestClient.send(RequestMethod.POST, this.CONNECTION, "68ddce18-2501-45f1-a17b-7931a9922690", null, "userentitlements", null, null, "7.1-preview.3", null, body, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, UserEntitlementsResponse.class);
    }

    @Override
    public Void deleteUserEntitlement(String userId) throws AzDException {
        String r = RestClient.send(RequestMethod.DELETE, this.CONNECTION, "68ddce18-2501-45f1-a17b-7931a9922690", null, "userentitlements", userId, null, "7.1-preview.3", null, null, null);
        if (!r.isEmpty()) {
            this.MAPPER.mapJsonResponse(r, Map.class);
        }
        return null;
    }

    @Override
    public UserEntitlement getUserEntitlement(String userId) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "68ddce18-2501-45f1-a17b-7931a9922690", null, "userentitlements", userId, null, "7.1-preview.3", null, null, null);
        return this.MAPPER.mapJsonResponse(r, UserEntitlement.class);
    }

    @Override
    public PagedGraphMemberList getUserEntitlements() throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "68ddce18-2501-45f1-a17b-7931a9922690", null, "userentitlements", null, null, "7.1-preview.3", null, null, null);
        return this.MAPPER.mapJsonResponse(r, PagedGraphMemberList.class);
    }

    @Override
    public UserEntitlementsResponse updateUserEntitlement(String userId, List<Object> requestBody) throws AzDException {
        String r = RestClient.send(RequestMethod.PATCH, this.CONNECTION, "68ddce18-2501-45f1-a17b-7931a9922690", null, "userentitlements", userId, null, "7.1-preview.3", null, requestBody, CustomHeader.JSON_PATCH);
        return this.MAPPER.mapJsonResponse(r, UserEntitlementsResponse.class);
    }

    @Override
    public UserEntitlementsResponse updateUserEntitlement(String userId, final AccountLicenseType accountLicenseType, final LicensingSource licensingSource) throws AzDException {
        LinkedHashMap<String, Object> pos = new LinkedHashMap<String, Object>(){
            {
                this.put("from", "");
                this.put("op", "replace");
                this.put("path", "/accessLevel");
                this.put("value", new LinkedHashMap<String, Object>(){
                    {
                        this.put("accountLicenseType", accountLicenseType.toString().toLowerCase());
                        this.put("licensingSource", licensingSource.toString().toLowerCase());
                    }
                });
            }
        };
        String r = RestClient.send(RequestMethod.PATCH, this.CONNECTION, "68ddce18-2501-45f1-a17b-7931a9922690", null, "userentitlements", userId, null, "7.1-preview.3", null, List.of(pos), CustomHeader.JSON_PATCH);
        return this.MAPPER.mapJsonResponse(r, UserEntitlementsResponse.class);
    }
}

