/*
 * Decompiled with CFR 0.152.
 */
package org.azd.policy;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.azd.connection.Connection;
import org.azd.enums.CustomHeader;
import org.azd.enums.RequestMethod;
import org.azd.exceptions.AzDException;
import org.azd.helpers.JsonMapper;
import org.azd.interfaces.PolicyDetails;
import org.azd.policy.types.PolicyConfiguration;
import org.azd.policy.types.PolicyConfigurations;
import org.azd.policy.types.PolicyType;
import org.azd.policy.types.PolicyTypes;
import org.azd.utils.AzDAsyncApi;
import org.azd.utils.RestClient;

public class PolicyApi
extends AzDAsyncApi<PolicyApi>
implements PolicyDetails {
    private final Connection CONNECTION;
    private final JsonMapper MAPPER = new JsonMapper();
    private final String AREA = "policy";
    private final String POLICY = "fb13a388-40dd-4a04-b530-013a739c72ef";

    public PolicyApi(Connection connection) {
        this.CONNECTION = connection;
    }

    @Override
    public PolicyConfiguration createPolicyConfiguration(final String typeId, final boolean isEnabled, final boolean isBlocking, final Map settings) throws AzDException {
        LinkedHashMap<String, Object> h = new LinkedHashMap<String, Object>(){
            {
                this.put("isEnabled", isEnabled);
                this.put("isBlocking", isBlocking);
                this.put("type", new LinkedHashMap<String, String>(){
                    {
                        this.put("id", typeId);
                    }
                });
                this.put("settings", settings);
            }
        };
        String r = RestClient.send(RequestMethod.POST, this.CONNECTION, "fb13a388-40dd-4a04-b530-013a739c72ef", this.CONNECTION.getProject(), "policy/configurations", null, null, "7.1-preview.1", null, h, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, PolicyConfiguration.class);
    }

    @Override
    public Void deletePolicyConfiguration(int configurationId) throws AzDException {
        String r = RestClient.send(RequestMethod.DELETE, this.CONNECTION, "fb13a388-40dd-4a04-b530-013a739c72ef", this.CONNECTION.getProject(), "policy/configurations", Integer.toString(configurationId), null, "7.1-preview.1", null, null, null);
        if (!r.isEmpty()) {
            this.MAPPER.mapJsonResponse(r, Map.class);
        }
        return null;
    }

    @Override
    public PolicyConfiguration getPolicyConfiguration(int configurationId) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "fb13a388-40dd-4a04-b530-013a739c72ef", this.CONNECTION.getProject(), "policy/configurations", Integer.toString(configurationId), null, "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, PolicyConfiguration.class);
    }

    @Override
    public PolicyConfigurations getPolicyConfigurations() throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "fb13a388-40dd-4a04-b530-013a739c72ef", this.CONNECTION.getProject(), "policy/configurations", null, null, "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, PolicyConfigurations.class);
    }

    @Override
    public PolicyConfigurations getPolicyConfigurations(final int top, final String continuationToken, final String policyType) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("$top", top);
                this.put("continuationToken", continuationToken);
                this.put("policyType", policyType);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "fb13a388-40dd-4a04-b530-013a739c72ef", this.CONNECTION.getProject(), "policy/configurations", null, null, "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, PolicyConfigurations.class);
    }

    @Override
    public PolicyConfiguration updatePolicyConfiguration(int configurationId, String typeId, final boolean isEnabled, final boolean isBlocking, final Map settings) throws AzDException {
        final String id = typeId.isEmpty() ? this.getPolicyConfiguration(configurationId).getType().getId() : typeId;
        LinkedHashMap<String, Object> h = new LinkedHashMap<String, Object>(){
            {
                this.put("isEnabled", isEnabled);
                this.put("isBlocking", isBlocking);
                this.put("type", new LinkedHashMap<String, String>(){
                    {
                        this.put("id", id);
                    }
                });
                this.put("settings", settings);
            }
        };
        String r = RestClient.send(RequestMethod.PUT, this.CONNECTION, "fb13a388-40dd-4a04-b530-013a739c72ef", this.CONNECTION.getProject(), "policy/configurations", Integer.toString(configurationId), null, "7.1-preview.1", null, h, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, PolicyConfiguration.class);
    }

    @Override
    public PolicyType getPolicyType(String typeId) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "fb13a388-40dd-4a04-b530-013a739c72ef", this.CONNECTION.getProject(), "policy/types", typeId, null, "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, PolicyType.class);
    }

    @Override
    public PolicyTypes getPolicyTypes() throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "fb13a388-40dd-4a04-b530-013a739c72ef", this.CONNECTION.getProject(), "policy/types", null, null, "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, PolicyTypes.class);
    }
}

