/*
 * Decompiled with CFR 0.152.
 */
package org.azd.security;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.azd.connection.Connection;
import org.azd.enums.ApiExceptionTypes;
import org.azd.enums.CustomHeader;
import org.azd.enums.RequestMethod;
import org.azd.exceptions.AzDException;
import org.azd.helpers.JsonMapper;
import org.azd.helpers.URLHelper;
import org.azd.interfaces.SecurityDetails;
import org.azd.security.types.ACEs;
import org.azd.security.types.ACLs;
import org.azd.security.types.Identities;
import org.azd.security.types.SecurityNamespace;
import org.azd.security.types.SecurityNamespaces;
import org.azd.utils.AzDAsyncApi;
import org.azd.utils.RestClient;

public class SecurityApi
extends AzDAsyncApi<SecurityApi>
implements SecurityDetails {
    private final Connection CONNECTION;
    private final JsonMapper MAPPER = new JsonMapper();
    private final String SECURITY = "2e426be0-da4d-48c4-9178-978da8562255";
    private final String IDENTITY = "fc3682be-3d6c-427a-87c8-e527b16a1d05";
    private final String AREA_NAMESPACE = "securitynamespaces";
    private final String AREA_ACL = "accesscontrollists";
    private final String AREA_ACE = "accesscontrolentries";
    private final String AREA_IDENTITIES = "identities";

    public SecurityApi(Connection connection) {
        this.CONNECTION = connection;
    }

    @Override
    public SecurityNamespaces getNamespaces() throws AzDException {
        return this.getNamespaces(false);
    }

    @Override
    public SecurityNamespaces getNamespaces(final boolean localOnly) throws AzDException {
        LinkedHashMap<String, Object> q = new LinkedHashMap<String, Object>(){
            {
                this.put("localOnly", localOnly);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "2e426be0-da4d-48c4-9178-978da8562255", null, "securitynamespaces", null, null, "7.1-preview.1", q, null, null);
        return this.MAPPER.mapJsonResponse(r, SecurityNamespaces.class);
    }

    @Override
    public SecurityNamespace getNamespace(String namespaceId) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "2e426be0-da4d-48c4-9178-978da8562255", null, "securitynamespaces", namespaceId, null, "7.1-preview.1", null, null, null);
        SecurityNamespaces securityNamespaces = this.MAPPER.mapJsonResponse(r, SecurityNamespaces.class);
        return securityNamespaces.getSecurityNamespaces().get(0);
    }

    @Override
    public ACLs getAccessControlLists(String namespaceId) throws AzDException {
        return this.getAccessControlLists(namespaceId, null, null, false, false);
    }

    @Override
    public ACLs getAccessControlLists(String namespaceId, final String[] descriptors, final String token, final boolean includeExtendedInfo, final boolean recurse) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                if (descriptors != null && descriptors.length > 0) {
                    this.put("descriptors", Arrays.stream(descriptors).filter(x -> x != null && !x.isBlank()).map(URLHelper::encodeSpecialWithSpace).collect(Collectors.joining(",")));
                }
                if (token != null) {
                    this.put("token", URLHelper.encodeSpecialWithSpace(token));
                }
                this.put("includeExtendedInfo", includeExtendedInfo);
                this.put("recurse", recurse);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "2e426be0-da4d-48c4-9178-978da8562255", null, "accesscontrollists", namespaceId, null, "7.1-preview.1", q, null, null);
        return this.MAPPER.mapJsonResponse(r, ACLs.class);
    }

    @Override
    public Identities getIdentities(final String[] descriptors, final String[] identityIds, final String[] subjectDescriptors, final String filterValue, final String queryMembership, final String searchFilter) throws AzDException {
        LinkedHashMap<String, Object> q = new LinkedHashMap<String, Object>(){
            {
                if (descriptors != null && descriptors.length > 0) {
                    this.put("descriptors", Arrays.stream(descriptors).filter(x -> x != null && !x.isBlank()).map(URLHelper::encodeSpecialWithSpace).collect(Collectors.joining(",")));
                }
                if (identityIds != null && identityIds.length > 0) {
                    this.put("identityIds", Arrays.stream(identityIds).filter(x -> x != null && !x.isBlank()).map(URLHelper::encodeSpecialWithSpace).collect(Collectors.joining(",")));
                }
                if (subjectDescriptors != null && subjectDescriptors.length > 0) {
                    this.put("subjectDescriptors", Arrays.stream(subjectDescriptors).filter(x -> x != null && !x.isBlank()).map(URLHelper::encodeSpecialWithSpace).collect(Collectors.joining(",")));
                }
                if (filterValue != null) {
                    this.put("filterValue", URLHelper.encodeSpecialWithSpace(filterValue));
                }
                if (SecurityApi.this.validIdentityQueryMembership(queryMembership)) {
                    this.put("queryMembership", URLHelper.encodeSpecialWithSpace(queryMembership));
                }
                if (SecurityApi.this.validIdentitySearchFilter(searchFilter)) {
                    this.put("searchFilter", URLHelper.encodeSpecialWithSpace(searchFilter));
                }
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "fc3682be-3d6c-427a-87c8-e527b16a1d05", null, "identities", null, null, "7.1-preview.1", q, null, null);
        return this.MAPPER.mapJsonResponse(r, Identities.class);
    }

    @Override
    public Identities getIdentitiesFromSubjectDescriptors(String ... subjectDescriptors) throws AzDException {
        return this.getIdentities(null, null, subjectDescriptors, null, null, null);
    }

    @Override
    public ACEs setAccessControlEntries(String namespaceId, ACEs payload) throws AzDException {
        String r = RestClient.send(RequestMethod.POST, this.CONNECTION, "2e426be0-da4d-48c4-9178-978da8562255", null, "accesscontrolentries", namespaceId, null, "7.1-preview.1", null, payload, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, ACEs.class);
    }

    @Override
    public Void removeAccessControlEntries(String namespaceId, final String[] descriptors, final String[] tokens) throws AzDException {
        if (tokens == null || tokens.length == 0) {
            throw new AzDException(ApiExceptionTypes.InvalidArgumentException.name(), "Tokens list must not be empty.");
        }
        if (tokens == null || tokens.length == 0) {
            throw new AzDException(ApiExceptionTypes.InvalidArgumentException.name(), "Descriptors list must not be empty.");
        }
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("tokens", Arrays.stream(tokens).filter(x -> x != null && !x.isBlank()).map(URLHelper::encodeSpecialWithSpace).collect(Collectors.joining(",")));
                this.put("descriptors", Arrays.stream(descriptors).filter(x -> x != null && !x.isBlank()).map(URLHelper::encodeSpecialWithSpace).collect(Collectors.joining(",")));
            }
        };
        String r = RestClient.send(RequestMethod.DELETE, this.CONNECTION, "2e426be0-da4d-48c4-9178-978da8562255", null, "accesscontrolentries", namespaceId, null, "7.1-preview.1", q, null, null);
        return null;
    }

    @Override
    public Void setAccessControlList(String namespaceId, ACLs payload) throws AzDException {
        String r = RestClient.send(RequestMethod.POST, this.CONNECTION, "2e426be0-da4d-48c4-9178-978da8562255", null, "accesscontrollists", namespaceId, null, "7.1-preview.1", null, payload, CustomHeader.JSON_CONTENT_TYPE);
        return null;
    }

    @Override
    public Void removeAccessControlLists(String namespaceId, final boolean recurse, final String[] tokens) throws AzDException {
        if (tokens == null || tokens.length == 0) {
            throw new AzDException(ApiExceptionTypes.InvalidArgumentException.name(), "Tokens list must not be empty.");
        }
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("tokens", Arrays.stream(tokens).filter(x -> x != null && !x.isBlank()).map(URLHelper::encodeSpecialWithSpace).collect(Collectors.joining(",")));
                this.put("recurse", recurse);
            }
        };
        String r = RestClient.send(RequestMethod.DELETE, this.CONNECTION, "2e426be0-da4d-48c4-9178-978da8562255", null, "accesscontrollists", namespaceId, null, "7.1-preview.1", q, null, null);
        return null;
    }

    private boolean validIdentityQueryMembership(String queryMembership) {
        return queryMembership != null && List.of("none", "direct").contains(queryMembership.toLowerCase());
    }

    private boolean validIdentitySearchFilter(String searchFilter) {
        return searchFilter != null && List.of("accountname", "displayname", "mailaddress", "general", "localgroupname").contains(searchFilter.toLowerCase());
    }
}

