/*
 * Decompiled with CFR 0.152.
 */
package org.azd.servicehooks;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.azd.connection.Connection;
import org.azd.enums.CustomHeader;
import org.azd.enums.RequestMethod;
import org.azd.exceptions.AzDException;
import org.azd.helpers.JsonMapper;
import org.azd.interfaces.ServiceHooksDetails;
import org.azd.servicehooks.types.ServiceHooks;
import org.azd.servicehooks.types.ServiceHooksSubscription;
import org.azd.servicehooks.types.ServiceHooksSubscriptions;
import org.azd.utils.AzDAsyncApi;
import org.azd.utils.RestClient;

public class ServiceHooksApi
extends AzDAsyncApi<ServiceHooksApi>
implements ServiceHooksDetails {
    private final Connection CONNECTION;
    private final JsonMapper MAPPER = new JsonMapper();
    private final String AREA = "hooks";

    public ServiceHooksApi(Connection connection) {
        this.CONNECTION = connection;
    }

    @Override
    public ServiceHooksSubscription getSubscription(String subscriptionId) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, null, null, "hooks/subscriptions", subscriptionId, null, "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, ServiceHooksSubscription.class);
    }

    @Override
    public ServiceHooksSubscriptions getSubscriptions() throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, null, null, "hooks/subscriptions", null, null, "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, ServiceHooksSubscriptions.class);
    }

    @Override
    public ServiceHooksSubscriptions getSubscriptions(final String consumerActionId, final String consumerId, final String eventType, final String publisherId) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("publisherId", publisherId);
                this.put("eventType", eventType);
                this.put("consumerId", consumerId);
                this.put("consumerActionId", consumerActionId);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, null, null, "hooks/subscriptions", null, null, "7.1-preview.1", q, null, null);
        return this.MAPPER.mapJsonResponse(r, ServiceHooksSubscriptions.class);
    }

    @Override
    public Void deleteSubscription(String subscriptionId) throws AzDException {
        String r = RestClient.send(RequestMethod.DELETE, this.CONNECTION, null, null, "hooks/subscriptions", subscriptionId, null, "7.1-preview.1", null, null, null);
        if (!r.isEmpty()) {
            this.MAPPER.mapJsonResponse(r, Map.class);
        }
        return null;
    }

    @Override
    public ServiceHooksSubscription createSubscription(final ServiceHooks serviceHooks) throws AzDException {
        LinkedHashMap<String, Object> requestBody = new LinkedHashMap<String, Object>(){
            {
                this.put("publisherId", serviceHooks.getPublisherId());
                this.put("eventType", serviceHooks.getEventType());
                this.put("resourceVersion", serviceHooks.getResourceVersion());
                this.put("consumerId", serviceHooks.getConsumerId());
                this.put("consumerActionId", serviceHooks.getConsumerActionId());
                this.put("publisherInputs", serviceHooks.getPublisherInputs());
                this.put("consumerInputs", serviceHooks.getConsumerInputs());
            }
        };
        String r = RestClient.send(RequestMethod.POST, this.CONNECTION, null, null, "hooks/subscriptions", null, null, "7.1-preview.1", null, requestBody, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, ServiceHooksSubscription.class);
    }
}

