/*
 * Decompiled with CFR 0.152.
 */
package org.azd.test;

import java.util.HashMap;
import java.util.Map;
import org.azd.connection.Connection;
import org.azd.enums.CustomHeader;
import org.azd.enums.RequestMethod;
import org.azd.enums.TestRunPublishContext;
import org.azd.enums.TestRunState;
import org.azd.exceptions.AzDException;
import org.azd.helpers.JsonMapper;
import org.azd.interfaces.TestDetails;
import org.azd.test.types.RunCreateModel;
import org.azd.test.types.TestRun;
import org.azd.test.types.TestRunStatistic;
import org.azd.test.types.TestRuns;
import org.azd.utils.RestClient;

public class TestApi
implements TestDetails {
    private final Connection CONNECTION;
    private final JsonMapper MAPPER = new JsonMapper();
    private final String AREA = "test";

    public TestApi(Connection connection) {
        this.CONNECTION = connection;
    }

    @Override
    public TestRun createTestRun(RunCreateModel runCreateModel) throws AzDException {
        String r = RestClient.send(RequestMethod.POST, this.CONNECTION, "3b95fb80-fdda-4218-b60e-1052d070ae6b", this.CONNECTION.getProject(), "test/runs", null, null, "7.1-preview.3", null, runCreateModel, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, TestRun.class);
    }

    @Override
    public TestRun getTestRunById(int runId) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "3b95fb80-fdda-4218-b60e-1052d070ae6b", this.CONNECTION.getProject(), "test/runs", String.valueOf(runId), null, "7.1-preview.3", null, null, null);
        return this.MAPPER.mapJsonResponse(r, TestRun.class);
    }

    @Override
    public TestRuns getTestRuns() throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "3b95fb80-fdda-4218-b60e-1052d070ae6b", this.CONNECTION.getProject(), "test/runs", null, null, "7.1-preview.3", null, null, null);
        return this.MAPPER.mapJsonResponse(r, TestRuns.class);
    }

    @Override
    public TestRuns getTestRuns(int top) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "3b95fb80-fdda-4218-b60e-1052d070ae6b", this.CONNECTION.getProject(), "test/runs", null, null, "7.1-preview.3", Map.of("$top", top), null, null);
        return this.MAPPER.mapJsonResponse(r, TestRuns.class);
    }

    @Override
    public TestRuns getTestRuns(String buildUri) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "3b95fb80-fdda-4218-b60e-1052d070ae6b", this.CONNECTION.getProject(), "test/runs", null, null, "7.1-preview.3", Map.of("buildUri", buildUri), null, null);
        return this.MAPPER.mapJsonResponse(r, TestRuns.class);
    }

    @Override
    public TestRuns getTestRuns(final int skip, final int top, final boolean automated, final String buildUri, final boolean includeRunDetails, final String owner, final int planId, final String tmiRunId) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("$skip", skip);
                this.put("$top", top);
                this.put("automated", automated);
                this.put("buildUri", buildUri);
                this.put("includeRunDetails", includeRunDetails);
                this.put("owner", owner);
                this.put("planId", planId);
                this.put("tmiRunId", tmiRunId);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "3b95fb80-fdda-4218-b60e-1052d070ae6b", this.CONNECTION.getProject(), "test/runs", null, null, "7.1-preview.3", q, null, null);
        return this.MAPPER.mapJsonResponse(r, TestRuns.class);
    }

    @Override
    public TestRunStatistic getTestRunStatistics(int runId) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "3b95fb80-fdda-4218-b60e-1052d070ae6b", this.CONNECTION.getProject(), "test/runs", Integer.toString(runId), "Statistics", "7.1-preview.3", null, null, null);
        return this.MAPPER.mapJsonResponse(r, TestRunStatistic.class);
    }

    @Override
    public Void deleteTestRun(int runId) throws AzDException {
        String r = RestClient.send(RequestMethod.DELETE, this.CONNECTION, "3b95fb80-fdda-4218-b60e-1052d070ae6b", this.CONNECTION.getProject(), "test/runs", Integer.toString(runId), null, "7.1-preview.3", null, null, null);
        if (!r.isEmpty()) {
            this.MAPPER.mapJsonResponse(r, Map.class);
        }
        return null;
    }

    @Override
    public TestRuns queryTestRuns(final String maxLastUpdatedDate, final String minLastUpdatedDate) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("maxLastUpdatedDate", maxLastUpdatedDate);
                this.put("minLastUpdatedDate", minLastUpdatedDate);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "3b95fb80-fdda-4218-b60e-1052d070ae6b", this.CONNECTION.getProject(), "test/runs", null, null, "7.1-preview.3", q, null, null);
        return this.MAPPER.mapJsonResponse(r, TestRuns.class);
    }

    @Override
    public TestRuns queryTestRuns(final String maxLastUpdatedDate, final String minLastUpdatedDate, final int top) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("maxLastUpdatedDate", maxLastUpdatedDate);
                this.put("minLastUpdatedDate", minLastUpdatedDate);
                this.put("$top", top);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "3b95fb80-fdda-4218-b60e-1052d070ae6b", this.CONNECTION.getProject(), "test/runs", null, null, "7.1-preview.3", q, null, null);
        return this.MAPPER.mapJsonResponse(r, TestRuns.class);
    }

    @Override
    public TestRuns queryTestRuns(final String maxLastUpdatedDate, final String minLastUpdatedDate, String[] buildIds) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("maxLastUpdatedDate", maxLastUpdatedDate);
                this.put("minLastUpdatedDate", minLastUpdatedDate);
            }
        };
        if (buildIds.length > 0) {
            q.put("buildIds", String.join((CharSequence)",", buildIds));
        }
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "3b95fb80-fdda-4218-b60e-1052d070ae6b", this.CONNECTION.getProject(), "test/runs", null, null, "7.1-preview.3", q, null, null);
        return this.MAPPER.mapJsonResponse(r, TestRuns.class);
    }

    @Override
    public TestRuns queryTestRuns(final String maxLastUpdatedDate, final String minLastUpdatedDate, final TestRunState testRunState) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("maxLastUpdatedDate", maxLastUpdatedDate);
                this.put("minLastUpdatedDate", minLastUpdatedDate);
                this.put("state", testRunState);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "3b95fb80-fdda-4218-b60e-1052d070ae6b", this.CONNECTION.getProject(), "test/runs", null, null, "7.1-preview.3", q, null, null);
        return this.MAPPER.mapJsonResponse(r, TestRuns.class);
    }

    @Override
    public TestRuns queryTestRuns(final String maxLastUpdatedDate, final String minLastUpdatedDate, String branchName, String[] buildDefIds, String continuationToken, final boolean isAutomated, String[] planIds, final TestRunPublishContext publishContext, String[] releaseDefIds, String[] releaseEnvDefIds, String[] releaseEnvIds, String[] releaseIds, String runTitle) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("maxLastUpdatedDate", maxLastUpdatedDate);
                this.put("minLastUpdatedDate", minLastUpdatedDate);
                this.put("isAutomated", isAutomated);
                this.put("publishContext", publishContext);
            }
        };
        if (branchName != null) {
            q.put("branchName", branchName);
        }
        if (buildDefIds.length > 0) {
            q.put("buildDefIds", buildDefIds);
        }
        if (continuationToken != null) {
            q.put("continuationToken", continuationToken);
        }
        if (planIds.length > 0) {
            q.put("branchName", branchName);
        }
        if (releaseEnvDefIds.length > 0) {
            q.put("releaseEnvDefIds", String.join((CharSequence)",", releaseEnvDefIds));
        }
        if (releaseEnvIds.length > 0) {
            q.put("releaseEnvIds", String.join((CharSequence)",", releaseEnvIds));
        }
        if (releaseDefIds.length > 0) {
            q.put("releaseDefIds", releaseDefIds);
        }
        if (releaseIds.length > 0) {
            q.put("releaseIds", releaseIds);
        }
        if (runTitle != null) {
            q.put("runTitle", runTitle);
        }
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "3b95fb80-fdda-4218-b60e-1052d070ae6b", this.CONNECTION.getProject(), "test/runs", null, null, "7.1-preview.3", q, null, null);
        return this.MAPPER.mapJsonResponse(r, TestRuns.class);
    }

    @Override
    public TestRun updateTestRun(int runId, TestRun testRun) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "3b95fb80-fdda-4218-b60e-1052d070ae6b", this.CONNECTION.getProject(), "test/runs", String.valueOf(runId), null, "7.1-preview.3", null, testRun, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, TestRun.class);
    }
}

