/*
 * Decompiled with CFR 0.152.
 */
package org.azd.upack;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.azd.connection.Connection;
import org.azd.enums.CustomHeader;
import org.azd.enums.PackageOperation;
import org.azd.enums.PackagePromote;
import org.azd.enums.PackagesBatchOperation;
import org.azd.enums.RequestMethod;
import org.azd.exceptions.AzDException;
import org.azd.helpers.JsonMapper;
import org.azd.interfaces.UpackDetails;
import org.azd.upack.types.Package;
import org.azd.upack.types.UPackPackageVersionDeletionState;
import org.azd.utils.AzDAsyncApi;
import org.azd.utils.RestClient;

public class UPackApi
extends AzDAsyncApi<UPackApi>
implements UpackDetails {
    private final Connection CONNECTION;
    private final JsonMapper MAPPER = new JsonMapper();
    private final String AREA = "packaging";
    private final String UPACK = "d397749b-f115-4027-b6dd-77a65dd10d21";

    public UPackApi(Connection connection) {
        this.CONNECTION = connection;
    }

    @Override
    public Package getPackageVersion(String feedId, String packageName, String version) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "d397749b-f115-4027-b6dd-77a65dd10d21", this.CONNECTION.getProject(), "packaging/feeds", feedId, "upack/packages/" + packageName + "/versions/" + version, "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, Package.class);
    }

    @Override
    public Package getPackageVersion(String feedId, String packageName, String version, final boolean showDeleted) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("showDeleted", showDeleted);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "d397749b-f115-4027-b6dd-77a65dd10d21", this.CONNECTION.getProject(), "packaging/feeds", feedId, "upack/packages/" + packageName + "/versions/" + version, "7.1-preview.1", q, null, null);
        return this.MAPPER.mapJsonResponse(r, Package.class);
    }

    @Override
    public UPackPackageVersionDeletionState getPackageVersionFromRecycleBin(String feedId, String packageName, String version) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "d397749b-f115-4027-b6dd-77a65dd10d21", this.CONNECTION.getProject(), "packaging/feeds", feedId, "upack/RecycleBin/packages/" + packageName + "/versions/" + version, "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, UPackPackageVersionDeletionState.class);
    }

    @Override
    public void deletePackageVersion(String feedId, String packageName, String version) throws AzDException {
        String r = RestClient.send(RequestMethod.DELETE, this.CONNECTION, "d397749b-f115-4027-b6dd-77a65dd10d21", this.CONNECTION.getProject(), "packaging/feeds", feedId, "upack/packages/" + packageName + "/versions/" + version, "7.1-preview.1", null, null, null);
        if (!r.isEmpty()) {
            this.MAPPER.mapJsonResponse(r, Map.class);
        }
    }

    @Override
    public void deletePackageVersionFromRecycleBin(String feedId, String packageName, String version) throws AzDException {
        String r = RestClient.send(RequestMethod.DELETE, this.CONNECTION, "d397749b-f115-4027-b6dd-77a65dd10d21", this.CONNECTION.getProject(), "packaging/feeds", feedId, "upack/RecycleBin/packages/" + packageName + "/versions/" + version, "7.1-preview.1", null, null, null);
        if (!r.isEmpty()) {
            this.MAPPER.mapJsonResponse(r, Map.class);
        }
    }

    @Override
    public void updatePackageVersion(String feedId, String packageName, String version, PackagePromote promote) throws AzDException {
        this.updatePackageVersion(feedId, packageName, version, promote.toString().toLowerCase());
    }

    @Override
    public void updatePackageVersion(String feedId, String packageName, String version, final String promote) throws AzDException {
        HashMap<String, Object> req = new HashMap<String, Object>(){
            {
                this.put("op", PackageOperation.ADD.toString());
                this.put("path", "/views/-");
                this.put("value", promote.toString());
            }
        };
        HashMap<String, Object> body = new HashMap<String, Object>(req){
            final /* synthetic */ 2 val$req;
            {
                this.val$req = var2_2;
                this.put("views", this.val$req);
            }
        };
        String r = RestClient.send(RequestMethod.PATCH, this.CONNECTION, "d397749b-f115-4027-b6dd-77a65dd10d21", this.CONNECTION.getProject(), "packaging/feeds", feedId, "upack/packages/" + packageName + "/versions/" + version, "7.1-preview.1", null, body, CustomHeader.JSON_CONTENT_TYPE);
        if (!r.isEmpty()) {
            this.MAPPER.mapJsonResponse(r, Map.class);
        }
    }

    @Override
    public void updatePackageVersions(String feedId, String viewId, PackagesBatchOperation operation, List<Map<String, Object>> packages) throws AzDException {
        HashMap<String, Object> req = new HashMap<String, Object>();
        if (operation == PackagesBatchOperation.PROMOTE) {
            req.put("data", Map.of("viewId", viewId));
        }
        req.put("operation", operation.toString().toLowerCase());
        ArrayList<Map<String, Object>> l = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> pkg : packages) {
            l.add(Map.of("id", pkg.get("id"), "version", pkg.get("version")));
        }
        req.put("packages", l);
        String r = RestClient.send(RequestMethod.POST, this.CONNECTION, "d397749b-f115-4027-b6dd-77a65dd10d21", this.CONNECTION.getProject(), "packaging/feeds", feedId, "upack/packagesbatch", "7.1-preview.1", null, req, CustomHeader.JSON_CONTENT_TYPE);
        if (!r.isEmpty()) {
            this.MAPPER.mapJsonResponse(r, Map.class);
        }
    }

    @Override
    public void restorePackageVersionFromRecycleBin(String feedId, String packageName, String version) throws AzDException {
        String r = RestClient.send(RequestMethod.PATCH, this.CONNECTION, "d397749b-f115-4027-b6dd-77a65dd10d21", this.CONNECTION.getProject(), "packaging/feeds", feedId, "upack/RecycleBin/packages/" + packageName + "/versions/" + version, "7.1-preview.1", null, Map.of("deleted", "false"), null);
        if (!r.isEmpty()) {
            this.MAPPER.mapJsonResponse(r, Map.class);
        }
    }

    @Override
    public void updateRecycleBinPackages(String feedId, PackagesBatchOperation operation, List<Map<String, Object>> packages) throws AzDException {
        HashMap<String, Object> req = new HashMap<String, Object>();
        req.put("data", null);
        req.put("operation", operation.toString().toLowerCase());
        ArrayList<Map<String, Object>> l = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> pkg : packages) {
            l.add(Map.of("id", pkg.get("id"), "version", pkg.get("version")));
        }
        req.put("packages", l);
        String r = RestClient.send(RequestMethod.POST, this.CONNECTION, "d397749b-f115-4027-b6dd-77a65dd10d21", this.CONNECTION.getProject(), "packaging/feeds", feedId, "upack/RecycleBin/packagesbatch", "7.1-preview.1", null, req, CustomHeader.JSON_CONTENT_TYPE);
        if (!r.isEmpty()) {
            this.MAPPER.mapJsonResponse(r, Map.class);
        }
    }
}

