/*
 * Decompiled with CFR 0.152.
 */
package org.azd.work;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.azd.connection.Connection;
import org.azd.enums.CustomHeader;
import org.azd.enums.IterationsTimeFrame;
import org.azd.enums.RequestMethod;
import org.azd.exceptions.AzDException;
import org.azd.helpers.JsonMapper;
import org.azd.helpers.URLHelper;
import org.azd.interfaces.WorkDetails;
import org.azd.utils.AzDAsyncApi;
import org.azd.utils.RestClient;
import org.azd.work.types.IterationWorkItems;
import org.azd.work.types.TeamCapacity;
import org.azd.work.types.TeamMemberCapacityIdentityRef;
import org.azd.work.types.TeamMemberCapacityIdentityRefs;
import org.azd.work.types.TeamSettingsIteration;
import org.azd.work.types.TeamSettingsIterations;

public class WorkApi
extends AzDAsyncApi<WorkApi>
implements WorkDetails {
    private final Connection CONNECTION;
    private final JsonMapper MAPPER = new JsonMapper();
    private final String AREA = "work";
    private final String WORK = "1d4f49f9-02b9-4e26-b826-2cdb6195f2a9";

    public WorkApi(Connection connection) {
        this.CONNECTION = connection;
    }

    @Override
    public TeamSettingsIterations getTeamSettingsIterations(String teamName) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "1d4f49f9-02b9-4e26-b826-2cdb6195f2a9", this.CONNECTION.getProject() + "/" + URLHelper.encodeSpace(teamName), "work", null, "teamsettings/iterations", "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, TeamSettingsIterations.class);
    }

    @Override
    public TeamSettingsIterations getTeamSettingsIterations(String teamName, final IterationsTimeFrame timeFrame) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("$timeframe", timeFrame.toString().toLowerCase());
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "1d4f49f9-02b9-4e26-b826-2cdb6195f2a9", this.CONNECTION.getProject() + "/" + URLHelper.encodeSpace(teamName), "work", null, "teamsettings/iterations", "7.1-preview.1", q, null, null);
        return this.MAPPER.mapJsonResponse(r, TeamSettingsIterations.class);
    }

    @Override
    public IterationWorkItems getTeamIterationWorkItems(String teamName, String iterationId) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "1d4f49f9-02b9-4e26-b826-2cdb6195f2a9", this.CONNECTION.getProject() + "/" + URLHelper.encodeSpace(teamName), "work/teamsettings/iterations", iterationId, "workitems", "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, IterationWorkItems.class);
    }

    @Override
    public TeamSettingsIteration getTeamSettingsIteration(String teamName, String iterationId) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "1d4f49f9-02b9-4e26-b826-2cdb6195f2a9", this.CONNECTION.getProject() + "/" + URLHelper.encodeSpace(teamName), "work/teamsettings/iterations", iterationId, null, "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, TeamSettingsIteration.class);
    }

    @Override
    public Void deleteTeamSettingsIteration(String teamName, String iterationId) throws AzDException {
        String r = RestClient.send(RequestMethod.DELETE, this.CONNECTION, "1d4f49f9-02b9-4e26-b826-2cdb6195f2a9", this.CONNECTION.getProject() + "/" + URLHelper.encodeSpace(teamName), "work/teamsettings/iterations", iterationId, null, "7.1-preview.1", null, null, null);
        if (!r.isEmpty()) {
            this.MAPPER.mapJsonResponse(r, Map.class);
        }
        return null;
    }

    @Override
    public TeamCapacity getTotalTeamCapacity(String iterationId, String teamName) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "1d4f49f9-02b9-4e26-b826-2cdb6195f2a9", this.CONNECTION.getProject() + "/" + URLHelper.encodeSpecialWithSpace(teamName), "work/teamsettings/iterations", iterationId, "capacities", "7.1-preview.3", null, null, null);
        return this.MAPPER.mapJsonResponse(r, TeamCapacity.class);
    }

    @Override
    public TeamMemberCapacityIdentityRef getTeamMemberCapacity(String iterationId, String teamName, String teamMemberId) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "1d4f49f9-02b9-4e26-b826-2cdb6195f2a9", this.CONNECTION.getProject() + "/" + URLHelper.encodeSpecialWithSpace(teamName), "work/teamsettings/iterations", iterationId, "capacities/" + teamMemberId, "7.1-preview.3", null, null, null);
        return this.MAPPER.mapJsonResponse(r, TeamMemberCapacityIdentityRef.class);
    }

    @Override
    public TeamMemberCapacityIdentityRefs updateTeamMembersCapacity(String iterationId, String teamName, List<TeamMemberCapacityIdentityRef> teamMembersCapacity) throws AzDException {
        String r = RestClient.send(RequestMethod.PUT, this.CONNECTION, "1d4f49f9-02b9-4e26-b826-2cdb6195f2a9", this.CONNECTION.getProject() + "/" + URLHelper.encodeSpecialWithSpace(teamName), "work/teamsettings/iterations", iterationId, "capacities", "7.1-preview.3", null, teamMembersCapacity, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, TeamMemberCapacityIdentityRefs.class);
    }

    @Override
    public TeamMemberCapacityIdentityRef updateTeamMemberCapacity(String iterationId, String teamName, String teamMemberId, final TeamMemberCapacityIdentityRef teamMemberCapacity) throws AzDException {
        HashMap<String, Object> body = new HashMap<String, Object>(){
            {
                this.put("activities", teamMemberCapacity.getActivities());
                this.put("daysOff", teamMemberCapacity.getDaysOff());
            }
        };
        String r = RestClient.send(RequestMethod.PATCH, this.CONNECTION, "1d4f49f9-02b9-4e26-b826-2cdb6195f2a9", this.CONNECTION.getProject() + "/" + URLHelper.encodeSpecialWithSpace(teamName), "work/teamsettings/iterations", iterationId, "capacities/" + teamMemberId, "7.1-preview.3", null, body, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, TeamMemberCapacityIdentityRef.class);
    }
}

