/*
 * Decompiled with CFR 0.152.
 */
package org.azd.workitemtracking;

import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.azd.connection.Connection;
import org.azd.enums.ApiExceptionTypes;
import org.azd.enums.AttachmentUploadType;
import org.azd.enums.CustomHeader;
import org.azd.enums.GetFieldsExpand;
import org.azd.enums.QueryErrorPolicy;
import org.azd.enums.QueryExpand;
import org.azd.enums.RequestMethod;
import org.azd.enums.WorkItemErrorPolicy;
import org.azd.enums.WorkItemExpand;
import org.azd.enums.WorkItemOperation;
import org.azd.exceptions.AzDException;
import org.azd.helpers.JsonMapper;
import org.azd.helpers.StreamHelper;
import org.azd.helpers.URLHelper;
import org.azd.interfaces.WorkItemTrackingDetails;
import org.azd.utils.AzDAsyncApi;
import org.azd.utils.ModelBuilder;
import org.azd.utils.RestClient;
import org.azd.workitemtracking.types.AccountRecentActivityWorkItems;
import org.azd.workitemtracking.types.AttachmentReference;
import org.azd.workitemtracking.types.ProcessIdModel;
import org.azd.workitemtracking.types.ProcessMigrationResultModel;
import org.azd.workitemtracking.types.QueryHierarchyItem;
import org.azd.workitemtracking.types.QueryHierarchyItems;
import org.azd.workitemtracking.types.QueryHierarchyItemsResult;
import org.azd.workitemtracking.types.UpdateWorkItemField;
import org.azd.workitemtracking.types.WorkItem;
import org.azd.workitemtracking.types.WorkItemDelete;
import org.azd.workitemtracking.types.WorkItemDeleteReference;
import org.azd.workitemtracking.types.WorkItemDeleteReferences;
import org.azd.workitemtracking.types.WorkItemDeleteShallowReferences;
import org.azd.workitemtracking.types.WorkItemField;
import org.azd.workitemtracking.types.WorkItemFieldTypes;
import org.azd.workitemtracking.types.WorkItemList;
import org.azd.workitemtracking.types.WorkItemQueryResult;
import org.azd.workitemtracking.types.WorkItemRelations;
import org.azd.workitemtracking.types.WorkItemType;
import org.azd.workitemtracking.types.WorkItemTypes;

public class WorkItemTrackingApi
extends AzDAsyncApi<WorkItemTrackingApi>
implements WorkItemTrackingDetails {
    private final Connection CONNECTION;
    private final JsonMapper MAPPER = new JsonMapper();
    private final String AREA = "wit";
    private final String WIT = "5264459e-e5e0-4bd8-b118-0985e68a4ec5";

    public WorkItemTrackingApi(Connection connection) {
        this.CONNECTION = connection;
    }

    @Override
    public WorkItem createWorkItem(String workItemType, final WorkItemOperation operation, final String title) throws AzDException {
        HashMap<String, Object> req = new HashMap<String, Object>(){
            {
                this.put("op", operation.toString().toLowerCase());
                this.put("path", "/fields/System.Title");
                this.put("from", null);
                this.put("value", title);
            }
        };
        String r = RestClient.send(RequestMethod.POST, this.CONNECTION, "5264459e-e5e0-4bd8-b118-0985e68a4ec5", this.CONNECTION.getProject(), "wit/workitems", null, "$" + URLHelper.encodeSpace(workItemType), "7.1-preview.3", null, List.of(req), CustomHeader.JSON_PATCH);
        return this.MAPPER.mapJsonResponse(r, WorkItem.class);
    }

    @Override
    public WorkItem createWorkItem(String workItemType, final WorkItemOperation operation, final String title, final String description, final String[] tags) throws AzDException {
        HashMap<String, Object> t = new HashMap<String, Object>(){
            {
                this.put("op", operation.toString().toLowerCase());
                this.put("path", "/fields/System.Title");
                this.put("from", null);
                this.put("value", title);
            }
        };
        HashMap<String, Object> d = new HashMap<String, Object>(){
            {
                this.put("op", operation.toString().toLowerCase());
                this.put("path", "/fields/System.Description");
                this.put("from", null);
                this.put("value", description);
            }
        };
        HashMap<String, Object> tt = new HashMap<String, Object>(){
            {
                this.put("op", operation.toString().toLowerCase());
                this.put("path", "/fields/System.Tags");
                this.put("from", null);
                this.put("value", String.join((CharSequence)",", tags));
            }
        };
        ArrayList<HashMap> req = new ArrayList<HashMap>();
        req.add(t);
        req.add(d);
        req.add(tt);
        String r = RestClient.send(RequestMethod.POST, this.CONNECTION, "5264459e-e5e0-4bd8-b118-0985e68a4ec5", this.CONNECTION.getProject(), "wit/workitems", null, "$" + URLHelper.encodeSpace(workItemType), "7.1-preview.3", null, req, CustomHeader.JSON_PATCH);
        return this.MAPPER.mapJsonResponse(r, WorkItem.class);
    }

    @Override
    public WorkItem createWorkItem(String workItemType, final String title, final String description, final Map<String, Object> additionalFields) throws AzDException {
        ArrayList<HashMap> req = new ArrayList<HashMap>();
        HashMap<String, Object> t = new HashMap<String, Object>(){
            {
                this.put("op", "add");
                this.put("path", "/fields/System.Title");
                this.put("from", null);
                this.put("value", title);
            }
        };
        HashMap<String, Object> d = new HashMap<String, Object>(){
            {
                this.put("op", "add");
                this.put("path", "/fields/System.Description");
                this.put("from", null);
                this.put("value", description);
            }
        };
        req.add(t);
        req.add(d);
        for (final String key : additionalFields.keySet()) {
            HashMap<String, Object> i = new HashMap<String, Object>(){
                {
                    this.put("op", "add");
                    this.put("path", "/fields/" + key);
                    this.put("from", null);
                    this.put("value", additionalFields.get(key));
                }
            };
            req.add(i);
        }
        String r = RestClient.send(RequestMethod.POST, this.CONNECTION, "5264459e-e5e0-4bd8-b118-0985e68a4ec5", this.CONNECTION.getProject(), "wit/workitems", null, "$" + URLHelper.encodeSpace(workItemType), "7.1-preview.3", null, req, CustomHeader.JSON_PATCH);
        return this.MAPPER.mapJsonResponse(r, WorkItem.class);
    }

    @Override
    public WorkItemDelete deleteWorkItem(int id) throws AzDException {
        String r = RestClient.send(RequestMethod.DELETE, this.CONNECTION, "5264459e-e5e0-4bd8-b118-0985e68a4ec5", this.CONNECTION.getProject(), "wit/workitems", String.valueOf(id), null, "7.1-preview.3", null, null, null);
        return this.MAPPER.mapJsonResponse(r, WorkItemDelete.class);
    }

    @Override
    public Void deleteWorkItem(int id, final boolean destroy) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("destroy", destroy);
            }
        };
        String r = RestClient.send(RequestMethod.DELETE, this.CONNECTION, "5264459e-e5e0-4bd8-b118-0985e68a4ec5", this.CONNECTION.getProject(), "wit/workitems", String.valueOf(id), null, "7.1-preview.3", q, null, null);
        if (!r.isEmpty()) {
            this.MAPPER.mapJsonResponse(r, Map.class);
        }
        return null;
    }

    @Override
    public WorkItem getWorkItem(int id) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5264459e-e5e0-4bd8-b118-0985e68a4ec5", this.CONNECTION.getProject(), "wit/workitems", Integer.toString(id), null, "7.1-preview.3", null, null, null);
        return this.MAPPER.mapJsonResponse(r, WorkItem.class);
    }

    @Override
    public WorkItem getWorkItem(int id, final WorkItemExpand expand) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("$expand", expand.toString().toLowerCase());
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5264459e-e5e0-4bd8-b118-0985e68a4ec5", this.CONNECTION.getProject(), "wit/workitems", Integer.toString(id), null, "7.1-preview.3", q, null, null);
        return this.MAPPER.mapJsonResponse(r, WorkItem.class);
    }

    @Override
    public WorkItem getWorkItem(int id, final WorkItemExpand expand, final String asOf) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("asOf", asOf);
                this.put("$expand", expand.toString().toLowerCase());
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5264459e-e5e0-4bd8-b118-0985e68a4ec5", this.CONNECTION.getProject(), "wit/workitems", Integer.toString(id), null, "7.1-preview.3", q, null, null);
        return this.MAPPER.mapJsonResponse(r, WorkItem.class);
    }

    @Override
    public WorkItem getWorkItem(int id, final WorkItemExpand expand, final String[] fields) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("fields", String.join((CharSequence)",", fields));
                this.put("$expand", expand.toString().toLowerCase());
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5264459e-e5e0-4bd8-b118-0985e68a4ec5", this.CONNECTION.getProject(), "wit/workitems", Integer.toString(id), null, "7.1-preview.3", q, null, null);
        return this.MAPPER.mapJsonResponse(r, WorkItem.class);
    }

    @Override
    public WorkItem getWorkItem(int id, final WorkItemExpand expand, final String[] fields, final String asOf) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("fields", String.join((CharSequence)",", fields));
                this.put("asOf", asOf);
                this.put("$expand", expand.toString().toLowerCase());
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5264459e-e5e0-4bd8-b118-0985e68a4ec5", this.CONNECTION.getProject(), "wit/workitems", Integer.toString(id), null, "7.1-preview.3", q, null, null);
        return this.MAPPER.mapJsonResponse(r, WorkItem.class);
    }

    @Override
    public WorkItemList getWorkItems(final int[] ids) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("ids", WorkItemTrackingApi.this.intArrayToString(ids));
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5264459e-e5e0-4bd8-b118-0985e68a4ec5", this.CONNECTION.getProject(), "wit/workitems", null, null, "7.1-preview.3", q, null, null);
        return this.MAPPER.mapJsonResponse(r, WorkItemList.class);
    }

    @Override
    public WorkItemList getWorkItems(final int[] ids, final WorkItemExpand expand) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("ids", WorkItemTrackingApi.this.intArrayToString(ids));
                this.put("$expand", expand.toString().toLowerCase());
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5264459e-e5e0-4bd8-b118-0985e68a4ec5", this.CONNECTION.getProject(), "wit/workitems", null, null, "7.1-preview.3", q, null, null);
        return this.MAPPER.mapJsonResponse(r, WorkItemList.class);
    }

    @Override
    public WorkItemList getWorkItems(final int[] ids, final WorkItemExpand expand, final String asOf) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("ids", WorkItemTrackingApi.this.intArrayToString(ids));
                this.put("$expand", expand.toString().toLowerCase());
                this.put("fields", asOf);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5264459e-e5e0-4bd8-b118-0985e68a4ec5", this.CONNECTION.getProject(), "wit/workitems", null, null, "7.1-preview.3", q, null, null);
        return this.MAPPER.mapJsonResponse(r, WorkItemList.class);
    }

    @Override
    public WorkItemList getWorkItems(final int[] ids, final WorkItemExpand expand, final String[] fields) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("ids", WorkItemTrackingApi.this.intArrayToString(ids));
                this.put("$expand", expand.toString().toLowerCase());
                this.put("fields", String.join((CharSequence)",", fields));
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5264459e-e5e0-4bd8-b118-0985e68a4ec5", this.CONNECTION.getProject(), "wit/workitems", null, null, "7.1-preview.3", q, null, null);
        return this.MAPPER.mapJsonResponse(r, WorkItemList.class);
    }

    @Override
    public WorkItemList getWorkItems(final int[] ids, final WorkItemExpand expand, final String[] fields, final String asOf, final WorkItemErrorPolicy errorPolicy) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("ids", WorkItemTrackingApi.this.intArrayToString(ids));
                this.put("$expand", expand.toString().toLowerCase());
                this.put("asOf", asOf);
                this.put("fields", String.join((CharSequence)",", fields));
                this.put("errorPolicy", errorPolicy.toString().toLowerCase());
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5264459e-e5e0-4bd8-b118-0985e68a4ec5", this.CONNECTION.getProject(), "wit/workitems", null, null, "7.1-preview.3", q, null, null);
        return this.MAPPER.mapJsonResponse(r, WorkItemList.class);
    }

    @Override
    public WorkItemList getWorkItemRevisions(int workItemId) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5264459e-e5e0-4bd8-b118-0985e68a4ec5", this.CONNECTION.getProject(), "wit/workitems", Integer.toString(workItemId), "revisions", "7.1-preview.3", null, null, null);
        return this.MAPPER.mapJsonResponse(r, WorkItemList.class);
    }

    @Override
    public WorkItemList getWorkItemRevisions(int workItemId, final WorkItemExpand expand) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("$expand", expand.toString().toLowerCase());
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5264459e-e5e0-4bd8-b118-0985e68a4ec5", this.CONNECTION.getProject(), "wit/workitems", Integer.toString(workItemId), "revisions", "7.1-preview.3", q, null, null);
        return this.MAPPER.mapJsonResponse(r, WorkItemList.class);
    }

    @Override
    public WorkItemList getWorkItemRevisions(int workItemId, final WorkItemExpand expand, final int top, final int skip) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("$expand", expand.toString().toLowerCase());
                this.put("$top", top);
                this.put("$skip", skip);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5264459e-e5e0-4bd8-b118-0985e68a4ec5", this.CONNECTION.getProject(), "wit/workitems", Integer.toString(workItemId), "revisions", "7.1-preview.3", q, null, null);
        return this.MAPPER.mapJsonResponse(r, WorkItemList.class);
    }

    @Override
    public WorkItem getWorkItemRevision(int workItemId, int revisionNumber) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5264459e-e5e0-4bd8-b118-0985e68a4ec5", this.CONNECTION.getProject(), "wit/workitems", Integer.toString(workItemId), "revisions/" + revisionNumber, "7.1-preview.3", null, null, null);
        return this.MAPPER.mapJsonResponse(r, WorkItem.class);
    }

    @Override
    public WorkItem getWorkItemRevision(int workItemId, int revisionNumber, final WorkItemExpand expand) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("$expand", expand.toString().toLowerCase());
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5264459e-e5e0-4bd8-b118-0985e68a4ec5", this.CONNECTION.getProject(), "wit/workitems", Integer.toString(workItemId), "revisions/" + revisionNumber, "7.1-preview.3", q, null, null);
        return this.MAPPER.mapJsonResponse(r, WorkItem.class);
    }

    @Override
    public WorkItemQueryResult queryByWiql(String team, final String query) throws AzDException {
        HashMap<String, Object> body = new HashMap<String, Object>(){
            {
                this.put("query", query);
            }
        };
        String r = RestClient.send(RequestMethod.POST, this.CONNECTION, "5264459e-e5e0-4bd8-b118-0985e68a4ec5", this.CONNECTION.getProject() + "/" + URLHelper.encodeSpace(team), "wit", null, "wiql", "7.1-preview.2", null, body, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, WorkItemQueryResult.class);
    }

    @Override
    public WorkItemQueryResult queryByWiql(String team, final String query, final int top, final boolean timePrecision) throws AzDException {
        HashMap<String, Object> body = new HashMap<String, Object>(){
            {
                this.put("query", query);
            }
        };
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("$top", top);
                this.put("timePrecision", timePrecision);
            }
        };
        String r = RestClient.send(RequestMethod.POST, this.CONNECTION, "5264459e-e5e0-4bd8-b118-0985e68a4ec5", this.CONNECTION.getProject() + "/" + URLHelper.encodeSpace(team), "wit", null, "wiql", "7.1-preview.2", q, body, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, WorkItemQueryResult.class);
    }

    @Override
    public Void removeWorkItemFromRecycleBin(int id) throws AzDException {
        String r = RestClient.send(RequestMethod.DELETE, this.CONNECTION, "5264459e-e5e0-4bd8-b118-0985e68a4ec5", this.CONNECTION.getProject(), "wit/recyclebin", Integer.toString(id), null, "7.1-preview.2", null, null, null);
        if (!r.isEmpty()) {
            this.MAPPER.mapJsonResponse(r, Map.class);
        }
        return null;
    }

    @Override
    public WorkItemDeleteReference getWorkItemFromRecycleBin(int id) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5264459e-e5e0-4bd8-b118-0985e68a4ec5", this.CONNECTION.getProject(), "wit/recyclebin", Integer.toString(id), null, "7.1-preview.2", null, null, null);
        return this.MAPPER.mapJsonResponse(r, WorkItemDeleteReference.class);
    }

    @Override
    public WorkItemDeleteShallowReferences getDeletedWorkItemsFromRecycleBin() throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5264459e-e5e0-4bd8-b118-0985e68a4ec5", this.CONNECTION.getProject(), "wit/recyclebin", null, null, "7.1-preview.2", null, null, null);
        return this.MAPPER.mapJsonResponse(r, WorkItemDeleteShallowReferences.class);
    }

    @Override
    public WorkItemDeleteReferences getDeletedWorkItemsFromRecycleBin(final int[] ids) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("ids", WorkItemTrackingApi.this.intArrayToString(ids));
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5264459e-e5e0-4bd8-b118-0985e68a4ec5", this.CONNECTION.getProject(), "wit/recyclebin", null, null, "7.1-preview.2", q, null, null);
        return this.MAPPER.mapJsonResponse(r, WorkItemDeleteReferences.class);
    }

    @Override
    public WorkItemDeleteReference restoreWorkItemFromRecycleBin(int id) throws AzDException {
        HashMap<String, Object> b = new HashMap<String, Object>(){
            {
                this.put("isDeleted", false);
            }
        };
        String r = RestClient.send(RequestMethod.PATCH, this.CONNECTION, "5264459e-e5e0-4bd8-b118-0985e68a4ec5", this.CONNECTION.getProject(), "wit/recyclebin", Integer.toString(id), null, "7.1-preview.2", null, b, null);
        return this.MAPPER.mapJsonResponse(r, WorkItemDeleteReference.class);
    }

    @Override
    public WorkItem updateWorkItem(int workItemId, Map<String, Object> fieldsToUpdate) throws AzDException {
        return this.updateWorkItem(workItemId, fieldsToUpdate, WorkItemOperation.ADD);
    }

    @Override
    public WorkItem updateWorkItem(int workItemId, final Map<String, Object> fieldsToUpdate, final WorkItemOperation operation) throws AzDException {
        ArrayList<26> req = new ArrayList<26>();
        for (final String key : fieldsToUpdate.keySet()) {
            HashMap<String, Object> i = new HashMap<String, Object>(){
                {
                    this.put("op", operation.name().toLowerCase());
                    this.put("path", "/fields/" + key);
                    this.put("from", null);
                    if (operation != WorkItemOperation.REMOVE) {
                        this.put("value", fieldsToUpdate.get(key));
                    }
                }
            };
            req.add(i);
        }
        String r = RestClient.send(RequestMethod.PATCH, this.CONNECTION, "5264459e-e5e0-4bd8-b118-0985e68a4ec5", this.CONNECTION.getProject(), "wit/workitems", Integer.toString(workItemId), null, "7.1-preview.3", null, req, CustomHeader.JSON_PATCH);
        return this.MAPPER.mapJsonResponse(r, WorkItem.class);
    }

    @Override
    public WorkItem updateWorkItem(int workItemId, WorkItemExpand expand, boolean bypassRules, boolean suppressNotifications, boolean validateOnly, Map<String, Object> fieldsToUpdate) throws AzDException {
        return this.updateWorkItem(workItemId, expand, bypassRules, suppressNotifications, validateOnly, fieldsToUpdate, WorkItemOperation.ADD);
    }

    @Override
    public WorkItem updateWorkItem(int workItemId, final WorkItemExpand expand, final boolean bypassRules, final boolean suppressNotifications, final boolean validateOnly, final Map<String, Object> fieldsToUpdate, final WorkItemOperation operation) throws AzDException {
        ArrayList<27> req = new ArrayList<27>();
        for (final String key : fieldsToUpdate.keySet()) {
            HashMap<String, Object> i = new HashMap<String, Object>(){
                {
                    this.put("op", operation.name().toLowerCase());
                    this.put("path", "/fields/" + key);
                    this.put("from", null);
                    if (operation != WorkItemOperation.REMOVE) {
                        this.put("value", fieldsToUpdate.get(key));
                    }
                }
            };
            req.add(i);
        }
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("validateOnly", validateOnly);
                this.put("bypassRules", bypassRules);
                this.put("suppressNotifications", suppressNotifications);
                this.put("$expand", expand.toString().toLowerCase());
            }
        };
        String r = RestClient.send(RequestMethod.PATCH, this.CONNECTION, "5264459e-e5e0-4bd8-b118-0985e68a4ec5", this.CONNECTION.getProject(), "wit/workitems", Integer.toString(workItemId), null, "7.1-preview.3", q, req, CustomHeader.JSON_PATCH);
        return this.MAPPER.mapJsonResponse(r, WorkItem.class);
    }

    @Override
    public WorkItem addHyperLinks(int workItemId, Map<String, String> hyperlinksMap) throws AzDException {
        ArrayList reqBody = new ArrayList();
        for (Map.Entry<String, String> hyperlinkEntry : hyperlinksMap.entrySet()) {
            String url = hyperlinkEntry.getKey();
            String comment = hyperlinkEntry.getValue();
            HashMap<String, String> attributesMap = null;
            if (comment != null && !comment.isEmpty()) {
                attributesMap = new HashMap<String, String>();
                attributesMap.put("comment", comment);
            }
            HashMap<String, Object> hyperlinkMap = new HashMap<String, Object>();
            hyperlinkMap.put("rel", "Hyperlink");
            hyperlinkMap.put("url", url);
            if (attributesMap != null) {
                hyperlinkMap.put("attributes", attributesMap);
            }
            HashMap<String, Object> reqBodyMap = new HashMap<String, Object>();
            reqBodyMap.put("op", WorkItemOperation.ADD.name().toLowerCase());
            reqBodyMap.put("path", "/relations/-");
            reqBodyMap.put("value", hyperlinkMap);
            reqBody.add(reqBodyMap);
        }
        String reply = RestClient.send(RequestMethod.PATCH, this.CONNECTION, "5264459e-e5e0-4bd8-b118-0985e68a4ec5", this.CONNECTION.getProject(), "wit/workitems", Integer.toString(workItemId), null, "7.1-preview.3", null, reqBody, CustomHeader.JSON_PATCH);
        return this.MAPPER.mapJsonResponse(reply, WorkItem.class);
    }

    @Override
    public WorkItem removeHyperLinks(int workItemId, List<String> urls) throws AzDException {
        ArrayList reqBody = new ArrayList();
        List<WorkItemRelations> relations = this.getWorkItem(workItemId, WorkItemExpand.RELATIONS).getRelations();
        for (String url : urls) {
            int hyperlinkRelationNumber = -1;
            for (int i = 0; i < relations.size(); ++i) {
                WorkItemRelations workItemRelations = relations.get(i);
                if (!workItemRelations.getRel().equals("Hyperlink") || !workItemRelations.getUrl().equals(url)) continue;
                hyperlinkRelationNumber = i;
                break;
            }
            if (hyperlinkRelationNumber == -1) {
                throw new AzDException(MessageFormat.format("Unable to remove hyperlink ''{0}'' from work item with ID ''{1}'': The hyperlink doesn't exist.", url, hyperlinkRelationNumber));
            }
            HashMap<String, Object> reqBodyMap = new HashMap<String, Object>();
            reqBodyMap.put("op", WorkItemOperation.REMOVE.name().toLowerCase());
            reqBodyMap.put("path", "/relations/" + hyperlinkRelationNumber);
            reqBody.add(reqBodyMap);
        }
        String reply = RestClient.send(RequestMethod.PATCH, this.CONNECTION, "5264459e-e5e0-4bd8-b118-0985e68a4ec5", this.CONNECTION.getProject(), "wit/workitems", Integer.toString(workItemId), null, "7.1-preview.3", null, reqBody, CustomHeader.JSON_PATCH);
        return this.MAPPER.mapJsonResponse(reply, WorkItem.class);
    }

    @Override
    public WorkItemTypes getWorkItemTypes() throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5264459e-e5e0-4bd8-b118-0985e68a4ec5", this.CONNECTION.getProject(), "wit", null, "workitemtypes", "7.1-preview.2", null, null, null);
        return this.MAPPER.mapJsonResponse(r, WorkItemTypes.class);
    }

    @Override
    public WorkItemType getWorkItemType(String workItemTypeName) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5264459e-e5e0-4bd8-b118-0985e68a4ec5", this.CONNECTION.getProject(), "wit", null, "workitemtypes/" + workItemTypeName, "7.1-preview.2", null, null, null);
        return this.MAPPER.mapJsonResponse(r, WorkItemType.class);
    }

    @Override
    @Deprecated
    public AttachmentReference createAttachment(final String fileName, final AttachmentUploadType uploadType, final String teamAreaPath, String contents) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("fileName", fileName);
                this.put("uploadType", uploadType.toString().toLowerCase());
                this.put("areaPath", teamAreaPath);
            }
        };
        String r = RestClient.send(RequestMethod.POST, this.CONNECTION, "5264459e-e5e0-4bd8-b118-0985e68a4ec5", this.CONNECTION.getProject(), "wit", null, "attachments", "7.1-preview.3", q, contents, CustomHeader.STREAM);
        return this.MAPPER.mapJsonResponse(r, AttachmentReference.class);
    }

    @Override
    public AttachmentReference createAttachment(final String fileName, final AttachmentUploadType uploadType, final String teamAreaPath, InputStream contentStream) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("fileName", fileName);
                this.put("uploadType", uploadType.toString().toLowerCase());
                this.put("areaPath", teamAreaPath);
            }
        };
        InputStream response = RestClient.send(RequestMethod.POST, this.CONNECTION, "5264459e-e5e0-4bd8-b118-0985e68a4ec5", this.CONNECTION.getProject(), "wit", null, "attachments", "7.1-preview.3", q, contentStream, CustomHeader.STREAM, false);
        String r = StreamHelper.convertToString(response);
        return this.MAPPER.mapJsonResponse(r, AttachmentReference.class);
    }

    @Override
    public InputStream getAttachmentContent(String id, final String fileName, final boolean download) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("fileName", fileName);
                this.put("download", download);
            }
        };
        return RestClient.send(RequestMethod.GET, this.CONNECTION, "5264459e-e5e0-4bd8-b118-0985e68a4ec5", this.CONNECTION.getProject(), "wit/attachments", id, null, "7.1-preview.3", q, null, CustomHeader.STREAM, false);
    }

    @Override
    public InputStream getAttachmentAsZip(String id, final String fileName, final boolean download) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("fileName", fileName);
                this.put("download", download);
            }
        };
        return RestClient.send(RequestMethod.GET, this.CONNECTION, "5264459e-e5e0-4bd8-b118-0985e68a4ec5", this.CONNECTION.getProject(), "wit/attachments", id, null, "7.1-preview.3", q, null, CustomHeader.STREAM_ZIP, false);
    }

    @Override
    @Deprecated
    public String getAttachment(String id, final String fileName) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("fileName", fileName);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5264459e-e5e0-4bd8-b118-0985e68a4ec5", this.CONNECTION.getProject(), "wit/attachments", id, null, "7.1-preview.3", q, null, CustomHeader.JSON);
        return r;
    }

    @Override
    public WorkItem addWorkItemAttachment(int workItemId, Map<String, String> fieldsToUpdate) throws AzDException {
        ArrayList reqBody = new ArrayList();
        for (Map.Entry<String, String> entry : fieldsToUpdate.entrySet()) {
            String url = entry.getKey();
            String comment = entry.getValue();
            HashMap<String, String> attributesMap = null;
            if (comment != null && !comment.isEmpty()) {
                attributesMap = new HashMap<String, String>();
                attributesMap.put("comment", comment);
            }
            HashMap<String, Object> attachment = new HashMap<String, Object>();
            attachment.put("rel", "AttachedFile");
            attachment.put("url", url);
            if (attributesMap != null) {
                attachment.put("attributes", attributesMap);
            }
            HashMap<String, Object> reqBodyMap = new HashMap<String, Object>();
            reqBodyMap.put("op", WorkItemOperation.ADD.name().toLowerCase());
            reqBodyMap.put("path", "/relations/-");
            reqBodyMap.put("value", attachment);
            reqBody.add(reqBodyMap);
        }
        String res = RestClient.send(RequestMethod.PATCH, this.CONNECTION, "5264459e-e5e0-4bd8-b118-0985e68a4ec5", this.CONNECTION.getProject(), "wit/workitems", Integer.toString(workItemId), null, "7.1-preview.3", null, reqBody, CustomHeader.JSON_PATCH);
        return this.MAPPER.mapJsonResponse(res, WorkItem.class);
    }

    @Override
    public WorkItem removeWorkItemAttachment(int workItemId, List<String> attachmentUrl) throws AzDException {
        if (attachmentUrl.size() <= 0) {
            throw new AzDException("The attachment url list cannot be null. Please validate the argument before passing");
        }
        ArrayList reqBody = new ArrayList();
        List<WorkItemRelations> relations = this.getWorkItem(workItemId, WorkItemExpand.RELATIONS).getRelations();
        for (String url : attachmentUrl) {
            int attachmentRelationNumber = -1;
            for (int i = 0; i < relations.size(); ++i) {
                if (!relations.get(i).getUrl().equals(url)) continue;
                attachmentRelationNumber = i;
                HashMap<String, Object> reqBodyMap = new HashMap<String, Object>();
                reqBodyMap.put("op", WorkItemOperation.REMOVE.name().toLowerCase());
                reqBodyMap.put("path", "/relations/" + attachmentRelationNumber);
                reqBody.add(reqBodyMap);
            }
            if (attachmentRelationNumber != -1) continue;
            throw new AzDException(ApiExceptionTypes.InvalidArgumentException.name(), MessageFormat.format("Unable to remove the attachment ''{0}'' from work item with ID ''{1}'': The attachment doesn't exist.", url, workItemId));
        }
        String res = RestClient.send(RequestMethod.PATCH, this.CONNECTION, "5264459e-e5e0-4bd8-b118-0985e68a4ec5", this.CONNECTION.getProject(), "wit/workitems", Integer.toString(workItemId), null, "7.1-preview.3", null, reqBody, CustomHeader.JSON_PATCH);
        return this.MAPPER.mapJsonResponse(res, WorkItem.class);
    }

    @Override
    public AccountRecentActivityWorkItems getMyWorkRecentActivity() throws AzDException {
        String res = RestClient.send(RequestMethod.GET, this.CONNECTION, null, null, "work/accountmyworkrecentactivity", null, null, "7.1-preview.2", null, null, null);
        return this.MAPPER.mapJsonResponse(res, AccountRecentActivityWorkItems.class);
    }

    @Override
    public WorkItemFieldTypes getWorkItemFields() throws AzDException {
        String res = RestClient.send(RequestMethod.GET, this.CONNECTION, null, null, "wit", null, "fields", "7.1-preview.2", null, null, null);
        return this.MAPPER.mapJsonResponse(res, WorkItemFieldTypes.class);
    }

    @Override
    public WorkItemFieldTypes getWorkItemFields(final GetFieldsExpand expand) throws AzDException {
        HashMap<String, String> q = new HashMap<String, String>(){
            {
                this.put("$expand", expand.name().toLowerCase());
            }
        };
        String res = RestClient.send(RequestMethod.GET, this.CONNECTION, null, null, "wit", null, "fields", "7.1-preview.2", q, null, null);
        return this.MAPPER.mapJsonResponse(res, WorkItemFieldTypes.class);
    }

    @Override
    public WorkItemField getWorkItemField(String fieldNameOrRefName) throws AzDException {
        String res = RestClient.send(RequestMethod.GET, this.CONNECTION, null, null, "wit", null, "fields/" + URLHelper.encodeSpecialWithSpace(fieldNameOrRefName), "7.1-preview.2", null, null, null);
        return this.MAPPER.mapJsonResponse(res, WorkItemField.class);
    }

    @Override
    public WorkItemField createWorkItemField(WorkItemField workItemField) throws AzDException {
        String res = RestClient.send(RequestMethod.POST, this.CONNECTION, null, null, "wit", null, "fields", "7.1-preview.2", null, workItemField, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(res, WorkItemField.class);
    }

    @Override
    public Void deleteWorkItemField(String fieldNameOrRefName) throws AzDException {
        String res = RestClient.send(RequestMethod.DELETE, this.CONNECTION, null, null, "wit", null, "fields/" + URLHelper.encodeSpecialWithSpace(fieldNameOrRefName), "7.1-preview.2", null, null, null);
        if (!res.isEmpty()) {
            this.MAPPER.mapJsonResponse(res, Map.class);
        }
        return null;
    }

    @Override
    public WorkItemField updateWorkItemField(String fieldNameOrRefName, final boolean isDeleted) throws AzDException {
        UpdateWorkItemField b = new UpdateWorkItemField(){
            {
                this.setDeleted(isDeleted);
            }
        };
        String res = RestClient.send(RequestMethod.PATCH, this.CONNECTION, null, null, "wit", null, "fields/" + URLHelper.encodeSpecialWithSpace(fieldNameOrRefName), "7.1-preview.2", null, b, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(res, WorkItemField.class);
    }

    @Override
    public ProcessMigrationResultModel migrateProjectProcess(final String processId) throws AzDException {
        ProcessIdModel b = new ProcessIdModel(){
            {
                this.setTypeId(processId);
            }
        };
        String res = RestClient.send(RequestMethod.POST, this.CONNECTION, "5264459e-e5e0-4bd8-b118-0985e68a4ec5", this.CONNECTION.getProject(), "wit", null, "projectprocessmigration", "7.1-preview.1", null, b, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(res, ProcessMigrationResultModel.class);
    }

    @Override
    public QueryHierarchyItem createQuery(String query, QueryHierarchyItem queryHierarchyItem) throws AzDException {
        Map body = ModelBuilder.build(queryHierarchyItem, null);
        String res = RestClient.send(RequestMethod.POST, this.CONNECTION, "5264459e-e5e0-4bd8-b118-0985e68a4ec5", this.CONNECTION.getProject(), "wit", null, "queries/" + URLHelper.encodeSpecialWithSpace(query), "7.1-preview.2", null, body, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(res, QueryHierarchyItem.class);
    }

    @Override
    public QueryHierarchyItems getQueries() throws AzDException {
        String res = RestClient.send(RequestMethod.GET, this.CONNECTION, "5264459e-e5e0-4bd8-b118-0985e68a4ec5", this.CONNECTION.getProject(), "wit", null, "queries", "7.1-preview.2", null, null, null);
        return this.MAPPER.mapJsonResponse(res, QueryHierarchyItems.class);
    }

    @Override
    public QueryHierarchyItems getQueries(final int depth, final QueryExpand expand, final boolean includeDeleted) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("$depth", depth);
                this.put("$expand", expand.name().toLowerCase());
                this.put("$includeDeleted", includeDeleted);
            }
        };
        String res = RestClient.send(RequestMethod.GET, this.CONNECTION, "5264459e-e5e0-4bd8-b118-0985e68a4ec5", this.CONNECTION.getProject(), "wit", null, "queries", "7.1-preview.2", q, null, null);
        return this.MAPPER.mapJsonResponse(res, QueryHierarchyItems.class);
    }

    @Override
    public QueryHierarchyItem getQuery(String query) throws AzDException {
        String res = RestClient.send(RequestMethod.GET, this.CONNECTION, "5264459e-e5e0-4bd8-b118-0985e68a4ec5", this.CONNECTION.getProject(), "wit", null, "queries/" + URLHelper.encodeSpecialWithSpace(query), "7.1-preview.2", null, null, null);
        return this.MAPPER.mapJsonResponse(res, QueryHierarchyItem.class);
    }

    @Override
    public QueryHierarchyItem getQuery(String query, final int depth, final QueryExpand expand, final boolean includeDeleted, final boolean useIsoDateFormat) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("$depth", depth);
                this.put("$expand", expand.name().toLowerCase());
                this.put("$includeDeleted", includeDeleted);
                this.put("$useIsoDateFormat", useIsoDateFormat);
            }
        };
        String res = RestClient.send(RequestMethod.GET, this.CONNECTION, "5264459e-e5e0-4bd8-b118-0985e68a4ec5", this.CONNECTION.getProject(), "wit", null, "queries/" + URLHelper.encodeSpecialWithSpace(query), "7.1-preview.2", q, null, null);
        return this.MAPPER.mapJsonResponse(res, QueryHierarchyItem.class);
    }

    @Override
    public Void deleteQuery(String query) throws AzDException {
        String res = RestClient.send(RequestMethod.DELETE, this.CONNECTION, "5264459e-e5e0-4bd8-b118-0985e68a4ec5", this.CONNECTION.getProject(), "wit", null, "queries/" + URLHelper.encodeSpecialWithSpace(query), "7.1-preview.2", null, null, null);
        if (!res.isEmpty()) {
            this.MAPPER.mapJsonResponse(res, QueryHierarchyItem.class);
        }
        return null;
    }

    @Override
    public QueryHierarchyItems getQueryBatches(final QueryErrorPolicy errorPolicy, final QueryExpand expand, final String[] ids) throws AzDException {
        HashMap<String, Object> b = new HashMap<String, Object>(){
            {
                this.put("errorPolicy", errorPolicy.name().toLowerCase());
                this.put("$expand", expand.name().toLowerCase());
                this.put("ids", ids);
            }
        };
        String res = RestClient.send(RequestMethod.POST, this.CONNECTION, "5264459e-e5e0-4bd8-b118-0985e68a4ec5", this.CONNECTION.getProject(), "wit", null, "queriesbatch", "7.1-preview.1", null, b, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(res, QueryHierarchyItems.class);
    }

    @Override
    public QueryHierarchyItemsResult searchQuery(final String filter) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("$filter", filter);
            }
        };
        String res = RestClient.send(RequestMethod.GET, this.CONNECTION, "5264459e-e5e0-4bd8-b118-0985e68a4ec5", this.CONNECTION.getProject(), "wit", null, "queries", "7.1-preview.2", q, null, null);
        return this.MAPPER.mapJsonResponse(res, QueryHierarchyItemsResult.class);
    }

    @Override
    public QueryHierarchyItemsResult searchQuery(final String filter, QueryExpand expand, final boolean includeDeleted, final int top) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("$filter", filter);
                this.put("$includeDeleted", includeDeleted);
                this.put("$top", top);
            }
        };
        String res = RestClient.send(RequestMethod.GET, this.CONNECTION, "5264459e-e5e0-4bd8-b118-0985e68a4ec5", this.CONNECTION.getProject(), "wit", null, "queries", "7.1-preview.2", q, null, null);
        return this.MAPPER.mapJsonResponse(res, QueryHierarchyItemsResult.class);
    }

    private String intArrayToString(int[] i) {
        CharSequence[] r = (String[])Arrays.stream(i).mapToObj(String::valueOf).toArray(String[]::new);
        return String.join((CharSequence)",", r);
    }
}

