/*
 * Decompiled with CFR 0.152.
 */
package org.azd.accounts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.azd.accounts.types.Accounts;
import org.azd.accounts.types.Organization;
import org.azd.accounts.types.Organizations;
import org.azd.accounts.types.Profile;
import org.azd.connection.Connection;
import org.azd.enums.CustomHeader;
import org.azd.enums.RequestMethod;
import org.azd.exceptions.AzDException;
import org.azd.helpers.JsonMapper;
import org.azd.interfaces.AccountsDetails;
import org.azd.utils.AzDAsyncApi;
import org.azd.utils.RestClient;

public class AccountsApi
extends AzDAsyncApi<AccountsApi>
implements AccountsDetails {
    private final Connection CONNECTION;
    private final JsonMapper MAPPER = new JsonMapper();
    private final String AREA = "accounts";

    public AccountsApi(Connection connection) {
        this.CONNECTION = connection;
    }

    @Override
    public Accounts getAccounts(final String memberId) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("memberId", memberId);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "accounts", null, "accounts", null, null, "7.1-preview.1", q, null, null);
        return this.MAPPER.mapJsonResponse(r, Accounts.class);
    }

    @Override
    public List<Organization> getOrganizations() throws AzDException {
        final ArrayList<String> ids = new ArrayList<String>();
        ids.add("ms.vss-features.my-organizations-data-provider");
        HashMap<String, Object> b = new HashMap<String, Object>(){
            {
                this.put("contributionIds", ids);
                this.put("dataProviderContext", new HashMap<String, Object>(){
                    {
                        this.put("properties", "{}");
                    }
                });
            }
        };
        String r = RestClient.send(RequestMethod.POST, this.CONNECTION, null, null, "Contribution", null, "HierarchyQuery", "7.1-preview.1", null, b, CustomHeader.JSON_CONTENT_TYPE);
        Organizations res = this.MAPPER.mapJsonResponse(r, Organizations.class);
        return res.getDataProviders().getOrganizationsProvider().getOrganizations();
    }

    @Override
    public Profile getProfile() throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "accounts", null, "/profile/profiles", "me", null, "7.1-preview.3", null, null, null);
        return this.MAPPER.mapJsonResponse(r, Profile.class);
    }

    @Override
    public Profile getProfile(String id) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "accounts", null, "/profile/profiles", id, null, "7.1-preview.3", null, null, null);
        return this.MAPPER.mapJsonResponse(r, Profile.class);
    }
}

