/*
 * Decompiled with CFR 0.152.
 */
package org.azd.build;

import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.azd.build.types.Attachments;
import org.azd.build.types.Build;
import org.azd.build.types.BuildArtifact;
import org.azd.build.types.BuildArtifacts;
import org.azd.build.types.BuildChanges;
import org.azd.build.types.BuildController;
import org.azd.build.types.BuildControllers;
import org.azd.build.types.BuildDefinition;
import org.azd.build.types.BuildDefinitionRevisions;
import org.azd.build.types.BuildDefinitions;
import org.azd.build.types.BuildLogs;
import org.azd.build.types.BuildTags;
import org.azd.build.types.BuildWorkItems;
import org.azd.build.types.Builds;
import org.azd.build.types.Folder;
import org.azd.build.types.Folders;
import org.azd.build.types.RepositoryWebhooks;
import org.azd.build.types.SourceProvideBranches;
import org.azd.build.types.SourceProviderAttributes;
import org.azd.build.types.SourceProviderPullRequest;
import org.azd.build.types.SourceRepositories;
import org.azd.build.types.SourceRepositoryItems;
import org.azd.build.types.Timeline;
import org.azd.build.types.YamlBuild;
import org.azd.connection.Connection;
import org.azd.enums.CustomHeader;
import org.azd.enums.RequestMethod;
import org.azd.enums.SourceProviderResultSet;
import org.azd.enums.StageUpdateType;
import org.azd.exceptions.AzDException;
import org.azd.helpers.JsonMapper;
import org.azd.helpers.URLHelper;
import org.azd.interfaces.BuildDetails;
import org.azd.utils.AzDAsyncApi;
import org.azd.utils.RestClient;

public class BuildApi
extends AzDAsyncApi<BuildApi>
implements BuildDetails {
    private final Connection CONNECTION;
    private final JsonMapper MAPPER = new JsonMapper();
    private final String AREA = "build";
    private final String BUILD = "5d6898bb-45ec-463f-95f9-54d49c71752e";

    public BuildApi(Connection connection) {
        this.CONNECTION = connection;
    }

    @Override
    public Void deleteBuild(int buildId) throws AzDException {
        String r = RestClient.send(RequestMethod.DELETE, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "build/builds", Integer.toString(buildId), null, "7.1-preview.7", null, null, null);
        if (!r.isEmpty()) {
            this.MAPPER.mapJsonResponse(r, Map.class);
        }
        return null;
    }

    @Override
    public Build getBuild(int buildId) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "build/builds", Integer.toString(buildId), null, "7.1-preview.7", null, null, null);
        return this.MAPPER.mapJsonResponse(r, Build.class);
    }

    @Override
    public BuildChanges getBuildChanges(int buildId) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "build/builds", Integer.toString(buildId), "changes", "7.1-preview.2", null, null, null);
        return this.MAPPER.mapJsonResponse(r, BuildChanges.class);
    }

    @Override
    public BuildChanges getBuildChanges(int buildId, final int top, final String continuationToken, final boolean includeSourceChange) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("$top", top);
                this.put("continuationToken", continuationToken);
                this.put("includeSourceChange", includeSourceChange);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "build/builds", Integer.toString(buildId), "changes", "7.1-preview.2", q, null, null);
        return this.MAPPER.mapJsonResponse(r, BuildChanges.class);
    }

    @Override
    public String getBuildLog(int buildId, int logId) throws AzDException {
        return RestClient.send(RequestMethod.GET, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "build/builds", Integer.toString(buildId), "logs/" + logId, "7.1-preview.2", null, null, CustomHeader.TEXT_CONTENT);
    }

    @Override
    public String getBuildLog(int buildId, int logId, final long startLine, final long endLine) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("startLine", startLine);
                this.put("endLine", endLine);
            }
        };
        return RestClient.send(RequestMethod.GET, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "build/builds", Integer.toString(buildId), "logs/" + logId, "7.1-preview.2", q, null, CustomHeader.TEXT_CONTENT);
    }

    @Override
    public BuildLogs getBuildLogs(int buildId) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "build/builds", Integer.toString(buildId), "logs", "7.1-preview.2", null, null, null);
        return this.MAPPER.mapJsonResponse(r, BuildLogs.class);
    }

    @Override
    public BuildWorkItems getBuildWorkItems(int buildId) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "build/builds", Integer.toString(buildId), "workitems", "7.1-preview.2", null, null, null);
        return this.MAPPER.mapJsonResponse(r, BuildWorkItems.class);
    }

    @Override
    public BuildWorkItems getBuildWorkItems(int buildId, final int top) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("$top", top);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "build/builds", Integer.toString(buildId), "workitems", "7.1-preview.2", q, null, null);
        return this.MAPPER.mapJsonResponse(r, BuildWorkItems.class);
    }

    @Override
    public BuildChanges getChangesBetweenBuilds(final int fromBuildId, final int toBuildId, final int top) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("$top", top);
                this.put("fromBuildId", fromBuildId);
                this.put("toBuildId", toBuildId);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "build", null, "changes", "7.1-preview.2", q, null, null);
        return this.MAPPER.mapJsonResponse(r, BuildChanges.class);
    }

    @Override
    public BuildWorkItems getWorkItemsBetweenBuilds(final int fromBuildId, final int toBuildId, final int top) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("$top", top);
                this.put("fromBuildId", fromBuildId);
                this.put("toBuildId", toBuildId);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "build", null, "workitems", "7.1-preview.2", q, null, null);
        return this.MAPPER.mapJsonResponse(r, BuildWorkItems.class);
    }

    @Override
    public Builds getBuilds() throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "build/builds", null, null, "7.1-preview.7", null, null, null);
        return this.MAPPER.mapJsonResponse(r, Builds.class);
    }

    @Override
    public Builds getBuilds(int[] buildIds) throws AzDException {
        final String ids = Arrays.stream(buildIds).mapToObj(String::valueOf).collect(Collectors.joining(","));
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("buildIds", ids);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "build/builds", null, null, "7.1-preview.7", q, null, null);
        return this.MAPPER.mapJsonResponse(r, Builds.class);
    }

    @Override
    public Builds getBuilds(final int top) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("$top", top);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "build/builds", null, null, "7.1-preview.7", q, null, null);
        return this.MAPPER.mapJsonResponse(r, Builds.class);
    }

    @Override
    public Builds getBuilds(final int top, final String branchName, final String buildNumber, final String continuationToken, int[] definitions, final String deletedFilter, final int maxBuildsPerDefinition, final String maxTime, final String minTime, final String[] properties, final String queryOrder, int[] queues, final String reasonFilter, final String repositoryId, final String repositoryType, final String requestedFor, final String resultFilter, final String statusFilter, final String tagFilters) throws AzDException {
        final String ids = definitions != null ? Arrays.stream(definitions).mapToObj(String::valueOf).collect(Collectors.joining(",")) : null;
        final String queueIds = queues != null ? Arrays.stream(queues).mapToObj(String::valueOf).collect(Collectors.joining(",")) : null;
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("$top", top);
                this.put("branchName", branchName);
                this.put("buildNumber", buildNumber);
                this.put("continuationToken", continuationToken);
                this.put("definitions", ids);
                this.put("deletedFilter", deletedFilter);
                this.put("maxBuildsPerDefinition", maxBuildsPerDefinition);
                this.put("maxTime", maxTime);
                this.put("minTime", minTime);
                this.put("properties", properties != null ? String.join((CharSequence)",", properties) : null);
                this.put("queryOrder", queryOrder);
                this.put("queues", queueIds);
                this.put("reasonFilter", reasonFilter);
                this.put("repositoryType", repositoryType);
                this.put("requestedFor", requestedFor);
                this.put("resultFilter", resultFilter);
                this.put("repositoryId", repositoryId);
                this.put("statusFilter", statusFilter);
                this.put("tagFilters", tagFilters);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "build/builds", null, null, "7.1-preview.7", q, null, null);
        return this.MAPPER.mapJsonResponse(r, Builds.class);
    }

    @Override
    public Build queueBuild(final int definitionId) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("definitionId", String.valueOf(definitionId));
            }
        };
        String r = RestClient.send(RequestMethod.POST, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "build/builds", null, null, "7.1-preview.7", q, null, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, Build.class);
    }

    @Override
    public Build queueBuild(Build buildParameters) throws AzDException {
        String r = RestClient.send(RequestMethod.POST, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "build/builds", null, null, "7.1-preview.7", null, buildParameters, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, Build.class);
    }

    @Override
    public Build updateBuild(Build build, int buildId, final boolean retry) throws AzDException {
        HashMap<String, Boolean> q = new HashMap<String, Boolean>(){
            {
                this.put("retry", retry);
            }
        };
        String r = RestClient.send(RequestMethod.PATCH, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "build/builds", Integer.toString(buildId), null, "7.1-preview.7", q, build, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, Build.class);
    }

    @Override
    public Builds updateBuilds(Builds builds) throws AzDException {
        String r = RestClient.send(RequestMethod.PATCH, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "build/builds", null, null, "7.1-preview.7", null, builds.getBuildResults(), CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, Builds.class);
    }

    @Override
    public BuildControllers getBuildControllers() throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", null, "build", null, "controllers", "7.1-preview.2", null, null, null);
        return this.MAPPER.mapJsonResponse(r, BuildControllers.class);
    }

    @Override
    public BuildControllers getBuildControllers(final String name) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("name", name);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", null, "build", null, "controllers", "7.1-preview.2", q, null, null);
        return this.MAPPER.mapJsonResponse(r, BuildControllers.class);
    }

    @Override
    public BuildController getBuildController(int controllerId) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", null, "build/controllers", Integer.toString(controllerId), null, "7.1-preview.2", null, null, null);
        return this.MAPPER.mapJsonResponse(r, BuildController.class);
    }

    @Override
    public BuildDefinition createBuildDefinition(String buildDefinitionParameters) throws AzDException {
        if (buildDefinitionParameters.isEmpty()) {
            throw new AzDException();
        }
        Map requestBody = this.MAPPER.mapJsonResponse(buildDefinitionParameters, Map.class);
        String r = RestClient.send(RequestMethod.POST, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "build", null, "definitions", "7.1-preview.7", null, requestBody, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, BuildDefinition.class);
    }

    @Override
    public BuildDefinition cloneBuildDefinition(String definitionName, String definitionCloneName) throws AzDException {
        int def;
        try {
            def = this.getBuildDefinitions().getBuildDefinitions().stream().filter(x -> x.getName().equals(definitionName)).findFirst().get().getId();
        }
        catch (Exception e) {
            throw new AzDException("Cannot find the definition with name '" + definitionName + "'.");
        }
        if (!Integer.toString(def).isEmpty()) {
            BuildDefinition definitionObject = this.getBuildDefinition(def);
            definitionObject.setName(definitionCloneName);
            String res = this.MAPPER.convertToString(definitionObject);
            return this.createBuildDefinition(res);
        }
        return null;
    }

    @Override
    public Void deleteBuildDefinition(int definitionId) throws AzDException {
        String r = RestClient.send(RequestMethod.DELETE, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "build/definitions", Integer.toString(definitionId), null, "7.1-preview.7", null, null, null);
        if (!r.isEmpty()) {
            this.MAPPER.mapJsonResponse(r, Map.class);
        }
        return null;
    }

    @Override
    public BuildDefinition getBuildDefinition(int definitionId) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "build/definitions", Integer.toString(definitionId), null, "7.1-preview.7", null, null, null);
        return this.MAPPER.mapJsonResponse(r, BuildDefinition.class);
    }

    @Override
    public BuildDefinition getBuildDefinition(int definitionId, final boolean includeLatestBuilds, final String minMetricsTime, final int revision) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("includeLatestBuilds", includeLatestBuilds);
                this.put("minMetricsTime", minMetricsTime);
                this.put("revision", revision);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "build/definitions", Integer.toString(definitionId), null, "7.1-preview.7", q, null, null);
        return this.MAPPER.mapJsonResponse(r, BuildDefinition.class);
    }

    @Override
    public BuildDefinitionRevisions getBuildDefinitionRevisions(int definitionId) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "build/definitions", Integer.toString(definitionId), "revisions", "7.1-preview.3", null, null, null);
        return this.MAPPER.mapJsonResponse(r, BuildDefinitionRevisions.class);
    }

    @Override
    public BuildDefinitions getBuildDefinitions() throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "build/definitions", null, null, "7.1-preview.7", null, null, null);
        return this.MAPPER.mapJsonResponse(r, BuildDefinitions.class);
    }

    @Override
    public BuildDefinitions getBuildDefinitions(int[] definitionIds) throws AzDException {
        final String ids = Arrays.stream(definitionIds).mapToObj(String::valueOf).collect(Collectors.joining(","));
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("definitionIds", ids);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "build/definitions", null, null, "7.1-preview.7", q, null, null);
        return this.MAPPER.mapJsonResponse(r, BuildDefinitions.class);
    }

    @Override
    public BuildDefinitions getBuildDefinitions(final int top) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("$top", top);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "build/definitions", null, null, "7.1-preview.7", q, null, null);
        return this.MAPPER.mapJsonResponse(r, BuildDefinitions.class);
    }

    @Override
    public BuildDefinitions getBuildDefinitions(final String name) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("name", name);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "build/definitions", null, null, "7.1-preview.7", q, null, null);
        return this.MAPPER.mapJsonResponse(r, BuildDefinitions.class);
    }

    @Override
    public BuildDefinitions getBuildDefinitions(final boolean includeAllProperties, final boolean includeLatestBuilds) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("includeAllProperties", includeAllProperties);
                this.put("includeLatestBuilds", includeLatestBuilds);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "build/definitions", null, null, "7.1-preview.7", q, null, null);
        return this.MAPPER.mapJsonResponse(r, BuildDefinitions.class);
    }

    @Override
    public BuildDefinitions getBuildDefinitions(final String builtAfter, final String continuationToken, final boolean includeAllProperties, final boolean includeLatestBuilds, final String minMetricsTime, final String notBuiltAfter, final String path, final int processType, final String queryOrder, final String repositoryId, final String repositoryType, final String taskIdFilter, final String yamlFilename) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("builtAfter", builtAfter);
                this.put("continuationToken", continuationToken);
                this.put("includeAllProperties", includeAllProperties);
                this.put("includeLatestBuilds", includeLatestBuilds);
                this.put("minMetricsTime", minMetricsTime);
                this.put("notBuiltAfter", notBuiltAfter);
                this.put("path", path);
                this.put("processType", processType);
                this.put("queryOrder", queryOrder);
                this.put("repositoryId", repositoryId);
                this.put("repositoryType", repositoryType);
                this.put("taskIdFilter", taskIdFilter);
                this.put("yamlFilename", yamlFilename);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "build/definitions", null, null, "7.1-preview.7", q, null, null);
        return this.MAPPER.mapJsonResponse(r, BuildDefinitions.class);
    }

    @Override
    public BuildDefinition restoreBuildDefinition(int definitionId, final boolean deleted) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("deleted", deleted);
            }
        };
        String r = RestClient.send(RequestMethod.PATCH, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "build/definitions", Integer.toString(definitionId), null, "7.1-preview.7", q, null, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, BuildDefinition.class);
    }

    @Override
    public BuildDefinition updateBuildDefinition(BuildDefinition definition) throws AzDException {
        String r = RestClient.send(RequestMethod.PUT, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "build/definitions", Integer.toString(definition.getId()), null, "7.1-preview.7", null, definition, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, BuildDefinition.class);
    }

    @Override
    public BuildDefinition updateBuildDefinition(BuildDefinition definition, final int secretsSourceDefinitionId, final int secretsSourceDefinitionRevision) throws AzDException {
        HashMap<String, Integer> q = new HashMap<String, Integer>(){
            {
                this.put("secretsSourceDefinitionId", secretsSourceDefinitionId);
                this.put("secretsSourceDefinitionRevision", secretsSourceDefinitionRevision);
            }
        };
        String r = RestClient.send(RequestMethod.PUT, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "build/definitions", Integer.toString(definition.getId()), null, "7.1-preview.7", q, definition, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, BuildDefinition.class);
    }

    @Override
    public Folder createFolder(final String path, Folder folder) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("path", URLHelper.encodeSpecialWithSpace(path));
            }
        };
        String r = RestClient.send(RequestMethod.PUT, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "build", null, "folders", "7.1-preview.2", q, folder, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, Folder.class);
    }

    @Override
    public Void deleteFolder(final String path) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("path", URLHelper.encodeSpecialWithSpace(path));
            }
        };
        String r = RestClient.send(RequestMethod.DELETE, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "build", null, "folders", "7.1-preview.2", q, null, null);
        if (!r.isEmpty()) {
            this.MAPPER.mapJsonResponse(r, Map.class);
        }
        return null;
    }

    @Override
    public Folders getFolders() throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "build", null, "folders", "7.1-preview.2", null, null, null);
        return this.MAPPER.mapJsonResponse(r, Folders.class);
    }

    @Override
    public Folder updateFolder(String path, Folder folder) throws AzDException {
        Object finalPath = !path.isEmpty() && path.equals("+\\") ? "\\" + path : path;
        HashMap<String, Object> q = new HashMap<String, Object>((String)finalPath){
            final /* synthetic */ String val$finalPath;
            {
                this.val$finalPath = string;
                this.put("path", URLHelper.encodeSpecialWithSpace(this.val$finalPath));
            }
        };
        String r = RestClient.send(RequestMethod.POST, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "build", null, "folders", "7.1-preview.2", q, folder, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, Folder.class);
    }

    @Override
    public BuildTags addBuildTag(int buildId, String tag) throws AzDException {
        String r = RestClient.send(RequestMethod.PUT, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "build/builds", Integer.toString(buildId), "tags/" + tag, "7.1-preview.3", null, null, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, BuildTags.class);
    }

    @Override
    public BuildTags addBuildTags(int buildId, String[] tags) throws AzDException {
        String r = RestClient.send(RequestMethod.POST, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "build/builds", Integer.toString(buildId), "tags", "7.1-preview.3", null, tags, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, BuildTags.class);
    }

    @Override
    public BuildTags addDefinitionTag(int definitionId, String tag) throws AzDException {
        String r = RestClient.send(RequestMethod.PUT, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "build/definitions", Integer.toString(definitionId), "tags/" + tag, "7.1-preview.3", null, null, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, BuildTags.class);
    }

    @Override
    public BuildTags addDefinitionTags(int definitionId, String[] tags) throws AzDException {
        String r = RestClient.send(RequestMethod.POST, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "build/definitions", Integer.toString(definitionId), "tags", "7.1-preview.3", null, tags, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, BuildTags.class);
    }

    @Override
    public BuildTags deleteBuildTag(int buildId, String tag) throws AzDException {
        String r = RestClient.send(RequestMethod.DELETE, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "build/builds", Integer.toString(buildId), "tags/" + tag, "7.1-preview.3", null, null, null);
        return this.MAPPER.mapJsonResponse(r, BuildTags.class);
    }

    @Override
    public BuildTags deleteDefinitionTag(int definitionId, String tag) throws AzDException {
        String r = RestClient.send(RequestMethod.DELETE, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "build/definitions", Integer.toString(definitionId), "tags/" + tag, "7.1-preview.3", null, null, null);
        return this.MAPPER.mapJsonResponse(r, BuildTags.class);
    }

    @Override
    public BuildTags deleteTag(String tag) throws AzDException {
        String r = RestClient.send(RequestMethod.DELETE, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "build", null, "tags/" + tag, "7.1-preview.3", null, null, null);
        return this.MAPPER.mapJsonResponse(r, BuildTags.class);
    }

    @Override
    public BuildTags getBuildTags(int buildId) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "build/builds", Integer.toString(buildId), "tags", "7.1-preview.3", null, null, null);
        return this.MAPPER.mapJsonResponse(r, BuildTags.class);
    }

    @Override
    public BuildTags getDefinitionTags(int definitionId) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "build/definitions", Integer.toString(definitionId), "tags", "7.1-preview.3", null, null, null);
        return this.MAPPER.mapJsonResponse(r, BuildTags.class);
    }

    @Override
    public BuildTags getDefinitionTags(int definitionId, final int revision) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("revision", revision);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "build/definitions", Integer.toString(definitionId), "tags", "7.1-preview.3", q, null, null);
        return this.MAPPER.mapJsonResponse(r, BuildTags.class);
    }

    @Override
    public BuildTags getTags() throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "build", null, "tags", "7.1-preview.3", null, null, null);
        return this.MAPPER.mapJsonResponse(r, BuildTags.class);
    }

    @Override
    public BuildTags updateBuildTags(int buildId, final String[] tags, boolean toRemove) throws AzDException {
        final String tagValue = toRemove ? "tagsToRemove" : "tagsToAdd";
        HashMap<String, Object> body = new HashMap<String, Object>(){
            {
                this.put(tagValue, tags);
            }
        };
        String r = RestClient.send(RequestMethod.PATCH, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "build/builds", Integer.toString(buildId), "tags", "7.1-preview.3", null, body, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, BuildTags.class);
    }

    @Override
    public BuildTags updateDefinitionTags(int definitionId, final String[] tags, boolean toRemove) throws AzDException {
        final String tagValue = toRemove ? "tagsToRemove" : "tagsToAdd";
        HashMap<String, Object> body = new HashMap<String, Object>(){
            {
                this.put(tagValue, tags);
            }
        };
        String r = RestClient.send(RequestMethod.PATCH, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "build/definitions", Integer.toString(definitionId), "tags", "7.1-preview.3", null, body, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, BuildTags.class);
    }

    @Override
    public YamlBuild getYaml(int definitionId) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "build/definitions", Integer.toString(definitionId), "yaml", "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, YamlBuild.class);
    }

    @Override
    public YamlBuild getYaml(int definitionId, final boolean includeLatestBuilds, final String minMetricsTime, final String[] propertyFilters, final int revision) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("includeLatestBuilds", includeLatestBuilds);
                this.put("minMetricsTime", minMetricsTime);
                this.put("propertyFilters", String.join((CharSequence)",", propertyFilters));
                this.put("revision", revision);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "build/definitions", Integer.toString(definitionId), "yaml", "7.1-preview.1", q, null, null);
        return this.MAPPER.mapJsonResponse(r, YamlBuild.class);
    }

    @Override
    public Void updateBuildStage(int buildId, String stageReferenceName, final boolean forceRetryAllJobs, final StageUpdateType state) throws AzDException {
        HashMap<String, Object> body = new HashMap<String, Object>(){
            {
                this.put("forceRetryAllJobs", forceRetryAllJobs);
                this.put("state", state.toString().toLowerCase());
            }
        };
        String r = RestClient.send(RequestMethod.PATCH, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "build/builds", buildId + "/stages/" + stageReferenceName, null, "7.1-preview.1", null, body, CustomHeader.JSON_CONTENT_TYPE);
        if (!r.isEmpty()) {
            this.MAPPER.mapJsonResponse(r, Map.class);
        }
        return null;
    }

    @Override
    public String getFileContents(String providerName, final String serviceEndpointId, final String repositoryName, final String branchName, final String path) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("serviceEndpointId", serviceEndpointId);
                this.put("repository", repositoryName);
                this.put("commitOrBranch", branchName);
                this.put("path", path);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "sourceProviders", null, providerName + "/filecontents", "7.1-preview.1", q, null, CustomHeader.TEXT_CONTENT);
        if (!r.isEmpty() && r.contains("innerException") && r.contains("$id") && r.contains("eventId") && r.contains("typeName")) {
            this.MAPPER.mapJsonResponse(r, Map.class);
        }
        return r;
    }

    @Override
    public SourceRepositoryItems getPathContents(String providerName, final String serviceEndpointId, final String repositoryName, final String branchName, final String path) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("serviceEndpointId", serviceEndpointId);
                this.put("repository", repositoryName);
                this.put("commitOrBranch", branchName);
                this.put("path", path);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "sourceProviders", null, providerName + "/pathcontents", "7.1-preview.1", q, null, null);
        return this.MAPPER.mapJsonResponse(r, SourceRepositoryItems.class);
    }

    @Override
    public SourceProviderPullRequest getPullRequest(String providerName, String pullRequestId, final String repositoryName, final String serviceEndpointId) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("serviceEndpointId", serviceEndpointId);
                this.put("repositoryId", repositoryName);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "sourceProviders", null, providerName + "/pullrequests/" + pullRequestId, "7.1-preview.1", q, null, null);
        return this.MAPPER.mapJsonResponse(r, SourceProviderPullRequest.class);
    }

    @Override
    public SourceProviderAttributes getSourceProviders() throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "sourceProviders", null, null, "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, SourceProviderAttributes.class);
    }

    @Override
    public SourceProvideBranches getBranches(String providerName, final String serviceEndpointId, final String repositoryName) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("serviceEndpointId", serviceEndpointId);
                this.put("repository", repositoryName);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "sourceProviders", null, providerName + "/branches", "7.1-preview.1", q, null, null);
        return this.MAPPER.mapJsonResponse(r, SourceProvideBranches.class);
    }

    @Override
    public SourceProvideBranches getBranches(String providerName, final String serviceEndpointId, final String repositoryName, final String branchName) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("serviceEndpointId", serviceEndpointId);
                this.put("repository", repositoryName);
                this.put("branchName", branchName);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "sourceProviders", null, providerName + "/branches", "7.1-preview.1", q, null, null);
        return this.MAPPER.mapJsonResponse(r, SourceProvideBranches.class);
    }

    @Override
    public SourceRepositories getRepositories(String providerName, final String serviceEndpointId) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("serviceEndpointId", serviceEndpointId);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "sourceProviders", null, providerName + "/repositories", "7.1-preview.1", q, null, null);
        return this.MAPPER.mapJsonResponse(r, SourceRepositories.class);
    }

    @Override
    public SourceRepositories getRepositories(String providerName, final String serviceEndpointId, final String repositoryName) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("serviceEndpointId", serviceEndpointId);
                this.put("repository", repositoryName);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "sourceProviders", null, providerName + "/repositories", "7.1-preview.1", q, null, null);
        return this.MAPPER.mapJsonResponse(r, SourceRepositories.class);
    }

    @Override
    public SourceRepositories getRepositories(String providerName, final String serviceEndpointId, final String repositoryName, final String continuationToken, final boolean pageResults, final SourceProviderResultSet resultSet) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("serviceEndpointId", serviceEndpointId);
                this.put("repository", repositoryName);
                this.put("resultSet", resultSet.toString().toLowerCase());
                this.put("pageResults", pageResults);
                this.put("continuationToken", continuationToken);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "sourceProviders", null, providerName + "/repositories", "7.1-preview.1", q, null, null);
        return this.MAPPER.mapJsonResponse(r, SourceRepositories.class);
    }

    @Override
    public RepositoryWebhooks getWebHooks(String providerName, final String serviceEndpointId, final String repositoryName) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("serviceEndpointId", serviceEndpointId);
                this.put("repository", repositoryName);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "sourceProviders", null, providerName + "/webhooks", "7.1-preview.1", q, null, null);
        return this.MAPPER.mapJsonResponse(r, RepositoryWebhooks.class);
    }

    @Override
    public Void restoreWebHooks(String providerName, final String serviceEndpointId, final String repositoryName, List<String> triggerTypes) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("serviceEndpointId", serviceEndpointId);
                this.put("repository", repositoryName);
            }
        };
        String r = RestClient.send(RequestMethod.POST, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "sourceProviders", null, providerName + "/webhooks", "7.1-preview.1", q, triggerTypes, CustomHeader.JSON_CONTENT_TYPE);
        if (!r.isEmpty()) {
            this.MAPPER.mapJsonResponse(r, Map.class);
        }
        return null;
    }

    @Override
    public Timeline getTimeline(int buildId) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "build/builds", Integer.toString(buildId), "timeline", "7.1-preview.2", null, null, null);
        return this.MAPPER.mapJsonResponse(r, Timeline.class);
    }

    @Override
    public Timeline getTimeline(int buildId, String timelineId) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "build/builds", Integer.toString(buildId), "timeline/" + timelineId, "7.1-preview.2", null, null, null);
        return this.MAPPER.mapJsonResponse(r, Timeline.class);
    }

    @Override
    public Timeline getTimeline(int buildId, String timelineId, final int changeId, final String planId) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("changeId", changeId);
                this.put("planId", planId);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "build/builds", Integer.toString(buildId), "timeline/" + timelineId, "7.1-preview.2", q, null, null);
        return this.MAPPER.mapJsonResponse(r, Timeline.class);
    }

    @Override
    public BuildArtifact createArtifact(int buildId, BuildArtifact artifact) throws AzDException {
        String r = RestClient.send(RequestMethod.POST, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "build/builds", Integer.toString(buildId), "artifacts", "7.1-preview.5", null, artifact, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, BuildArtifact.class);
    }

    @Override
    public BuildArtifact getArtifact(int buildId, final String artifactName) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("artifactName", artifactName);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "build/builds", Integer.toString(buildId), "artifacts", "7.1-preview.5", q, null, null);
        return this.MAPPER.mapJsonResponse(r, BuildArtifact.class);
    }

    @Override
    public InputStream getArtifactAsZip(int buildId, final String artifactName) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("artifactName", artifactName);
            }
        };
        return RestClient.send(RequestMethod.GET, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "build/builds", Integer.toString(buildId), "artifacts", "7.1-preview.5", q, null, CustomHeader.STREAM_ZIP_ACCEPT, false);
    }

    @Override
    public InputStream getArtifactFile(int buildId, final String artifactName, final String fileId, final String fileName) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("artifactName", artifactName);
                this.put("fileId", fileId);
                this.put("fileName", fileName);
            }
        };
        return RestClient.send(RequestMethod.GET, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "build/builds", Integer.toString(buildId), "artifacts", "7.1-preview.5", q, null, CustomHeader.STREAM_ACCEPT, false);
    }

    @Override
    public BuildArtifacts getArtifacts(int buildId) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "build/builds", Integer.toString(buildId), "artifacts", "7.1-preview.5", null, null, null);
        return this.MAPPER.mapJsonResponse(r, BuildArtifacts.class);
    }

    @Override
    public Attachments getAttachments(int buildId, String type) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "5d6898bb-45ec-463f-95f9-54d49c71752e", this.CONNECTION.getProject(), "build/builds", Integer.toString(buildId), "attachments/" + type, "7.1-preview.2", null, null, null);
        return this.MAPPER.mapJsonResponse(r, Attachments.class);
    }
}

