/*
 * Decompiled with CFR 0.152.
 */
package org.azd.git;

import java.io.InputStream;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.azd.connection.Connection;
import org.azd.enums.ApiExceptionTypes;
import org.azd.enums.CustomHeader;
import org.azd.enums.GitAsyncOperationStatus;
import org.azd.enums.GitBlobRefFormat;
import org.azd.enums.GitHistoryMode;
import org.azd.enums.GitVersionOptions;
import org.azd.enums.GitVersionType;
import org.azd.enums.PullRequestStatus;
import org.azd.enums.RequestMethod;
import org.azd.enums.VersionControlRecursionType;
import org.azd.exceptions.AzDException;
import org.azd.git.types.GitAnnotatedTag;
import org.azd.git.types.GitBlobRef;
import org.azd.git.types.GitCommit;
import org.azd.git.types.GitCommitChanges;
import org.azd.git.types.GitCommitRefs;
import org.azd.git.types.GitCommits;
import org.azd.git.types.GitCommitsBatch;
import org.azd.git.types.GitDeletedRepositories;
import org.azd.git.types.GitForkSyncRequest;
import org.azd.git.types.GitForkSyncRequests;
import org.azd.git.types.GitItems;
import org.azd.git.types.GitPullRequest;
import org.azd.git.types.GitPush;
import org.azd.git.types.GitPushes;
import org.azd.git.types.GitRef;
import org.azd.git.types.GitRefUpdateResult;
import org.azd.git.types.GitRefUpdateResults;
import org.azd.git.types.GitRefs;
import org.azd.git.types.GitRepository;
import org.azd.git.types.GitRepositoryRefs;
import org.azd.git.types.IdentityRefWithVote;
import org.azd.git.types.PullRequestReviewers;
import org.azd.git.types.PullRequests;
import org.azd.git.types.Repositories;
import org.azd.git.types.ResourceRefs;
import org.azd.git.types.WebApiTagDefinition;
import org.azd.git.types.WebApiTagDefinitions;
import org.azd.helpers.JsonMapper;
import org.azd.interfaces.GitDetails;
import org.azd.utils.AzDAsyncApi;
import org.azd.utils.ModelBuilder;
import org.azd.utils.RestClient;

public class GitApi
extends AzDAsyncApi<GitApi>
implements GitDetails {
    private final Connection CONNECTION;
    private final JsonMapper MAPPER = new JsonMapper();
    private final String AREA = "git";
    private final String GIT = "4e080c62-fa21-4fbc-8fef-2a10a2b38049";

    public GitApi(Connection connection) {
        this.CONNECTION = connection;
    }

    @Override
    public GitRepository createRepository(final String repositoryName, final String projectId) throws AzDException {
        LinkedHashMap<String, Object> h = new LinkedHashMap<String, Object>(){
            {
                this.put("name", repositoryName);
                this.put("project", new LinkedHashMap<String, String>(){
                    {
                        this.put("id", projectId);
                    }
                });
            }
        };
        String r = RestClient.send(RequestMethod.POST, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", projectId, "git", null, "repositories", "7.1-preview.1", null, h, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, GitRepository.class);
    }

    @Override
    public Void deleteRepository(String repositoryId) throws AzDException {
        String r = RestClient.send(RequestMethod.DELETE, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git/repositories", repositoryId, null, "7.1-preview.1", null, null, null);
        if (!r.isEmpty()) {
            this.MAPPER.mapJsonResponse(r, Map.class);
        }
        return null;
    }

    @Override
    public Void deleteRepositoryFromRecycleBin(String repositoryId) throws AzDException {
        String r = RestClient.send(RequestMethod.DELETE, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git/recycleBin/repositories", repositoryId, null, "7.1-preview.1", null, null, null);
        if (!r.isEmpty()) {
            this.MAPPER.mapJsonResponse(r, Map.class);
        }
        return null;
    }

    @Override
    public GitDeletedRepositories getDeletedRepositories() throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git", null, "deletedrepositories", "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, GitDeletedRepositories.class);
    }

    @Override
    public GitDeletedRepositories getRecycleBinRepositories() throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git", null, "recycleBin/repositories", "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, GitDeletedRepositories.class);
    }

    @Override
    public GitRepository getRepository(String repositoryName) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git/repositories", repositoryName, null, "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, GitRepository.class);
    }

    @Override
    public Repositories getRepositories() throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git", null, "repositories", "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, Repositories.class);
    }

    @Override
    public GitRepository restoreRepositoryFromRecycleBin(String repositoryId, final boolean deleted) throws AzDException {
        HashMap<String, Object> h = new HashMap<String, Object>(){
            {
                this.put("deleted", deleted);
            }
        };
        String r = RestClient.send(RequestMethod.PATCH, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git/recycleBin/repositories", repositoryId, null, "7.1-preview.1", null, h, null);
        return this.MAPPER.mapJsonResponse(r, GitRepository.class);
    }

    @Override
    public GitRepository updateRepository(String repositoryId, final String repositoryName, final String defaultBranchName) throws AzDException {
        HashMap<String, Object> h = new HashMap<String, Object>(){
            {
                this.put("name", repositoryName);
                this.put("defaultBranch", "refs/heads/" + defaultBranchName);
            }
        };
        String r = RestClient.send(RequestMethod.PATCH, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git/repositories", repositoryId, null, "7.1-preview.1", null, h, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, GitRepository.class);
    }

    @Override
    public GitPullRequest createPullRequest(String repositoryId, final String sourceRefName, final String targetRefName, final String title, final String description, String[] reviewers) throws AzDException {
        final ArrayList<4> o = new ArrayList<4>();
        for (final String reviewer : reviewers) {
            HashMap<String, String> id = new HashMap<String, String>(){
                {
                    this.put("id", reviewer);
                }
            };
            o.add(id);
        }
        HashMap<String, Object> h = new HashMap<String, Object>(){
            {
                this.put("sourceRefName", sourceRefName);
                this.put("targetRefName", targetRefName);
                this.put("title", title);
                this.put("description", description);
                this.put("reviewers", o);
            }
        };
        String r = RestClient.send(RequestMethod.POST, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git/repositories", repositoryId, "pullrequests", "7.1-preview.1", null, h, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, GitPullRequest.class);
    }

    @Override
    public GitPullRequest createPullRequest(String repositoryId, String sourceRefName, String targetRefName, final String title, final String description, final boolean isDraft) throws AzDException {
        String referenceHead = "refs/heads/";
        final String sourceBranch = sourceRefName.contains(referenceHead) ? sourceRefName : referenceHead + sourceRefName;
        final String targetBranch = targetRefName.contains(referenceHead) ? targetRefName : referenceHead + targetRefName;
        HashMap<String, Object> b = new HashMap<String, Object>(){
            {
                this.put("sourceRefName", sourceBranch);
                this.put("targetRefName", targetBranch);
                this.put("title", title);
                this.put("description", description);
                this.put("isDraft", isDraft);
            }
        };
        String r = RestClient.send(RequestMethod.POST, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git/repositories", repositoryId, "pullrequests", "7.1-preview.1", null, b, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, GitPullRequest.class);
    }

    @Override
    public GitPullRequest createPullRequest(GitPullRequest gitPullRequest) throws AzDException {
        if (gitPullRequest == null) {
            throw new AzDException("Request body cannot be null or empty");
        }
        if (!gitPullRequest.getSourceRefName().isEmpty() && !gitPullRequest.getTargetRefName().isEmpty()) {
            String referenceHead = "refs/heads/";
            if (!gitPullRequest.getSourceRefName().contains(referenceHead)) {
                gitPullRequest.setSourceRefName(referenceHead + gitPullRequest.getSourceRefName());
            }
            if (!gitPullRequest.getTargetRefName().contains(referenceHead)) {
                gitPullRequest.setTargetRefName(referenceHead + gitPullRequest.getTargetRefName());
            }
        }
        String r = RestClient.send(RequestMethod.POST, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git/repositories", gitPullRequest.getRepository().getId(), "pullrequests", "7.1-preview.1", null, gitPullRequest, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, GitPullRequest.class);
    }

    @Override
    public GitPullRequest getPullRequest(String repositoryName, int pullRequestId) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git/repositories", repositoryName, "pullrequests/" + pullRequestId, "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, GitPullRequest.class);
    }

    @Override
    public GitPullRequest getPullRequestById(int pullRequestId) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git/pullrequests", Integer.toString(pullRequestId), null, "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, GitPullRequest.class);
    }

    @Override
    public PullRequests getPullRequests(String repositoryName) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git/repositories", repositoryName, "pullrequests", "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, PullRequests.class);
    }

    @Override
    public PullRequests getPullRequestsByProject() throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git", null, "pullrequests", "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, PullRequests.class);
    }

    @Override
    public PullRequests getPullRequestsByProject(final int top) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("$top", top);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git", null, "pullrequests", "7.1-preview.1", q, null, null);
        return this.MAPPER.mapJsonResponse(r, PullRequests.class);
    }

    @Override
    public PullRequests getPullRequestsByProject(final PullRequestStatus status) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("searchCriteria.status", status.toString().toLowerCase());
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git", null, "pullrequests", "7.1-preview.1", q, null, null);
        return this.MAPPER.mapJsonResponse(r, PullRequests.class);
    }

    @Override
    public GitPullRequest updatePullRequest(String repositoryId, int pullRequestId, Object body) throws AzDException {
        String r = RestClient.send(RequestMethod.PATCH, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git/repositories", repositoryId + "/pullrequests/" + pullRequestId, null, "7.1-preview.1", null, body, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, GitPullRequest.class);
    }

    @Override
    public PullRequests getPullRequestsByProject(final int skip, final int top, final String creatorId, final boolean includeLinks, final String repositoryId, final String reviewerId, final String sourceRefName, final String sourceRepositoryId, final PullRequestStatus status, final String targetRefName) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("$skip", skip);
                this.put("$top", top);
                this.put("searchCriteria.creatorId", creatorId);
                this.put("searchCriteria.includeLinks", includeLinks);
                this.put("searchCriteria.repositoryId", repositoryId);
                this.put("searchCriteria.reviewerId", reviewerId);
                this.put("searchCriteria.sourceRefName", sourceRefName);
                this.put("searchCriteria.sourceRepositoryId", sourceRepositoryId);
                this.put("searchCriteria.status", status.toString().toLowerCase());
                this.put("searchCriteria.targetRefName", targetRefName);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git", null, "pullrequests", "7.1-preview.1", q, null, null);
        return this.MAPPER.mapJsonResponse(r, PullRequests.class);
    }

    @Override
    public GitRef getBranch(String repositoryName, final String branchName) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("filter", "heads/" + branchName);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git/repositories", repositoryName, "refs", "7.1-preview.1", q, null, null);
        List<GitRef> gitRefs = this.MAPPER.mapJsonResponse(r, GitRefs.class).getRefs();
        return gitRefs != null && !gitRefs.isEmpty() ? gitRefs.get(0) : null;
    }

    @Override
    public GitRefs getBranches(String repositoryName) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("filter", "heads");
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git/repositories", repositoryName, "refs", "7.1-preview.1", q, null, null);
        return this.MAPPER.mapJsonResponse(r, GitRefs.class);
    }

    @Override
    public GitRef updateBranchLock(String repositoryName, final String branchName, final boolean isLocked) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("filter", "heads/" + branchName);
            }
        };
        HashMap<String, Object> b = new HashMap<String, Object>(){
            {
                this.put("isLocked", isLocked);
            }
        };
        String r = RestClient.send(RequestMethod.PATCH, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git/repositories", repositoryName, "refs", "7.1-preview.1", q, b, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, GitRef.class);
    }

    @Override
    public ResourceRefs getPullRequestWorkItems(int pullRequestId, String repositoryName) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git/repositories", repositoryName, "pullRequests/" + pullRequestId + "/workitems", "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, ResourceRefs.class);
    }

    @Override
    public WebApiTagDefinition createPullRequestLabel(String repositoryName, int pullRequestId, final String labelName) throws AzDException {
        HashMap<String, Object> b = new HashMap<String, Object>(){
            {
                this.put("name", labelName);
            }
        };
        String r = RestClient.send(RequestMethod.POST, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git/repositories", repositoryName, "pullrequests/" + pullRequestId + "/labels", "7.1-preview.1", null, b, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, WebApiTagDefinition.class);
    }

    @Override
    public Void deletePullRequestLabel(String repositoryName, int pullRequestId, String labelName) throws AzDException {
        String resource = "pullrequests/" + pullRequestId + "/labels/" + labelName;
        String r = RestClient.send(RequestMethod.DELETE, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git/repositories", repositoryName, resource, "7.1-preview.1", null, null, null);
        if (!r.isEmpty()) {
            this.MAPPER.mapJsonResponse(r, Map.class);
        }
        return null;
    }

    @Override
    public WebApiTagDefinition getPullRequestLabel(String repositoryName, int pullRequestId, String labelName) throws AzDException {
        String resource = "pullrequests/" + pullRequestId + "/labels/" + labelName;
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git/repositories", repositoryName, resource, "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, WebApiTagDefinition.class);
    }

    @Override
    public WebApiTagDefinitions getPullRequestLabels(String repositoryName, int pullRequestId) throws AzDException {
        String resource = "pullrequests/" + pullRequestId + "/labels";
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git/repositories", repositoryName, resource, "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, WebApiTagDefinitions.class);
    }

    @Override
    public IdentityRefWithVote createPullRequestReviewer(int pullRequestId, String repositoryName, final String reviewerId, final int vote, boolean isRequired) throws AzDException {
        HashMap<String, Object> b = new HashMap<String, Object>(){
            {
                this.put("vote", vote);
                this.put("id", reviewerId);
            }
        };
        String id = repositoryName + "/pullrequests/" + pullRequestId + "/reviewers/" + reviewerId;
        String r = RestClient.send(RequestMethod.PUT, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git/repositories", id, null, "7.1-preview.1", null, b, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, IdentityRefWithVote.class);
    }

    @Override
    public Void deletePullRequestReviewer(int pullRequestId, String repositoryName, String reviewerId) throws AzDException {
        String id = repositoryName + "/pullrequests/" + pullRequestId + "/reviewers/" + reviewerId;
        String r = RestClient.send(RequestMethod.DELETE, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git/repositories", id, null, "7.1-preview.1", null, null, null);
        if (!r.isEmpty()) {
            this.MAPPER.mapJsonResponse(r, Map.class);
        }
        return null;
    }

    @Override
    public IdentityRefWithVote getPullRequestReviewer(int pullRequestId, String repositoryName, String reviewerId) throws AzDException {
        String id = repositoryName + "/pullrequests/" + pullRequestId + "/reviewers/" + reviewerId;
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git/repositories", id, null, "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, IdentityRefWithVote.class);
    }

    @Override
    public PullRequestReviewers getPullRequestReviewers(int pullRequestId, String repositoryName) throws AzDException {
        String id = repositoryName + "/pullrequests/" + pullRequestId + "/reviewers";
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git/repositories", id, null, "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, PullRequestReviewers.class);
    }

    @Override
    public IdentityRefWithVote updatePullRequestReviewer(int pullRequestId, String repositoryName, String reviewerId, final boolean isFlagged, final boolean hasDeclined) throws AzDException {
        HashMap<String, Object> b = new HashMap<String, Object>(){
            {
                this.put("isFlagged", isFlagged);
                this.put("hasDeclined", hasDeclined);
            }
        };
        String id = repositoryName + "/pullrequests/" + pullRequestId + "/reviewers/" + reviewerId;
        String r = RestClient.send(RequestMethod.PATCH, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git/repositories", id, null, "7.1-preview.1", null, b, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, IdentityRefWithVote.class);
    }

    @Override
    public GitAnnotatedTag createAnnotatedTag(String repositoryName, final String tagName, final String objectId, final String message) throws AzDException {
        HashMap<String, Object> b = new HashMap<String, Object>(){
            {
                this.put("name", tagName);
                this.put("taggedObject", new HashMap<String, String>(){
                    {
                        this.put("objectId", objectId);
                    }
                });
                this.put("message", message);
            }
        };
        String r = RestClient.send(RequestMethod.POST, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git/repositories", repositoryName, "annotatedtags", "7.1-preview.1", null, b, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, GitAnnotatedTag.class);
    }

    @Override
    public GitAnnotatedTag getAnnotatedTag(String repositoryName, String objectId) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git/repositories", repositoryName, "annotatedtags/" + objectId, "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, GitAnnotatedTag.class);
    }

    @Override
    public GitCommit getCommit(String repositoryName, String commitId) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git/repositories", repositoryName, "commits/" + commitId, "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, GitCommit.class);
    }

    @Override
    public GitCommit getCommit(String repositoryName, String commitId, final int changeCount) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("changeCount", changeCount);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git/repositories", repositoryName, "commits/" + commitId, "7.1-preview.1", q, null, null);
        return this.MAPPER.mapJsonResponse(r, GitCommit.class);
    }

    @Override
    public GitCommitChanges getChanges(String repositoryName, String commitId) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git/repositories", repositoryName, "commits/" + commitId + "/changes", "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, GitCommitChanges.class);
    }

    @Override
    public GitCommitChanges getChanges(String repositoryName, String commitId, final int top, final int skip) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("top", top);
                this.put("skip", skip);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git/repositories", repositoryName, "commits/" + commitId + "/changes", "7.1-preview.1", q, null, null);
        return this.MAPPER.mapJsonResponse(r, GitCommitChanges.class);
    }

    @Override
    public GitCommits getCommits(String repositoryName) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git/repositories", repositoryName, "commits", "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, GitCommits.class);
    }

    @Override
    public GitCommits getCommits(String repositoryName, final int top) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("top", top);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git/repositories", repositoryName, "commits", "7.1-preview.1", q, null, null);
        return this.MAPPER.mapJsonResponse(r, GitCommits.class);
    }

    @Override
    public GitCommits getCommits(String repositoryName, final List<String> ids) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("ids", String.join((CharSequence)",", ids));
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git/repositories", repositoryName, "commits", "7.1-preview.1", q, null, null);
        return this.MAPPER.mapJsonResponse(r, GitCommits.class);
    }

    @Override
    public GitCommits getCommits(String repositoryName, final int top, final int skip, final String author, final String version, final GitVersionOptions versionOptions, final GitVersionType versionType, final boolean excludeDeletes, final String fromCommitId, final String toCommitId, final String fromDate, final String toDate, final GitHistoryMode historyMode, final List<String> ids, final boolean includeLinks, final boolean includePushData, final boolean includeUserImageUrl, boolean includeWorkItems, final String itemPath, final boolean showOldestCommitsFirst, final String user, final String itemVersion, final GitVersionOptions itemVersionOptions, final GitVersionType itemVersionType) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("$top", top);
                this.put("$skip", skip);
                this.put("author", author);
                this.put("compareVersion.version", version);
                this.put("compareVersion.versionOptions", versionOptions.toString().toLowerCase());
                this.put("compareVersion.versionType", versionType.toString().toLowerCase());
                this.put("excludeDeletes", excludeDeletes);
                this.put("fromCommitId", fromCommitId);
                this.put("fromDate", fromDate);
                this.put("historyMode", historyMode.toString().toLowerCase());
                this.put("ids", String.join((CharSequence)",", ids));
                this.put("includeLinks", includeLinks);
                this.put("includePushData", includePushData);
                this.put("includeUserImageUrl", includeUserImageUrl);
                this.put("itemPath", itemPath);
                this.put("itemVersion.version", itemVersion);
                this.put("itemVersion.versionOptions", itemVersionOptions.toString().toLowerCase());
                this.put("itemVersion.versionType", itemVersionType.toString().toLowerCase());
                this.put("showOldestCommitsFirst", showOldestCommitsFirst);
                this.put("toCommitId", toCommitId);
                this.put("toDate", toDate);
                this.put("user", user);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git/repositories", repositoryName, "commits", "7.1-preview.1", q, null, null);
        return this.MAPPER.mapJsonResponse(r, GitCommits.class);
    }

    @Override
    public GitCommits getPushCommits(String repositoryName, final int pushId) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("pushId", pushId);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git/repositories", repositoryName, "commits", "7.1-preview.1", q, null, null);
        return this.MAPPER.mapJsonResponse(r, GitCommits.class);
    }

    @Override
    public GitCommits getPushCommits(String repositoryName, final int pushId, final boolean includeLinks, final int top, final int skip) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("pushId", pushId);
                this.put("top", top);
                this.put("skip", skip);
                this.put("includeLinks", includeLinks);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git/repositories", repositoryName, "commits", "7.1-preview.1", q, null, null);
        return this.MAPPER.mapJsonResponse(r, GitCommits.class);
    }

    @Override
    public GitCommitRefs getCommitsBatch(String repositoryId, GitCommitsBatch gitCommitsBatch) throws AzDException {
        ArrayList<String> valuesToRemove = new ArrayList<String>();
        if (gitCommitsBatch.getSkip() == 0) {
            valuesToRemove.add("$skip");
        }
        if (gitCommitsBatch.getTop() == 0) {
            valuesToRemove.add("$top");
        }
        Map b = ModelBuilder.build(gitCommitsBatch, valuesToRemove);
        String r = RestClient.send(RequestMethod.POST, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git/repositories", repositoryId, "commitsbatch", "7.1-preview.1", null, b, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, GitCommitRefs.class);
    }

    @Override
    public GitRefs getRefs(String repositoryName) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git/repositories", repositoryName, "refs", "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, GitRefs.class);
    }

    @Override
    public GitRefs getRefs(String repositoryName, final String filter) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("filter", filter);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git/repositories", repositoryName, "refs", "7.1-preview.1", q, null, null);
        return this.MAPPER.mapJsonResponse(r, GitRefs.class);
    }

    @Override
    public GitRefUpdateResult updateRef(String repositoryName, final String refName, final String oldObjectId, final String newObjectId) throws AzDException {
        ArrayList<26> b = new ArrayList<26>();
        HashMap<String, Object> h = new HashMap<String, Object>(){
            {
                this.put("name", refName);
                this.put("oldObjectId", oldObjectId);
                this.put("newObjectId", newObjectId);
            }
        };
        b.add(h);
        String r = RestClient.send(RequestMethod.POST, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git/repositories", repositoryName, "refs", "7.1-preview.1", null, b, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, GitRefUpdateResults.class).getGitRefUpdateResults().get(0);
    }

    @Override
    public GitRefUpdateResult createTag(String repositoryName, String tagName, String ref) throws AzDException {
        if (ref.matches("^[a-fA-F0-9]{40}$")) {
            return this.updateRef(repositoryName, "refs/tags/" + tagName, "0000000000000000000000000000000000000000", ref);
        }
        GitRefs refs = this.getRefs(repositoryName, "tags/" + ref);
        if (!refs.getRefs().isEmpty()) {
            String objectId = refs.getRefs().get(0).getObjectId();
            return this.updateRef(repositoryName, "refs/tags/" + tagName, "0000000000000000000000000000000000000000", objectId);
        }
        refs = this.getRefs(repositoryName, "heads/" + ref);
        if (!refs.getRefs().isEmpty()) {
            String objectId = refs.getRefs().get(0).getObjectId();
            return this.updateRef(repositoryName, "refs/tags/" + tagName, "0000000000000000000000000000000000000000", objectId);
        }
        throw new AzDException(ApiExceptionTypes.InvalidArgumentException.name(), MessageFormat.format("Could not find ref {0}", ref));
    }

    @Override
    public GitRefUpdateResult deleteTag(String repositoryName, String tagName) throws AzDException {
        GitRefs refs = this.getRefs(repositoryName, "tags/" + tagName);
        if (refs.getRefs().isEmpty()) {
            throw new AzDException(ApiExceptionTypes.InvalidArgumentException.name(), MessageFormat.format("Tag {0} does not exist in repository {1}", tagName, repositoryName));
        }
        String tagObjectId = refs.getRefs().get(0).getObjectId();
        return this.updateRef(repositoryName, "refs/tags/" + tagName, tagObjectId, "0000000000000000000000000000000000000000");
    }

    @Override
    public GitBlobRef getBlob(String repositoryId, String sha1) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git/repositories", repositoryId, "blobs/" + sha1, "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, GitBlobRef.class);
    }

    @Override
    public GitBlobRef getBlob(String repositoryId, String sha1, final String fileName, final boolean resolveLfs) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("$format", GitBlobRefFormat.JSON.name());
                this.put("fileName", fileName);
                this.put("resolveLfs", resolveLfs);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git/repositories", repositoryId, "blobs/" + sha1, "7.1-preview.1", q, null, null);
        return this.MAPPER.mapJsonResponse(r, GitBlobRef.class);
    }

    @Override
    public String getBlobContent(String repositoryId, String sha1, final boolean download, final String fileName, final boolean resolveLfs) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("$format", GitBlobRefFormat.TEXT.name());
                this.put("download", download);
                this.put("fileName", fileName);
                this.put("resolveLfs", resolveLfs);
            }
        };
        return RestClient.send(RequestMethod.GET, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git/repositories", repositoryId, "blobs/" + sha1, "7.1-preview.1", q, null, null);
    }

    @Override
    public InputStream getBlobContentAsZip(String repositoryId, String sha1, final boolean download, final String fileName, final boolean resolveLfs) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("$format", GitBlobRefFormat.ZIP.name());
                this.put("download", download);
                this.put("fileName", fileName);
                this.put("resolveLfs", resolveLfs);
            }
        };
        return RestClient.send(RequestMethod.GET, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git/repositories", repositoryId, "blobs/" + sha1, "7.1-preview.1", q, null, null, false);
    }

    @Override
    public InputStream getBlobContentAsStream(String repositoryId, String sha1, final boolean download, final String fileName, final boolean resolveLfs) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("$format", GitBlobRefFormat.OCTETSTREAM.name());
                this.put("download", download);
                this.put("fileName", fileName);
                this.put("resolveLfs", resolveLfs);
            }
        };
        return RestClient.send(RequestMethod.GET, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git/repositories", repositoryId, "blobs/" + sha1, "7.1-preview.1", q, null, null, false);
    }

    @Override
    public InputStream getBlobsZip(String repositoryId, List<String> sha1) throws AzDException {
        return (InputStream)((CompletableFuture)RestClient.send(null, RequestMethod.POST, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git/repositories", repositoryId, "blobs", "7.1-preview.1", null, HttpRequest.BodyPublishers.ofString(this.MAPPER.convertToString(sha1)), HttpResponse.BodyHandlers.ofInputStream(), Map.of("Stream_Zip", CustomHeader.STREAM_ZIP_ACCEPT, "Content_Type", CustomHeader.JSON_CONTENT_TYPE), false).thenApplyAsync(HttpResponse::body)).join();
    }

    @Override
    public InputStream getBlobsZip(String repositoryId, String fileName, List<String> sha1) throws AzDException {
        return (InputStream)((CompletableFuture)RestClient.send(null, RequestMethod.POST, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git/repositories", repositoryId, "blobs", "7.1-preview.1", Map.of("filename", fileName), HttpRequest.BodyPublishers.ofString(this.MAPPER.convertToString(sha1)), HttpResponse.BodyHandlers.ofInputStream(), Map.of("Stream_Zip", CustomHeader.STREAM_ZIP_ACCEPT, "Content_Type", CustomHeader.JSON_CONTENT_TYPE), false).thenApplyAsync(HttpResponse::body)).join();
    }

    @Override
    public GitItems getItems(String repositoryName) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git/repositories", repositoryName, "items", "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, GitItems.class);
    }

    @Override
    public GitItems getItems(String repositoryName, final VersionControlRecursionType recursionType) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("recursionLevel", recursionType.name());
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git/repositories", repositoryName, "items", "7.1-preview.1", q, null, null);
        return this.MAPPER.mapJsonResponse(r, GitItems.class);
    }

    @Override
    public GitItems getItems(String repositoryName, final boolean includeContentMetadata, final boolean includeLinks, final boolean latestProcessedChange, final VersionControlRecursionType recursionType, String scopePath) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("recursionLevel", recursionType.getValue());
                this.put("includeContentMetadata", includeContentMetadata);
                this.put("includeLinks", includeLinks);
                this.put("latestProcessedChange", latestProcessedChange);
            }
        };
        if (scopePath != null) {
            q.put("scopePath", scopePath);
        }
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git/repositories", repositoryName, "items", "7.1-preview.1", q, null, null);
        return this.MAPPER.mapJsonResponse(r, GitItems.class);
    }

    @Override
    public GitItems getItems(String repositoryName, final boolean includeContentMetadata, final boolean includeLinks, final boolean latestProcessedChange, final VersionControlRecursionType recursionType, String scopePath, final String version, final GitVersionOptions versionOptions, final GitVersionType versionType) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("recursionLevel", recursionType.getValue());
                this.put("includeContentMetadata", includeContentMetadata);
                this.put("includeLinks", includeLinks);
                this.put("latestProcessedChange", latestProcessedChange);
                this.put("versionOptions", versionOptions);
                this.put("versionType", versionType);
                this.put("version", version);
            }
        };
        if (scopePath != null) {
            q.put("scopePath", scopePath);
        }
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git/repositories", repositoryName, "items", "7.1-preview.1", q, null, null);
        return this.MAPPER.mapJsonResponse(r, GitItems.class);
    }

    @Override
    public GitForkSyncRequest createForkSyncRequest(String repositoryName, final String sourceCollectionId, final String sourceProjectId, final String sourceRepositoryId, final Boolean includeLinks) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("includeLinks", includeLinks);
            }
        };
        HashMap<String, Object> b = new HashMap<String, Object>(){
            {
                this.put("source", new HashMap<String, String>(){
                    {
                        this.put("collectionId", sourceCollectionId);
                        this.put("projectId", sourceProjectId);
                        this.put("repositoryId", sourceRepositoryId);
                    }
                });
            }
        };
        String r = RestClient.send(RequestMethod.POST, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git/repositories", repositoryName, "forkSyncRequests", "7.1-preview.1", null, b, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, GitForkSyncRequest.class);
    }

    @Override
    public GitForkSyncRequest createForkSyncRequest(String repositoryName, final String collectionId, final String projectId, final String repositoryId, final String sourceRef, final String targetRef, final Boolean includeLinks) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("includeLinks", includeLinks);
            }
        };
        HashMap<String, Object> b = new HashMap<String, Object>(){
            {
                this.put("source", new HashMap<String, String>(){
                    {
                        this.put("collectionId", collectionId);
                        this.put("projectId", projectId);
                        this.put("repositoryId", repositoryId);
                    }
                });
                this.put("sourceToTargetRefs", new HashMap<String, String>(){
                    {
                        this.put("sourceRef", sourceRef);
                        this.put("targetRef", targetRef);
                    }
                });
            }
        };
        String r = RestClient.send(RequestMethod.POST, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git/repositories", repositoryName, "forkSyncRequests", "7.1-preview.1", q, b, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, GitForkSyncRequest.class);
    }

    @Override
    public GitForkSyncRequest getForkSyncRequest(String repositoryName, int OperationId, final boolean includeLinks) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("includeLinks", includeLinks);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git/repositories", repositoryName, "forkSyncRequests/" + OperationId, "7.1-preview.1", q, (Object)CustomHeader.JSON_CONTENT_TYPE, null);
        return this.MAPPER.mapJsonResponse(r, GitForkSyncRequest.class);
    }

    @Override
    public GitForkSyncRequests getForkSyncRequests(String repositoryName, final boolean includeLinks, final boolean includeAbandoned) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("includeLinks", includeLinks);
                this.put("includeAbandoned", includeAbandoned);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git/repositories", repositoryName, "forkSyncRequests", "7.1-preview.1", q, null, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, GitForkSyncRequests.class);
    }

    @Override
    public GitRepositoryRefs getForks(String repositoryName, String collectionId, final boolean includeLinks) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("includeLinks", includeLinks);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git/repositories", repositoryName, "forks/" + collectionId, "7.1-preview.1", q, null, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, GitRepositoryRefs.class);
    }

    @Override
    public GitPush createPush(String repositoryId, GitPush gitPush) throws AzDException {
        String r = RestClient.send(RequestMethod.POST, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git/repositories", repositoryId, "pushes", "7.1-preview.2", null, gitPush, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, GitPush.class);
    }

    @Override
    public GitPush getPush(String repositoryId, int pushId) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git/repositories", repositoryId, "pushes/" + pushId, "7.1-preview.2", null, null, null);
        return this.MAPPER.mapJsonResponse(r, GitPush.class);
    }

    @Override
    public GitPush getPush(String repositoryId, int pushId, int includeCommits) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git/repositories", repositoryId, "pushes/" + pushId, "7.1-preview.2", Map.of("includeCommits", includeCommits), null, null);
        return this.MAPPER.mapJsonResponse(r, GitPush.class);
    }

    @Override
    public GitPush getPush(String repositoryId, int pushId, boolean includeRefUpdates) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git/repositories", repositoryId, "pushes/" + pushId, "7.1-preview.2", Map.of("includeRefUpdates", includeRefUpdates), null, null);
        return this.MAPPER.mapJsonResponse(r, GitPush.class);
    }

    @Override
    public GitPush getPush(String repositoryId, int pushId, final int includeCommits, final boolean includeRefUpdates) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("includeCommits", includeCommits);
                this.put("includeRefUpdates", includeRefUpdates);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git/repositories", repositoryId, "pushes/" + pushId, "7.1-preview.2", q, null, null);
        return this.MAPPER.mapJsonResponse(r, GitPush.class);
    }

    @Override
    public GitPushes getPushes(String repositoryId) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", this.CONNECTION.getProject(), "git/repositories", repositoryId, "pushes", "7.1-preview.2", null, null, null);
        return this.MAPPER.mapJsonResponse(r, GitPushes.class);
    }

    @Override
    public GitRepository createForkRepository(final String repositoryName, final String projectId, final String parentProjectId, final String parentRepositoryId) throws AzDException {
        HashMap<String, Object> b = new HashMap<String, Object>(){
            {
                this.put("name", repositoryName);
                this.put("project", new HashMap<String, String>(){
                    {
                        this.put("id", projectId);
                    }
                });
                this.put("parentRepository", new HashMap<String, Object>(){
                    {
                        this.put("id", parentRepositoryId);
                        this.put("project", new HashMap<String, String>(){
                            {
                                this.put("id", parentProjectId);
                            }
                        });
                    }
                });
            }
        };
        String r = RestClient.send(RequestMethod.POST, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", projectId, "git", null, "repositories", "7.1-preview.1", null, b, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, GitRepository.class);
    }

    @Override
    public GitRepository createForkRepository(final String repositoryName, final String projectId, final String parentProjectId, final String parentRepositoryId, final String sourceBranch) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("sourceRef", "refs/heads/" + sourceBranch);
            }
        };
        HashMap<String, Object> b = new HashMap<String, Object>(){
            {
                this.put("name", repositoryName);
                this.put("project", new HashMap<String, String>(){
                    {
                        this.put("id", projectId);
                    }
                });
                this.put("parentRepository", new HashMap<String, Object>(){
                    {
                        this.put("id", parentRepositoryId);
                        this.put("project", new HashMap<String, String>(){
                            {
                                this.put("id", parentProjectId);
                            }
                        });
                    }
                });
            }
        };
        String r = RestClient.send(RequestMethod.POST, this.CONNECTION, "4e080c62-fa21-4fbc-8fef-2a10a2b38049", projectId, "git", null, "repositories", "7.1-preview.1", q, b, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, GitRepository.class);
    }

    @Override
    public GitRepository createForkRepositoryWithComplete(String repositoryName, String projectId, String parentProjectId, String parentRepositoryId, String sourceBranch, int checkTimes) throws AzDException {
        GitRepository gitRepository = this.createForkRepository(repositoryName, projectId, parentProjectId, parentRepositoryId, sourceBranch);
        GitForkSyncRequest gitForkSyncRequest = this.getForkSyncRequests(repositoryName, true, true).getForkSyncRequest().get(0);
        int operationId = gitForkSyncRequest.getOperationId();
        for (int i = 0; i < checkTimes; ++i) {
            gitForkSyncRequest = this.getForkSyncRequest(repositoryName, operationId, true);
            if (gitForkSyncRequest.getStatus() == GitAsyncOperationStatus.COMPLETED) {
                return gitRepository;
            }
            try {
                TimeUnit.MILLISECONDS.sleep(500L);
                continue;
            }
            catch (InterruptedException e) {
                throw new AzDException("Error while waiting for fork sync request to complete");
            }
        }
        throw new AzDException("Fork sync request did not complete in time : " + String.valueOf((Object)gitForkSyncRequest.getStatus()));
    }
}

