/*
 * Decompiled with CFR 0.152.
 */
package org.azd.oauth;

import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.LinkedHashMap;
import java.util.concurrent.CompletableFuture;
import org.azd.enums.CustomHeader;
import org.azd.enums.Instance;
import org.azd.exceptions.AzDException;
import org.azd.helpers.JsonMapper;
import org.azd.helpers.URLHelper;
import org.azd.oauth.types.AuthorizedToken;
import org.azd.utils.RestClientProvider;

public class OAuthApi {
    private static final JsonMapper MAPPER = new JsonMapper();
    private static final String VSTS_BASE_URL = Instance.ACCOUNT_INSTANCE.getInstance();

    public static String getAuthorizationEndpoint(String clientId, final String state, final String scope, final String redirectUrl) {
        LinkedHashMap<String, Object> queryString = new LinkedHashMap<String, Object>(){
            {
                this.put("response_type", "Assertion");
                this.put("state", state);
                this.put("scope", URLHelper.encodeSpace(scope));
                this.put("redirect_uri", URLHelper.encodeSpecialChars(redirectUrl));
            }
        };
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(VSTS_BASE_URL);
        stringBuilder.append("/oauth2/authorize?");
        stringBuilder.append("client_id=");
        stringBuilder.append(clientId);
        for (String key : queryString.keySet()) {
            stringBuilder.append(OAuthApi.getQueryString(key, queryString.get(key)));
        }
        return stringBuilder.toString();
    }

    private static String getQueryString(String key, Object value) {
        return "&" + key + "=" + String.valueOf(value);
    }

    public static AuthorizedToken getAccessToken(String appSecret, String authCode, String callbackUrl) throws AzDException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(VSTS_BASE_URL);
        stringBuilder.append("/oauth2/token");
        String body = "client_assertion_type=urn:ietf:params:oauth:client-assertion-type:jwt-bearer&client_assertion=" + URLHelper.encodeSpecialChars(appSecret) + "&grant_type=urn:ietf:params:oauth:grant-type:jwt-bearer&assertion=" + URLHelper.encodeSpecialChars(authCode) + "&redirect_uri=" + callbackUrl;
        String r = OAuthApi.getResponse(stringBuilder.toString(), body);
        AuthorizedToken res = MAPPER.mapJsonResponse(r, AuthorizedToken.class);
        res.setReceivedTimestamp(System.currentTimeMillis());
        return res;
    }

    public static AuthorizedToken getRefreshToken(String appSecret, String authCode, String callbackUrl) throws AzDException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(VSTS_BASE_URL);
        stringBuilder.append("/oauth2/token");
        String body = "client_assertion_type=urn:ietf:params:oauth:client-assertion-type:jwt-bearer&client_assertion=" + URLHelper.encodeSpecialChars(appSecret) + "&grant_type=refresh_token&assertion=" + URLHelper.encodeSpecialChars(authCode) + "&redirect_uri=" + callbackUrl;
        String r = OAuthApi.getResponse(stringBuilder.toString(), body);
        AuthorizedToken res = MAPPER.mapJsonResponse(r, AuthorizedToken.class);
        res.setReceivedTimestamp(System.currentTimeMillis());
        return res;
    }

    public static boolean hasTokenExpired(AuthorizedToken authorizedToken) {
        return authorizedToken.getReceivedTimestamp() < 1629897097271L || authorizedToken.getReceivedTimestamp() + (long)(authorizedToken.getExpiresIn() * 1000) < System.currentTimeMillis();
    }

    private static String getResponse(String requestUrl, String body) throws AzDException {
        return (String)((CompletableFuture)RestClientProvider.post(requestUrl, null, HttpRequest.BodyPublishers.ofString(body), HttpResponse.BodyHandlers.ofString(), CustomHeader.URL_ENCODED, false).thenApplyAsync(HttpResponse::body)).join();
    }
}

