/*
 * Decompiled with CFR 0.152.
 */
package org.azd.pipelines;

import java.util.HashMap;
import java.util.Map;
import org.azd.connection.Connection;
import org.azd.enums.CustomHeader;
import org.azd.enums.PipelinesExpandOptions;
import org.azd.enums.RequestMethod;
import org.azd.exceptions.AzDException;
import org.azd.git.GitApi;
import org.azd.helpers.JsonMapper;
import org.azd.interfaces.PipelinesDetails;
import org.azd.pipelines.types.LogCollection;
import org.azd.pipelines.types.Pipeline;
import org.azd.pipelines.types.PipelineLog;
import org.azd.pipelines.types.PipelineRun;
import org.azd.pipelines.types.PipelineRuns;
import org.azd.pipelines.types.Pipelines;
import org.azd.pipelines.types.PipelinesArtifact;
import org.azd.pipelines.types.PreviewRun;
import org.azd.utils.AzDAsyncApi;
import org.azd.utils.RestClient;

public class PipelinesApi
extends AzDAsyncApi<PipelinesApi>
implements PipelinesDetails {
    private final Connection CONNECTION;
    private final JsonMapper MAPPER = new JsonMapper();
    private final String AREA = "pipelines";
    private final String PIPELINES = "2e0bf237-8973-4ec9-a581-9c3d679d1776";

    public PipelinesApi(Connection connection) {
        this.CONNECTION = connection;
    }

    @Override
    public PipelinesArtifact getArtifacts(int pipelineId, int runId, final String artifactName) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("artifactName", artifactName);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "2e0bf237-8973-4ec9-a581-9c3d679d1776", this.CONNECTION.getProject(), "pipelines", Integer.toString(pipelineId), "runs/" + runId + "/artifacts", "7.1-preview.1", q, null, null);
        return this.MAPPER.mapJsonResponse(r, PipelinesArtifact.class);
    }

    @Override
    public PipelinesArtifact getArtifacts(int pipelineId, int runId, final String artifactName, final PipelinesExpandOptions expandOptions) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("artifactName", artifactName);
                this.put("$expand", expandOptions.toString().toLowerCase());
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "2e0bf237-8973-4ec9-a581-9c3d679d1776", this.CONNECTION.getProject(), "pipelines", Integer.toString(pipelineId), "runs/" + runId + "/artifacts", "7.1-preview.1", q, null, null);
        return this.MAPPER.mapJsonResponse(r, PipelinesArtifact.class);
    }

    @Override
    public PipelineLog getPipelineLog(int pipelineId, int runId, int logId) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "2e0bf237-8973-4ec9-a581-9c3d679d1776", this.CONNECTION.getProject(), "pipelines", Integer.toString(pipelineId), "runs/" + runId + "/logs/" + logId, "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, PipelineLog.class);
    }

    @Override
    public PipelineLog getPipelineLog(int pipelineId, int runId, int logId, final PipelinesExpandOptions expandOptions) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("$expand", expandOptions.toString().toLowerCase());
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "2e0bf237-8973-4ec9-a581-9c3d679d1776", this.CONNECTION.getProject(), "pipelines", Integer.toString(pipelineId), "runs/" + runId + "/logs/" + logId, "7.1-preview.1", q, null, null);
        return this.MAPPER.mapJsonResponse(r, PipelineLog.class);
    }

    @Override
    public LogCollection getPipelineLogs(int pipelineId, int runId) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "2e0bf237-8973-4ec9-a581-9c3d679d1776", this.CONNECTION.getProject(), "pipelines", Integer.toString(pipelineId), "runs/" + runId + "/logs", "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, LogCollection.class);
    }

    @Override
    public LogCollection getPipelineLogs(int pipelineId, int runId, final PipelinesExpandOptions expandOptions) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("$expand", expandOptions.toString().toLowerCase());
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "2e0bf237-8973-4ec9-a581-9c3d679d1776", this.CONNECTION.getProject(), "pipelines", Integer.toString(pipelineId), "runs/" + runId + "/logs", "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, LogCollection.class);
    }

    @Override
    public Pipeline createPipeline(final String name, final String folder, final String pathOfYamlFile, final String repositoryId, final String repositoryName) throws AzDException {
        GitApi git = new GitApi(this.CONNECTION);
        HashMap<String, Object> body = new HashMap<String, Object>(){
            {
                this.put("name", name);
                this.put("folder", folder);
                this.put("configuration", new HashMap<Object, Object>(){
                    {
                        this.put("type", "yaml");
                        this.put("path", pathOfYamlFile);
                        this.put("repository", new HashMap<Object, Object>(){
                            {
                                this.put("id", repositoryId);
                                this.put("name", repositoryName);
                                this.put("type", "azureReposGit");
                            }
                        });
                    }
                });
            }
        };
        String r = RestClient.send(RequestMethod.POST, this.CONNECTION, "2e0bf237-8973-4ec9-a581-9c3d679d1776", this.CONNECTION.getProject(), "pipelines", null, null, "7.1-preview.1", null, body, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, Pipeline.class);
    }

    @Override
    public Pipeline getPipeline(int pipelineId) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "2e0bf237-8973-4ec9-a581-9c3d679d1776", this.CONNECTION.getProject(), "pipelines", Integer.toString(pipelineId), null, "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, Pipeline.class);
    }

    @Override
    public Pipeline getPipeline(int pipelineId, final String pipelineVersion) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("pipelineVersion", pipelineVersion);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "2e0bf237-8973-4ec9-a581-9c3d679d1776", this.CONNECTION.getProject(), "pipelines", Integer.toString(pipelineId), null, "7.1-preview.1", q, null, null);
        return this.MAPPER.mapJsonResponse(r, Pipeline.class);
    }

    @Override
    public Pipelines getPipelines() throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "2e0bf237-8973-4ec9-a581-9c3d679d1776", this.CONNECTION.getProject(), "pipelines", null, null, "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, Pipelines.class);
    }

    @Override
    public PreviewRun previewPipeline(int pipelineId, final boolean previewRun) throws AzDException {
        HashMap<String, Object> body = new HashMap<String, Object>(){
            {
                this.put("previewRun", previewRun);
            }
        };
        String r = RestClient.send(RequestMethod.POST, this.CONNECTION, "2e0bf237-8973-4ec9-a581-9c3d679d1776", this.CONNECTION.getProject(), "pipelines", Integer.toString(pipelineId), "preview", "7.1-preview.1", null, body, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, PreviewRun.class);
    }

    @Override
    public PreviewRun previewPipeline(int pipelineId, final boolean previewRun, final String yamlOverride) throws AzDException {
        HashMap<String, Object> body = new HashMap<String, Object>(){
            {
                this.put("previewRun", previewRun);
                this.put("yamlOverride", yamlOverride);
            }
        };
        String r = RestClient.send(RequestMethod.POST, this.CONNECTION, "2e0bf237-8973-4ec9-a581-9c3d679d1776", this.CONNECTION.getProject(), "pipelines", Integer.toString(pipelineId), "preview", "7.1-preview.1", null, body, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, PreviewRun.class);
    }

    @Override
    public PipelineRun getPipelineRun(int pipelineId, int runId) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "2e0bf237-8973-4ec9-a581-9c3d679d1776", this.CONNECTION.getProject(), "pipelines", Integer.toString(pipelineId), "runs/" + runId, "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, PipelineRun.class);
    }

    @Override
    public PipelineRuns getPipelineRuns(int pipelineId) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "2e0bf237-8973-4ec9-a581-9c3d679d1776", this.CONNECTION.getProject(), "pipelines", Integer.toString(pipelineId), "runs", "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, PipelineRuns.class);
    }

    @Override
    public PipelineRun runPipeline(int pipelineId) throws AzDException {
        HashMap<String, Object> body = new HashMap<String, Object>(){
            {
                this.put("resources", "{}");
            }
        };
        String r = RestClient.send(RequestMethod.POST, this.CONNECTION, "2e0bf237-8973-4ec9-a581-9c3d679d1776", this.CONNECTION.getProject(), "pipelines", Integer.toString(pipelineId), "runs", "7.1-preview.1", null, body, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, PipelineRun.class);
    }

    @Override
    public PipelineRun runPipeline(int pipelineId, Map pipelineRunParameters) throws AzDException {
        String r = RestClient.send(RequestMethod.POST, this.CONNECTION, "2e0bf237-8973-4ec9-a581-9c3d679d1776", this.CONNECTION.getProject(), "pipelines", Integer.toString(pipelineId), "runs", "7.1-preview.1", null, pipelineRunParameters, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, PipelineRun.class);
    }
}

