/*
 * Decompiled with CFR 0.152.
 */
package org.azd.release;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.azd.connection.Connection;
import org.azd.distributedtask.types.VariableGroupMap;
import org.azd.enums.CustomHeader;
import org.azd.enums.ManualInterventionStatus;
import org.azd.enums.ReleaseApprovalFilters;
import org.azd.enums.ReleaseApprovalStatus;
import org.azd.enums.ReleaseApprovalType;
import org.azd.enums.ReleaseDefinitionExpands;
import org.azd.enums.ReleaseDefinitionQueryOrder;
import org.azd.enums.ReleaseEnvironmentStatus;
import org.azd.enums.ReleaseExpands;
import org.azd.enums.ReleaseQueryOrder;
import org.azd.enums.ReleaseStatus;
import org.azd.enums.RequestMethod;
import org.azd.enums.SingleReleaseExpands;
import org.azd.exceptions.AzDException;
import org.azd.helpers.JsonMapper;
import org.azd.interfaces.ReleaseDetails;
import org.azd.release.types.ManualIntervention;
import org.azd.release.types.ManualInterventions;
import org.azd.release.types.Release;
import org.azd.release.types.ReleaseApproval;
import org.azd.release.types.ReleaseApprovals;
import org.azd.release.types.ReleaseDefinition;
import org.azd.release.types.ReleaseDefinitionRevisions;
import org.azd.release.types.ReleaseDefinitions;
import org.azd.release.types.ReleaseEnvironment;
import org.azd.release.types.Releases;
import org.azd.utils.AzDAsyncApi;
import org.azd.utils.RestClient;

public class ReleaseApi
extends AzDAsyncApi<ReleaseApi>
implements ReleaseDetails {
    private final Connection CONNECTION;
    private final JsonMapper MAPPER = new JsonMapper();
    private final String AREA = "release/releases";
    private final String RELEASE = "efc2f575-36ef-48e9-b672-0c6fb4a48ac5";

    public ReleaseApi(Connection connection) {
        this.CONNECTION = connection;
    }

    @Override
    public Release createRelease(final int releaseDefinitionId, final String description, final String artifactAlias, final String artifactId, final String artifactName, boolean isDraft) throws AzDException {
        LinkedHashMap<String, Object> artifacts = new LinkedHashMap<String, Object>(){
            {
                this.put("alias", artifactAlias);
                this.put("instanceReference", new LinkedHashMap<String, Object>(){
                    {
                        this.put("id", artifactId);
                        this.put("name", artifactName);
                    }
                });
            }
        };
        LinkedHashMap<String, Object> h = new LinkedHashMap<String, Object>(artifacts, isDraft){
            final /* synthetic */ 1 val$artifacts;
            final /* synthetic */ boolean val$isDraft;
            {
                this.val$artifacts = var4_4;
                this.val$isDraft = bl;
                this.put("definitionId", Integer.toString(releaseDefinitionId));
                this.put("description", description);
                this.put("artifacts", List.of(this.val$artifacts));
                this.put("isDraft", this.val$isDraft);
                this.put("reason", "none");
                this.put("manualEnvironments", null);
            }
        };
        String r = RestClient.send(RequestMethod.POST, this.CONNECTION, "efc2f575-36ef-48e9-b672-0c6fb4a48ac5", this.CONNECTION.getProject(), "release/releases", null, null, "7.1-preview.8", null, h, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, Release.class);
    }

    @Override
    public Release getRelease(int releaseId) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "efc2f575-36ef-48e9-b672-0c6fb4a48ac5", this.CONNECTION.getProject(), "release/releases", Integer.toString(releaseId), null, "7.1-preview.8", null, null, null);
        return this.MAPPER.mapJsonResponse(r, Release.class);
    }

    @Override
    public Release getRelease(int releaseId, final SingleReleaseExpands expand) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("$expand", expand.toString().toLowerCase());
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "efc2f575-36ef-48e9-b672-0c6fb4a48ac5", this.CONNECTION.getProject(), "release/releases", Integer.toString(releaseId), null, "7.1-preview.8", q, null, null);
        return this.MAPPER.mapJsonResponse(r, Release.class);
    }

    @Override
    public Release getRelease(int releaseId, final SingleReleaseExpands expand, final ReleaseApprovalFilters approvalFilters, final String[] propertyFilters, final int topGateRecords) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("approvalFilters", approvalFilters);
                this.put("propertyFilters", String.join((CharSequence)",", propertyFilters));
                this.put("$expand", expand.toString().toLowerCase());
                this.put("$topGateRecords", topGateRecords);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "efc2f575-36ef-48e9-b672-0c6fb4a48ac5", this.CONNECTION.getProject(), "release/releases", Integer.toString(releaseId), null, "7.1-preview.8", q, null, null);
        return this.MAPPER.mapJsonResponse(r, Release.class);
    }

    @Override
    public ReleaseEnvironment getReleaseEnvironment(int releaseId, int environmentId) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "efc2f575-36ef-48e9-b672-0c6fb4a48ac5", this.CONNECTION.getProject(), "release/releases", Integer.toString(releaseId), "environments/" + environmentId, "7.1-preview.7", null, null, null);
        return this.MAPPER.mapJsonResponse(r, ReleaseEnvironment.class);
    }

    @Override
    public ReleaseEnvironment getReleaseEnvironment(int releaseId, int environmentId, final SingleReleaseExpands expand) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("$expand", expand.toString().toLowerCase());
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "efc2f575-36ef-48e9-b672-0c6fb4a48ac5", this.CONNECTION.getProject(), "release/releases", Integer.toString(releaseId), "environments/" + environmentId, "7.1-preview.7", q, null, null);
        return this.MAPPER.mapJsonResponse(r, ReleaseEnvironment.class);
    }

    @Override
    public Releases getReleases() throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "efc2f575-36ef-48e9-b672-0c6fb4a48ac5", this.CONNECTION.getProject(), "release/releases", null, null, "7.1-preview.8", null, null, null);
        return this.MAPPER.mapJsonResponse(r, Releases.class);
    }

    @Override
    public Releases getReleases(final ReleaseExpands expand) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("$expand", expand.toString().toLowerCase());
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "efc2f575-36ef-48e9-b672-0c6fb4a48ac5", this.CONNECTION.getProject(), "release/releases", null, null, "7.1-preview.8", q, null, null);
        return this.MAPPER.mapJsonResponse(r, Releases.class);
    }

    @Override
    public Releases getReleases(final int definitionId) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("definitionId", definitionId);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "efc2f575-36ef-48e9-b672-0c6fb4a48ac5", this.CONNECTION.getProject(), "release/releases", null, null, "7.1-preview.8", q, null, null);
        return this.MAPPER.mapJsonResponse(r, Releases.class);
    }

    @Override
    public Releases getReleases(final ReleaseExpands expand, final int top) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("$expand", expand.toString().toLowerCase());
                this.put("$top", top);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "efc2f575-36ef-48e9-b672-0c6fb4a48ac5", this.CONNECTION.getProject(), "release/releases", null, null, "7.1-preview.8", q, null, null);
        return this.MAPPER.mapJsonResponse(r, Releases.class);
    }

    @Override
    public Releases getReleases(final String[] releaseIdFilter) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("releaseIdFilter", String.join((CharSequence)",", releaseIdFilter));
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "efc2f575-36ef-48e9-b672-0c6fb4a48ac5", this.CONNECTION.getProject(), "release/releases", null, null, "7.1-preview.8", q, null, null);
        return this.MAPPER.mapJsonResponse(r, Releases.class);
    }

    @Override
    public Releases getReleases(final ReleaseExpands expand, final String artifactVersionId) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("$expand", expand.toString().toLowerCase());
                this.put("artifactVersionId", artifactVersionId);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "efc2f575-36ef-48e9-b672-0c6fb4a48ac5", this.CONNECTION.getProject(), "release/releases", null, null, "7.1-preview.8", q, null, null);
        return this.MAPPER.mapJsonResponse(r, Releases.class);
    }

    @Override
    public Releases getReleases(final ReleaseExpands expand, final int top, final String artifactTypeId, final String artifactVersionId, final int continuationToken, final String createdBy, final int definitionEnvironmentId, final int definitionId, final int environmentStatusFilter, final boolean isDeleted, final String maxCreatedTime, final String minCreatedTime, final String path, final String[] propertyFilters, final ReleaseQueryOrder queryOrder, final String[] releaseIdFilter, final String searchText, final String sourceBranchFilter, final String sourceId, final ReleaseStatus statusFilter, final String[] tagFilter) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("definitionId", definitionId);
                this.put("definitionEnvironmentId", definitionEnvironmentId);
                this.put("searchText", searchText);
                this.put("createdBy", createdBy);
                this.put("statusFilter", statusFilter);
                this.put("environmentStatusFilter", environmentStatusFilter);
                this.put("minCreatedTime", minCreatedTime);
                this.put("maxCreatedTime", maxCreatedTime);
                this.put("queryOrder", queryOrder.toString().toLowerCase());
                this.put("$top", top);
                this.put("continuationToken", continuationToken);
                this.put("artifactTypeId", artifactTypeId);
                this.put("sourceId", sourceId);
                this.put("artifactVersionId", artifactVersionId);
                this.put("sourceBranchFilter", sourceBranchFilter);
                this.put("isDeleted", isDeleted);
                this.put("$expand", expand.toString().toLowerCase());
                this.put("tagFilter", String.join((CharSequence)",", tagFilter));
                this.put("propertyFilters", String.join((CharSequence)",", propertyFilters));
                this.put("path", path);
                this.put("releaseIdFilter", String.join((CharSequence)",", releaseIdFilter));
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "efc2f575-36ef-48e9-b672-0c6fb4a48ac5", this.CONNECTION.getProject(), "release/releases", null, null, "7.1-preview.8", q, null, null);
        return this.MAPPER.mapJsonResponse(r, Releases.class);
    }

    @Override
    public ReleaseDefinition createReleaseDefinition(String releaseDefinitionParameters) throws AzDException {
        HashMap body = this.MAPPER.mapJsonResponse(releaseDefinitionParameters, HashMap.class);
        String r = RestClient.send(RequestMethod.POST, this.CONNECTION, "efc2f575-36ef-48e9-b672-0c6fb4a48ac5", this.CONNECTION.getProject(), "release/releases".replace("releases", "definitions"), null, null, "7.1-preview.4", null, body, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, ReleaseDefinition.class);
    }

    @Override
    public Void deleteReleaseDefinition(int definitionId) throws AzDException {
        String r = RestClient.send(RequestMethod.DELETE, this.CONNECTION, "efc2f575-36ef-48e9-b672-0c6fb4a48ac5", this.CONNECTION.getProject(), "release/releases".replace("releases", "definitions"), Integer.toString(definitionId), null, "7.1-preview.4", null, null, null);
        if (!r.isEmpty()) {
            this.MAPPER.mapJsonResponse(r, Map.class);
        }
        return null;
    }

    @Override
    public Void deleteReleaseDefinition(int definitionId, final String comment, final boolean forceDelete) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("comment", comment);
                this.put("forceDelete", forceDelete);
            }
        };
        String r = RestClient.send(RequestMethod.DELETE, this.CONNECTION, "efc2f575-36ef-48e9-b672-0c6fb4a48ac5", this.CONNECTION.getProject(), "release/releases".replace("releases", "definitions"), Integer.toString(definitionId), null, "7.1-preview.4", q, null, null);
        if (!r.isEmpty()) {
            this.MAPPER.mapJsonResponse(r, Map.class);
        }
        return null;
    }

    @Override
    public ReleaseDefinition getReleaseDefinition(int definitionId) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "efc2f575-36ef-48e9-b672-0c6fb4a48ac5", this.CONNECTION.getProject(), "release/releases".replace("releases", "definitions"), Integer.toString(definitionId), null, "7.1-preview.4", null, null, null);
        return this.MAPPER.mapJsonResponse(r, ReleaseDefinition.class);
    }

    @Override
    public ReleaseDefinitionRevisions getReleaseDefinitionHistory(int definitionId) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "efc2f575-36ef-48e9-b672-0c6fb4a48ac5", this.CONNECTION.getProject(), "release/releases".replace("releases", "definitions"), Integer.toString(definitionId), "revisions", "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, ReleaseDefinitionRevisions.class);
    }

    @Override
    public ReleaseDefinitions getReleaseDefinitions() throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "efc2f575-36ef-48e9-b672-0c6fb4a48ac5", this.CONNECTION.getProject(), "release/releases".replace("releases", "definitions"), null, null, "7.1-preview.4", null, null, null);
        return this.MAPPER.mapJsonResponse(r, ReleaseDefinitions.class);
    }

    @Override
    public ReleaseDefinitions getReleaseDefinitions(final ReleaseDefinitionExpands expands) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("$expand", expands.name());
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "efc2f575-36ef-48e9-b672-0c6fb4a48ac5", this.CONNECTION.getProject(), "release/releases".replace("releases", "definitions"), null, null, "7.1-preview.4", q, null, null);
        return this.MAPPER.mapJsonResponse(r, ReleaseDefinitions.class);
    }

    @Override
    public ReleaseDefinitions getReleaseDefinitions(final int top) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("$top", top);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "efc2f575-36ef-48e9-b672-0c6fb4a48ac5", this.CONNECTION.getProject(), "release/releases".replace("releases", "definitions"), null, null, "7.1-preview.4", q, null, null);
        return this.MAPPER.mapJsonResponse(r, ReleaseDefinitions.class);
    }

    @Override
    public ReleaseDefinitions getReleaseDefinitions(final String artifactSourceId) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("artifactSourceId", artifactSourceId);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "efc2f575-36ef-48e9-b672-0c6fb4a48ac5", this.CONNECTION.getProject(), "release/releases".replace("releases", "definitions"), null, null, "7.1-preview.4", q, null, null);
        return this.MAPPER.mapJsonResponse(r, ReleaseDefinitions.class);
    }

    @Override
    public ReleaseDefinitions getReleaseDefinitions(final int[] definitionIdFilter) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("definitionIdFilter", ReleaseApi.this.intArrayToString(definitionIdFilter));
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "efc2f575-36ef-48e9-b672-0c6fb4a48ac5", this.CONNECTION.getProject(), "release/releases".replace("releases", "definitions"), null, null, "7.1-preview.4", q, null, null);
        return this.MAPPER.mapJsonResponse(r, ReleaseDefinitions.class);
    }

    @Override
    public ReleaseDefinitions getReleaseDefinitions(final ReleaseDefinitionExpands expands, final int top, final String artifactSourceId, final String artifactType, final String continuationToken, final int[] definitionIdFilter, final boolean isDeleted, final boolean isExactNameMatch, final String path, final String[] propertyFilters, final ReleaseDefinitionQueryOrder queryOrder, final String searchText, final boolean searchTextContainsFolderName, final String[] tagFilter) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("$expand", expands.name());
                this.put("$top", top);
                this.put("artifactSourceId", artifactSourceId);
                this.put("artifactType", artifactType);
                this.put("continuationToken", continuationToken);
                this.put("definitionIdFilter", ReleaseApi.this.intArrayToString(definitionIdFilter));
                this.put("isDeleted", isDeleted);
                this.put("isExactNameMatch", isExactNameMatch);
                this.put("path", path);
                this.put("propertyFilters", String.join((CharSequence)",", propertyFilters));
                this.put("queryOrder", queryOrder.name());
                this.put("searchText", searchText);
                this.put("searchTextContainsFolderName", searchTextContainsFolderName);
                this.put("tagFilter", String.join((CharSequence)",", tagFilter));
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "efc2f575-36ef-48e9-b672-0c6fb4a48ac5", this.CONNECTION.getProject(), "release/releases".replace("releases", "definitions"), null, null, "7.1-preview.4", q, null, null);
        return this.MAPPER.mapJsonResponse(r, ReleaseDefinitions.class);
    }

    @Override
    public ReleaseDefinition updateReleaseDefinition(ReleaseDefinition releaseDefinition) throws AzDException {
        String r = RestClient.send(RequestMethod.PUT, this.CONNECTION, "efc2f575-36ef-48e9-b672-0c6fb4a48ac5", this.CONNECTION.getProject(), "release/releases".replace("releases", "definitions"), null, null, "7.1-preview.4", null, releaseDefinition, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, ReleaseDefinition.class);
    }

    @Override
    public Void deleteRelease(int releaseId) throws AzDException {
        String r = RestClient.send(RequestMethod.DELETE, this.CONNECTION, "efc2f575-36ef-48e9-b672-0c6fb4a48ac5", this.CONNECTION.getProject(), "release/releases", Integer.toString(releaseId), null, "7.1-preview.8", null, null, null);
        if (!r.isEmpty()) {
            this.MAPPER.mapJsonResponse(r, Map.class);
        }
        return null;
    }

    @Override
    public Release updateRelease(int releaseId, Release release) throws AzDException {
        String r = RestClient.send(RequestMethod.PUT, this.CONNECTION, "efc2f575-36ef-48e9-b672-0c6fb4a48ac5", this.CONNECTION.getProject(), "release/releases", Integer.toString(releaseId), null, "7.1-preview.8", null, release, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, Release.class);
    }

    @Override
    public ReleaseEnvironment updateReleaseEnvironment(int releaseId, int environmentId, final String comment, final String scheduledDeploymentTime, final ReleaseEnvironmentStatus status, VariableGroupMap variables) throws AzDException {
        HashMap<String, Object> b = new HashMap<String, Object>(){
            {
                this.put("comment", comment);
                this.put("scheduledDeploymentTime", scheduledDeploymentTime);
                this.put("status", status.toString().toLowerCase());
            }
        };
        if (variables != null) {
            b.put("variables", variables.get());
        }
        String r = RestClient.send(RequestMethod.PATCH, this.CONNECTION, "efc2f575-36ef-48e9-b672-0c6fb4a48ac5", this.CONNECTION.getProject(), "release/releases", Integer.toString(releaseId), "environments/" + environmentId, "7.1-preview.7", null, b, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, ReleaseEnvironment.class);
    }

    @Override
    public Release updateReleaseResource(int releaseId, final String comment, final boolean keepForever, final String[] manualEnvironments, final ReleaseStatus status, final String name) throws AzDException {
        HashMap<String, Object> b = new HashMap<String, Object>(){
            {
                this.put("comment", comment);
                this.put("keepForever", keepForever);
                this.put("status", status.toString().toLowerCase());
                this.put("manualEnvironments", manualEnvironments);
                this.put("name", name);
            }
        };
        String r = RestClient.send(RequestMethod.PATCH, this.CONNECTION, "efc2f575-36ef-48e9-b672-0c6fb4a48ac5", this.CONNECTION.getProject(), "release/releases", Integer.toString(releaseId), null, "7.1-preview.8", null, b, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, Release.class);
    }

    @Override
    public ReleaseEnvironment queueRelease(int releaseId, String environmentName) throws AzDException {
        Release release = this.getRelease(releaseId);
        boolean environment = release.getEnvironments().stream().anyMatch(x -> x.getName().equals(environmentName));
        if (environment) {
            int environmentId = release.getEnvironments().stream().filter(x -> x.getName().equals(environmentName)).findFirst().get().getId();
            return this.updateReleaseEnvironment(releaseId, environmentId, null, null, ReleaseEnvironmentStatus.INPROGRESS, null);
        }
        throw new AzDException("NoSuchElementException", "Given environment name '" + environmentName + "' doesn't exist.");
    }

    @Override
    public Release abandonRelease(int releaseId) throws AzDException {
        return this.updateReleaseResource(releaseId, null, false, null, ReleaseStatus.ABANDONED, null);
    }

    @Override
    public ReleaseApprovals getReleaseApprovals() throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "efc2f575-36ef-48e9-b672-0c6fb4a48ac5", this.CONNECTION.getProject(), "release/releases".replace("releases", "approvals"), null, null, "7.1-preview.3", null, null, null);
        return this.MAPPER.mapJsonResponse(r, ReleaseApprovals.class);
    }

    @Override
    public ReleaseApprovals getReleaseApprovals(final int[] releaseIdsFilter) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("releaseIdsFilter", String.join((CharSequence)",", ReleaseApi.this.intArrayToString(releaseIdsFilter)));
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "efc2f575-36ef-48e9-b672-0c6fb4a48ac5", this.CONNECTION.getProject(), "release/releases".replace("releases", "approvals"), null, null, "7.1-preview.3", q, null, null);
        return this.MAPPER.mapJsonResponse(r, ReleaseApprovals.class);
    }

    @Override
    public ReleaseApprovals getReleaseApprovals(final String assignedToFilter, final int continuationToken, final boolean includeMyGroupApprovals, final ReleaseQueryOrder queryOrder, final int[] releaseIdsFilter, final ReleaseApprovalStatus statusFilter, final int top, final ReleaseApprovalType typeFilter) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("assignedToFilter", assignedToFilter);
                this.put("continuationToken", continuationToken);
                this.put("includeMyGroupApprovals", includeMyGroupApprovals);
                this.put("queryOrder", queryOrder.toString().toLowerCase());
                this.put("releaseIdsFilter", String.join((CharSequence)",", ReleaseApi.this.intArrayToString(releaseIdsFilter)));
                this.put("statusFilter", statusFilter);
                this.put("top", top);
                this.put("typeFilter", typeFilter.toString().toLowerCase());
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "efc2f575-36ef-48e9-b672-0c6fb4a48ac5", this.CONNECTION.getProject(), "release/releases".replace("releases", "approvals"), null, null, "7.1-preview.3", q, null, null);
        return this.MAPPER.mapJsonResponse(r, ReleaseApprovals.class);
    }

    @Override
    public ReleaseApproval updateApproval(int approvalId, final ReleaseApprovalStatus status, final String comments) throws AzDException {
        HashMap<String, Object> body = new HashMap<String, Object>(){
            {
                this.put("status", status.toString().toLowerCase());
                this.put("comments", comments);
            }
        };
        String r = RestClient.send(RequestMethod.PATCH, this.CONNECTION, "efc2f575-36ef-48e9-b672-0c6fb4a48ac5", this.CONNECTION.getProject(), "release/releases".replace("releases", "approvals"), Integer.toString(approvalId), null, "7.1-preview.3", null, body, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, ReleaseApproval.class);
    }

    @Override
    public ManualIntervention getManualIntervention(int releaseId, int manualInterventionId) throws AzDException {
        String id = releaseId + "/manualinterventions/" + manualInterventionId;
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "efc2f575-36ef-48e9-b672-0c6fb4a48ac5", this.CONNECTION.getProject(), "release/releases", id, null, "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, ManualIntervention.class);
    }

    @Override
    public ManualInterventions getManualInterventions(int releaseId) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "efc2f575-36ef-48e9-b672-0c6fb4a48ac5", this.CONNECTION.getProject(), "release/releases", Integer.toString(releaseId), null, "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, ManualInterventions.class);
    }

    @Override
    public ManualIntervention updateManualIntervention(int releaseId, int manualInterventionId, final String comment, final ManualInterventionStatus status) throws AzDException {
        HashMap<String, Object> body = new HashMap<String, Object>(){
            {
                this.put("status", status.toString().toLowerCase());
                this.put("comment", comment);
            }
        };
        String id = releaseId + "/manualinterventions/" + manualInterventionId;
        String r = RestClient.send(RequestMethod.PATCH, this.CONNECTION, "efc2f575-36ef-48e9-b672-0c6fb4a48ac5", this.CONNECTION.getProject(), "release/releases", id, null, "7.1-preview.1", null, body, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, ManualIntervention.class);
    }

    private String intArrayToString(int[] i) {
        CharSequence[] r = (String[])Arrays.stream(i).mapToObj(String::valueOf).toArray(String[]::new);
        return String.join((CharSequence)",", r);
    }
}

