/*
 * Decompiled with CFR 0.152.
 */
package org.azd.serviceendpoint;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.azd.connection.Connection;
import org.azd.core.CoreApi;
import org.azd.core.types.Project;
import org.azd.enums.CustomHeader;
import org.azd.enums.RequestMethod;
import org.azd.enums.ServiceEndpointActionFilter;
import org.azd.exceptions.AzDException;
import org.azd.helpers.JsonMapper;
import org.azd.interfaces.ServiceEndpointDetails;
import org.azd.serviceendpoint.types.ServiceEndpoint;
import org.azd.serviceendpoint.types.ServiceEndpoints;
import org.azd.utils.AzDAsyncApi;
import org.azd.utils.RestClient;

public class ServiceEndpointApi
extends AzDAsyncApi<ServiceEndpointApi>
implements ServiceEndpointDetails {
    private final Connection CONNECTION;
    private final JsonMapper MAPPER = new JsonMapper();
    private final String AREA = "serviceendpoint";
    private final String SERVICE_ENDPOINT = "1814ab31-2f4f-4a9f-8761-f4d77dc5a5d7";
    private final CoreApi CORE;

    public ServiceEndpointApi(Connection connection) {
        this.CONNECTION = connection;
        this.CORE = new CoreApi(this.CONNECTION);
    }

    @Override
    public ServiceEndpoint createServiceEndpoint(String endpointName, String endpointType, Map requestBody) throws AzDException {
        requestBody.put("name", endpointName);
        requestBody.put("type", endpointType);
        String r = RestClient.send(RequestMethod.POST, this.CONNECTION, "1814ab31-2f4f-4a9f-8761-f4d77dc5a5d7", null, "serviceendpoint/endpoints", null, null, "7.1-preview.4", null, requestBody, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, ServiceEndpoint.class);
    }

    @Override
    public ServiceEndpoint createAzureRMServiceEndpoint(final String endpointName, final String servicePrincipalId, final String servicePrincipalKey, final String tenantId, final String subscriptionId, final String subscriptionName) throws AzDException {
        final Project project = this.CORE.getProject(this.CONNECTION.getProject());
        LinkedHashMap<String, Object> ref = new LinkedHashMap<String, Object>(){
            {
                this.put("projectReference", new LinkedHashMap<String, Object>(){
                    {
                        this.put("id", project.getId());
                        this.put("name", project.getName());
                    }
                });
                this.put("name", endpointName);
            }
        };
        final List<1> lRef = List.of(ref);
        LinkedHashMap<String, Object> body = new LinkedHashMap<String, Object>(){
            {
                this.put("authorization", new LinkedHashMap<String, Object>(){
                    {
                        this.put("parameters", new LinkedHashMap<String, Object>(){
                            {
                                this.put("tenantid", tenantId);
                                this.put("serviceprincipalid", servicePrincipalId);
                                this.put("authenticationType", "spnKey");
                                this.put("serviceprincipalkey", servicePrincipalKey);
                            }
                        });
                        this.put("scheme", "ServicePrincipal");
                    }
                });
                this.put("data", new LinkedHashMap<String, Object>(){
                    {
                        this.put("subscriptionId", subscriptionId);
                        this.put("subscriptionName", subscriptionName);
                        this.put("environment", "AzureCloud");
                        this.put("scopeLevel", "Subscription");
                        this.put("creationMode", "Manual");
                    }
                });
                this.put("url", "https://management.azure.com/");
                this.put("isShared", false);
                this.put("isReady", true);
                this.put("serviceEndpointProjectReferences", lRef);
            }
        };
        return this.createServiceEndpoint(endpointName, "azurerm", body);
    }

    @Override
    public ServiceEndpoint getServiceEndpoint(String endpointId) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "1814ab31-2f4f-4a9f-8761-f4d77dc5a5d7", this.CONNECTION.getProject(), "serviceendpoint/endpoints", endpointId, null, "7.1-preview.4", null, null, null);
        return this.MAPPER.mapJsonResponse(r, ServiceEndpoint.class);
    }

    @Override
    public ServiceEndpoint getServiceEndpoint(String endpointId, final ServiceEndpointActionFilter actionFilter) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("actionFilter", actionFilter.toString().toLowerCase());
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "1814ab31-2f4f-4a9f-8761-f4d77dc5a5d7", this.CONNECTION.getProject(), "serviceendpoint/endpoints", endpointId, null, "7.1-preview.4", q, null, null);
        return this.MAPPER.mapJsonResponse(r, ServiceEndpoint.class);
    }

    @Override
    public ServiceEndpoints getServiceEndpoints() throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "1814ab31-2f4f-4a9f-8761-f4d77dc5a5d7", this.CONNECTION.getProject(), "serviceendpoint/endpoints", null, null, "7.1-preview.4", null, null, null);
        return this.MAPPER.mapJsonResponse(r, ServiceEndpoints.class);
    }

    @Override
    public Void deleteServiceEndpoint(String endpointId, final String[] projectIds) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("projectIds", String.join((CharSequence)",", projectIds));
            }
        };
        String r = RestClient.send(RequestMethod.DELETE, this.CONNECTION, "1814ab31-2f4f-4a9f-8761-f4d77dc5a5d7", this.CONNECTION.getProject(), "serviceendpoint/endpoints", endpointId, null, "7.1-preview.4", q, null, null);
        if (!r.isEmpty()) {
            this.MAPPER.mapJsonResponse(r, Map.class);
        }
        return null;
    }

    @Override
    public Void deleteServiceEndpoint(String endpointId, final String[] projectIds, final boolean deep) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("projectIds", String.join((CharSequence)",", projectIds));
                this.put("deep", deep);
            }
        };
        String r = RestClient.send(RequestMethod.DELETE, this.CONNECTION, "1814ab31-2f4f-4a9f-8761-f4d77dc5a5d7", this.CONNECTION.getProject(), "serviceendpoint/endpoints", endpointId, null, "7.1-preview.4", q, null, null);
        if (!r.isEmpty()) {
            this.MAPPER.mapJsonResponse(r, Map.class);
        }
        return null;
    }

    @Override
    public ServiceEndpoints getServiceEndpointsByNames(final String[] endpointNames) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("endpointNames", String.join((CharSequence)",", endpointNames));
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "1814ab31-2f4f-4a9f-8761-f4d77dc5a5d7", this.CONNECTION.getProject(), "serviceendpoint/endpoints", null, null, "7.1-preview.4", q, null, null);
        return this.MAPPER.mapJsonResponse(r, ServiceEndpoints.class);
    }

    @Override
    public ServiceEndpoints getServiceEndpointsByNames(final String[] endpointNames, final String[] authSchemes, final boolean includeDetails, final boolean includeFailed, final String owner, final String type) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("endpointNames", String.join((CharSequence)",", endpointNames));
                this.put("type", type);
                this.put("authSchemes", String.join((CharSequence)",", authSchemes));
                this.put("owner", owner);
                this.put("includeFailed", includeFailed);
                this.put("includeDetails", includeDetails);
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "1814ab31-2f4f-4a9f-8761-f4d77dc5a5d7", this.CONNECTION.getProject(), "serviceendpoint/endpoints", null, null, "7.1-preview.4", q, null, null);
        return this.MAPPER.mapJsonResponse(r, ServiceEndpoints.class);
    }

    @Override
    public Void shareServiceEndpoint(String endpointId, String projectName, final String connectionName) throws AzDException {
        final Project project = this.CORE.getProject(projectName);
        LinkedHashMap<String, Object> body = new LinkedHashMap<String, Object>(){
            {
                this.put("projectReference", new LinkedHashMap<String, Object>(){
                    {
                        this.put("id", project.getId());
                        this.put("name", project.getName());
                    }
                });
                this.put("name", connectionName);
            }
        };
        ArrayList<8> ref = new ArrayList<8>();
        ref.add(body);
        String r = RestClient.send(RequestMethod.PATCH, this.CONNECTION, "1814ab31-2f4f-4a9f-8761-f4d77dc5a5d7", this.CONNECTION.getProject(), "serviceendpoint/endpoints", endpointId, null, "7.1-preview.4", null, ref, CustomHeader.JSON_CONTENT_TYPE);
        if (!r.isEmpty()) {
            this.MAPPER.mapJsonResponse(r, Map.class);
        }
        return null;
    }

    @Override
    public ServiceEndpoint updateServiceEndpoint(String endpointId, Map requestBody) throws AzDException {
        String r = RestClient.send(RequestMethod.PUT, this.CONNECTION, "1814ab31-2f4f-4a9f-8761-f4d77dc5a5d7", this.CONNECTION.getProject(), "serviceendpoint/endpoints", endpointId, null, "7.1-preview.4", null, requestBody, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, ServiceEndpoint.class);
    }
}

